#!/bin/bash

#####################################################################################################
# usage: ./Avaliacao.sh
# 
# Dadas uma CD e uma directoria avalia todos os ficheiros .xml que estiverem nessa directoria e 
# produz uma pagina .html de resultados.             
#
# Parametros de configuracao do script:
#   cdharem:      nome da CD  
#   diravaliacao: directoria raiz onde se encontra a directoria Av_HAREM_XML como os programas.
#   info:         argumento com nome do ficheiro com as informacoes sobre os participantes/saidas.
#   dirpartic:    argumento com nome da directoria onde se encontram os ficheiros .xml para avaliar;
#                 a directoria deve estar dentro de Av_HAREM_XML.
#
# last revision: Cristina Mota, 23.Junho.2008
# copyright: Linguateca
#####################################################################################################


##shopt -s expand_aliases

##alias java16=/System/Library/Frameworks/JavaVM.framework/Versions/1.6/Commands/java

##JAVA_HOME=/System/Library/Frameworks/JavaVM.framework/Versions/1.6/Home

### Constantes ###

declare -a str_tipo_cenario
str_tipo_cenario[1]="total"
str_tipo_cenario[2]="cenario2"
str_tipo_cenario[3]="pessoa"
str_tipo_cenario[4]="tempo"
str_tipo_cenario[5]="cenario3"
str_tipo_cenario[6]="cenario4"
str_tipo_cenario[7]="cenario5"
str_tipo_cenario[8]="cenario6"

declare -a str_modo
str_modo[0]="classico"
str_modo[1]="estendido_completo"
str_modo[2]="tempo_semnorm"
str_modo[3]="tempo_sonorm"
str_modo[4]="expansao-partsim"
str_modo[5]="expansao-partnao"

declare -a str_exppart
str_exppart[0]="sim"
str_exppart[1]="nao"

classico=0
completo=1
semnorm=2
sonorm=3
exppsim=4
exppnao=5

total=1
selectivo=4

exp_psim=0
exp_pnao=1

declare -a cenario
#cenario[1]="PESSOA(*):LOCAL(*):ORGANIZACAO(*):ABSTRACCAO(*):ACONTECIMENTO(*):OBRA(*):COISA(*):OUTRO(*):VALOR(*):TEMPO(*)"
cenario[1]="*"
cenario[2]="LOCAL(FISICO{*};HUMANO{*}):PESSOA:ORGANIZACAO:TEMPO"
cenario[3]="PESSOA"
cenario[4]="TEMPO(*)"
cenario[5]="ABSTRACCAO:ACONTECIMENTO:COISA:LOCAL:OBRA:ORGANIZACAO:OUTRO:PESSOA"
cenario[6]="ABSTRACCAO(DISCIPLINA;ESTADO;IDEIA;NOME;OUTRO):ACONTECIMENTO(EFEMERIDE;EVENTO;ORGANIZADO;OUTRO):COISA(CLASSE;MEMBROCLASSE;OBJECTO;OUTRO;SUBSTANCIA):LOCAL(FISICO;HUMANO;VIRTUAL):OBRA(ARTE;OUTRO;PLANO;REPRODUZIDA):ORGANIZACAO(ADMINISTRACAO;EMPRESA;INSTITUICAO;OUTRO):OUTRO:PESSOA(CARGO;GRUPOCARGO;GRUPOIND;GRUPOMEMBRO;INDIVIDUAL;MEMBRO;OUTRO;POVO):TEMPO(DURACAO;FREQUENCIA;GENERICO;OUTRO;TEMPO_CALEND):VALOR(CLASSIFICACAO;MOEDA;OUTRO;QUANTIDADE)"
cenario[7]="LOCAL(FISICO{*};HUMANO{*})"
cenario[8]="ACONTECIMENTO(*):LOCAL(*):OBRA(*):ORGANIZACAO(*):OUTRO(*):PESSOA(*):TEMPO(*):VALOR(*)"

lib=.:lib/jdom.jar
estilo="-estilo muc"

# ----------------------------
#
# usage: avalia_ficheiro <CENARIO> <MODO>
#
# Invoca a sequencia de programas de avaliacao usando como ponto de partida um ficheiro .xml e uma CD. 
# 
# O argumento <CENARIO> indica o cenario de avaliacao:
#  1 - cenario total
#  [2-8] - indice que indica o cenario selectivo
#
# O argumento MODO especifica o modo de avaliacao:
#  0 - HAREM classico, ou seja, nao faz avaliacao dos atributos estendidos de TEMPO
#  1 - HAREM classico com pista TEMPO completo, ou seja inclui a avaliacao de todos os atributos estendidos de TEMPO
#  2 - HAREM classico com pista TEMPO sem normalizacao, ou seja inclui a avaliacao de TEMPO_REF e SENTIDO
#  3 - HAREM classico com pista TEMPO so' com normalizacao, ou seja inclui a avaliacao de VAL_DELTA e VAL_NORM
#
#
# A nao ser que seja invocado pelo comando "avalia" e' necessario definir:
#  submissao: nome do ficheiro a avaliar
#  cdharem:   nome da CD
#  ficheiro:  nome inicial do ficheiro de saida 
# ----------------------------

avalia_ficheiro(){
    cd $diravaliacao/Av_HAREM_XML;
    ficheiro_c=$submissao.${pista}_classico.${str_tipo_cenario[$1]}
    ficheiro_e=$submissao.${pista}_${str_modo[$2]}.${str_tipo_cenario[$1]}
    echo "CD: " $cdharem
    echo "TST: " $submissao
    echo "OUT: " $ficheiro_c 
    echo "OUT_e: " $ficheiro_e
    set -f
    echo "Cenario: " $cenario_avaliacao
    set +f 
    if [ -f $ficheiro_c.alinhado.avalida.veu.alts.emir ]; then 
	echo "A versão clássica já existe para o ficheiro $submissao. A avaliação clássica não foi repetida.";
    else
	java -Xmx512M -Dfile.encoding=ISO-8859-1 -cp $lib pt.linguateca.harem.Aligner -submissao $submissao -cd $cdharem > $ficheiro_c.alinhado;
	java -Dfile.encoding=ISO-8859-1 -cp $lib pt.linguateca.harem.IndividualAlignmentEvaluator -alinhamento $ficheiro_c.alinhado > $ficheiro_c.alinhado.avalida;
	set -f
	java -Dfile.encoding=ISO-8859-1 -cp $lib pt.linguateca.harem.AlignmentFilter -alinhamento $ficheiro_c.alinhado.avalida $estilo $cenario_sistema $cenario_avaliacao > $ficheiro_c.alinhado.avalida.veu;
	set +f
	java -Dfile.encoding=ISO-8859-1 -cp $lib pt.linguateca.harem.AltAlignmentOrganizer -alinhamento $ficheiro_c.alinhado.avalida.veu > $ficheiro_c.alinhado.avalida.veu.alts;
	java -Dfile.encoding=ISO-8859-1 -cp $lib pt.linguateca.harem.SemanticAlignmentEvaluator -alinhamento $ficheiro_c.alinhado.avalida.veu.alts > $ficheiro_c.alinhado.avalida.veu.alts.emir; 
#	java -Dfile.encoding=ISO-8859-1 -cp $lib pt.linguateca.harem.SemanticAltAlignmentSelector -alinhamento $ficheiro_c.alinhado.avalida.veu.alts.emir > $ficheiro_c.alinhado.avalida.veu.alts.emir.altrel;
	java -Dfile.encoding=ISO-8859-1 -cp $lib pt.linguateca.harem.GlobalSemanticEvaluator -alinhamento $ficheiro_c.alinhado.avalida.veu.alts.emir > $ficheiro_c.alinhado.avalida.veu.alts.emir.ida;
#	java -Dfile.encoding=ISO-8859-1 -cp $lib pt.linguateca.harem.GlobalSemanticEvaluator -alinhamento $ficheiro_c.alinhado.avalida.veu.alts.emir.altrel > $ficheiro_c.alinhado.avalida.veu.alts.emir.altrel.ida;
    fi;
    ## Avaliacao Pista TEMPO
    if (( $2>=$completo && $2<=$sonorm )); then
	gawk -f ../AvalTEMPO.awk -v MODO=$2 $ficheiro_c.alinhado.avalida.veu.alts.emir  > $ficheiro_e.alinhado.avalida.veu.alts.emir.tempo;	
	java -Dfile.encoding=ISO-8859-1 -cp $lib pt.linguateca.harem.GlobalSemanticEvaluator -alinhamento $ficheiro_e.alinhado.avalida.veu.alts.emir.tempo > $ficheiro_e.alinhado.avalida.veu.alts.emir.tempo.ida;
    fi;
    ## Avaliacao Pista ReRelEM
    if (( $2>=$exppsim )); then
	exptudo="-exptudo ${str_exppart[${2}-${exppsim}]}"
	java -Dfile.encoding=ISO-8859-1 -cp $lib pt.linguateca.harem.RelationExpander -alinhamento $ficheiro_c.alinhado.avalida.veu.alts $exptudo > $ficheiro_e.alinhado.avalida.veu.alts.expandido
	java -Dfile.encoding=ISO-8859-1 -cp $lib pt.linguateca.harem.IDNormalizer -alinhamento $ficheiro_e.alinhado.avalida.veu.alts.expandido > $ficheiro_e.alinhado.avalida.veu.alts.expandido.normalizado
	java -Dfile.encoding=ISO-8859-1 -cp $lib pt.linguateca.harem.RelationsEvaluator -alinhamento $ficheiro_e.alinhado.avalida.veu.alts.expandido.normalizado > $ficheiro_e.alinhado.avalida.veu.alts.expandido.normalizado.avaliado
	java -Dfile.encoding=ISO-8859-1 -cp $lib pt.linguateca.harem.GlobalRelationsEvaluator -alinhamento $ficheiro_e.alinhado.avalida.veu.alts.expandido.normalizado.avaliado > $ficheiro_e.alinhado.avalida.veu.alts.expandido.normalizado.avaliado.resumo
    fi;
#    rm -f $dirpartic/*.avalida $dirpartic/*.veu $dirpartic/*.alts 
}



# ----------------------------
#
# usage: avalia <CENARIO> <MODO>
#
# Invoca a sequencia de programas de avaliacao. 
# 
# O argumento <CENARIO> especifica o cenario de avaliacao. Pode ter um valor numerico de 1 ate' ao limite de cenarios dos arrays $str_tipo_cenario e $cenario:
#  1 - cenario total
#  [2-8] - indice que indica o cenario selectivo
#
# O argumento <MODO> especifica o modo de avaliacao:
#  0 - HAREM classico, ou seja, nao faz avaliacao dos atributos estendidos de TEMPO
#  1 - HAREM classico com pista TEMPO completo, ou seja inclui a avaliacao de todos os atributos estendidos de TEMPO
#  2 - HAREM classico com pista TEMPO sem normalizacao, ou seja inclui a avaliacao de TEMPO_REF e SENTIDO
#  3 - HAREM classico com pista TEMPO so' com normalizacao, ou seja inclui a avaliacao de VAL_DELTA e VAL_NORM
#
# ----------------------------
avalia(){
    cenario_sistema="-sistema ${cenario[$1]}"
    cenario_avaliacao="-avaliacao ${cenario[$1]}"
    for submissao in ${dirpartic/-dir /}/partic??/*.xml; do
	avalia_ficheiro $1 $2;
    done;
    filtro="-filtro ${pista}_classico.${str_tipo_cenario[$1]}.alinhado.avalida.veu.alts.emir.ida"
    java -Dfile.encoding=ISO-8859-1 -cp $lib pt.linguateca.harem.GlobalSemanticReporter -depurar $filtro $dirpartic $info > resultados${pista}_classico_${str_tipo_cenario[$1]}.html;
    if (( $2>=$completo && $2<=$sonorm )); then 
	filtro="-filtro $pista_${str_modo[$2]}.${str_tipo_cenario[$1]}.alinhado.avalida.veu.alts.emir.tempo.ida"
	java -Dfile.encoding=ISO-8859-1 -cp $lib pt.linguateca.harem.GlobalSemanticReporter -depurar $filtro $dirpartic $info > resultados${pista}_${str_modo[$2]}_${str_tipo_cenario[$1]}.html;
    fi;
    if (( $2>=$exppsim )); then 
	filtro="-filtro $pista_${str_modo[$2]}.${str_tipo_cenario[$1]}.alinhado.avalida.veu.alts.expandido.normalizado.avaliado.resumo"
	java -Dfile.encoding=ISO-8859-1 -cp $lib pt.linguateca.harem.GlobalRelationsReporter -depurar $filtro $dirpartic $info > resultados${pista}_${str_modo[$2]}_${str_tipo_cenario[$1]}.html;
    fi;
}


# cenario[1]="PESSOA(*):LOCAL(*):ORGANIZACAO(*):ABSTRACCAO(*):ACONTECIMENTO(*):OBRA(*):COISA(*):OUTRO(*):VALOR(*):TEMPO(*)"
# cenario[2]="LOCAL(FISICO{*};HUMANO{*}):PESSOA:ORGANIZACAO:TEMPO"
# cenario[4]="TEMPO(*)"
# cenario[6]="ABSTRACCAO(DISCIPLINA;ESTADO;IDEIA;NOME;OUTRO):ACONTECIMENTO(EFEMERIDE;EVENTO;ORGANIZADO;OUTRO):COISA(CLASSE;MEMBROCLASSE;OBJECTO;OUTRO;SUBSTANCIA):LOCAL(FISICO;HUMANO;VIRTUAL):OBRA(ARTE;OUTRO;PLANO;REPRODUZIDA):ORGANIZACAO(ADMINISTRACAO;EMPRESA;INSTITUICAO;OUTRO):OUTRO:PESSOA(CARGO;GRUPOCARGO;GRUPOIND;GRUPOMEMBRO;INDIVIDUAL;MEMBRO;OUTRO;POVO):TEMPO(DURACAO;FREQUENCIA;GENERICO;OUTRO;TEMPO_CALEND):VALOR(CLASSIFICACAO;MOEDA;OUTRO;QUANTIDADE)"
# cenario[8]="ACONTECIMENTO(*):LOCAL(*):OBRA(*):ORGANIZACAO(*):OUTRO(*):PESSOA(*):TEMPO(*):VALOR(*)"

diravaliacao=~/data/users/cristina/harem-II/avaliacao
dirpartic="-dir participacoes"
info="-info lista_participantes.comsubdir.csv"

cdharem=CDSegundoHAREM_TEMPO.pub.xml

pista="TEMPO_estendido"
# for (( i=1; i<=8; i++ )); do
#     avalia $i $completo
#     avalia $i $semnorm
#     avalia $i $sonorm
# done;


cdharem=../cdharem.rerelem.t1.xml

pista="ReRelEM"

avalia 1 $exppsim
avalia 7 $exppsim

avalia 1 $exppnao
avalia 7 $exppnao


 