package pt.linguateca.harem;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;

import pt.linguateca.relations.RelatedEntity;

public class GlobalRelationsEvaluator extends GlobalEvaluator{

	public static final String HEADER = "Avalia\u00e7\u00e3o do ReRelEM";
	public static final String FILTER = "Descri\u00e7\u00e3o do cen\u00e1rio avaliado";

	public static final String CORELS_HEADER = "Apenas CORELs";

	public static final String RELATIONS_HEADER = "Rela\u00e7\u00f5es";


	public static final String SCORE_HEADER = "Pontua\u00e7\u00e3o ReRelEM";
	public static final String SCORE_IN_GC = "Pontua\u00e7\u00e3o na CD";
	public static final String MAXIMUM_SYSTEM_SCORE = "Pontua\u00e7\u00e3o m\u00e1xima poss\u00edvel do Sistema";
	public static final String SYSTEM_SCORE = "Pontua\u00e7\u00e3o do Sistema";

	public static final String PRECISION = "Precis\u00e3o";
	public static final String RECALL = "Abrang\u00eancia";
	public static final String F_MEASURE = "Medida F";

	private static final boolean IGNORE_SPURIOUS_IDS = true;
	
	public GlobalRelationsEvaluator(String alignments, boolean useTags, boolean debug)
	{
		super(alignments, useTags, debug);
		new Thread(this).start();
	}

	@Override
	public void run() {

		BufferedReader reader = null;
		String buffer;
		RelatedEntity golden = null;
		RelatedEntity aligned = null;
		LinkedList<NamedEntity> entities;
		RelationsScoreParser parser = new RelationsScoreParser(IGNORE_SPURIOUS_IDS);

		double currentScore;

		double maximumScoreInGc = 0.0;
		double maximumSystemScore = 0.0;

		double totalScore = 0.0;

		int totalCorelsInGC = 0;
		int totalCorelsInPart = 0;
		
		int totalCorrectCorels = 0;
		int totalSpuriousCorels = 0;
		int totalMissingCorels = 0;

		int totalRelationsInGC = 0;
		int totalRelationsInPart = 0;
		
		int totalCorrectRelations = 0;
		int totalSpuriousRelations = 0;
		int totalMissingRelations = 0;	

		int currentRelationsInPart = 0;
		int currentCorrectRelations = 0;
		int currentCorrectCorels = 0;
		int currentSpuriousCorels = 0;

		try
		{
			reader = new BufferedReader(new FileReader(_alignmentsFile));

			System.out.println(HEADER);
			System.out.println(FILTER);
			System.out.println("\t"+reader.readLine());
			System.out.println("");

			while ((buffer = reader.readLine()) != null)
			{
				if (!isEvaluatable(buffer))
				{
					//System.out.println(buffer);
					continue;
				}

				if(_debug)
					System.out.println(buffer);
				
				String[] parts = buffer.split(Aligner.ALIGNMENT_CONNECTOR+"|"+IndividualAlignmentEvaluator.EVALUATION_MARKER);
				if(parts.length != 3)
				{
					System.out.println(buffer);
					continue;
				}

				golden = new RelatedEntity(new NamedEntity(parts[0]));

				entities = NamedEntity.toNamedEntityList(parts[1]);
				if(!entities.isEmpty())
				{
					aligned = new RelatedEntity(entities.get(0));
					totalCorelsInPart += aligned.getRelationsList().getRelatedIdsNoRepetitionNoSpurious().size(); //Sem CORELs repetidos e IDs de EMs esprias
					//currentRelationsInPart = aligned.getRelationsList().getAllRelatedIdsNoSpurious().size(); //Sem contar com relaes onde uma EM  espria
					currentRelationsInPart = aligned.getRelationsList().relationsWithoutSpuriousArguments().size(); //Sem contar com relaes onde uma EM  espria
					
					totalRelationsInPart += currentRelationsInPart;
				} else
					currentRelationsInPart = 0;

				parser.setBuffer(parts[2]);

				currentCorrectRelations = parser.getNumberOfCorrectRelations();
				currentCorrectCorels = parser.getNumberOfCorrectCorels();
				currentSpuriousCorels = parser.getNumberOfSpuriousCorels();

				//CORELs
				totalCorelsInGC += golden.getRelationsList().getRelatedIdsNoRepetition().size(); //Sem CORELs repetidos

				totalCorrectCorels += currentCorrectCorels;
				totalSpuriousCorels += currentSpuriousCorels;
				totalMissingCorels += parser.getNumberOfMissingCorels();


				if(_debug)
				{
					if((totalCorrectCorels+totalSpuriousCorels) != totalCorelsInPart)
					{
						System.out.println("currentCorrectCorels = "+currentCorrectCorels);
						System.out.println("currentSpuriousCorels = "+currentSpuriousCorels);
						System.out.println("currentNumberOfCorelsInPart = "+aligned.getRelationsList().getRelatedIdsNoRepetitionNoSpurious().size());
						return;
					}
					
					if((totalCorrectCorels+totalMissingCorels) != totalCorelsInGC)
					{
						System.out.println("currentCorrectCorels = "+currentCorrectCorels);
						System.out.println("currentMissingCorels = "+parser.getNumberOfMissingCorels());
						System.out.println("currentNumberOfCorelsInGC = "+golden.getRelationsList().getRelatedIdsNoRepetition().size());
						return;
					}
				}

				//Relacoes
				totalRelationsInGC += golden.getRelationsList().size();

				totalCorrectRelations += currentCorrectRelations;
				totalSpuriousRelations += (currentRelationsInPart - currentCorrectRelations);
				totalMissingRelations += (golden.getRelationsList().size() - currentCorrectRelations);				
				
				if(_debug)
				{
					if((totalCorrectRelations+totalSpuriousRelations) != totalRelationsInPart)
					{
						System.out.println("correctRelations = "+totalCorrectRelations);
						System.out.println("spuriousRelations = "+totalSpuriousRelations);
						System.out.println("totalRelationsInPart = "+totalRelationsInPart);
						return;
					}
					
					if((totalCorrectRelations+totalMissingRelations) != totalRelationsInGC)
					{
						System.out.println("correctRelations = "+totalCorrectRelations);
						System.out.println("missingRelations = "+totalMissingRelations);
						System.out.println("totalRelationsInGC = "+totalRelationsInGC);
						return;
					}
				}
				
				
				
				//Pontuacao
				currentScore = parser.getEvaluation();
				maximumScoreInGc += parser.getMaximumGCEval();
				maximumSystemScore += parser.getMaximumSystemEval();
				totalScore += currentScore;
			}
		}
		catch (IOException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		double precision = (double) totalCorrectCorels / (double) totalCorelsInPart;
		double recall = (double) totalCorrectCorels / (double) totalCorelsInGC;
		double f = (2 * precision * recall) / (precision + recall);

		System.out.println(CORELS_HEADER);
		System.out.println(TOTAL_IN_GC + ": " + totalCorelsInGC);
		System.out.println(TOTAL_IDENTIFIED + ": " + totalCorelsInPart);
		System.out.println(TOTAL_CORRECT_M + ": " + totalCorrectCorels);
		System.out.println(SPURIOUS + ": " + totalSpuriousCorels);
		System.out.println(MISSING + ": " + totalMissingCorels);
		System.out.println(PRECISION + ": " + precision);
		System.out.println(RECALL + ": " + recall);
		System.out.println(F_MEASURE + ": " + f);


		precision = (double) totalCorrectRelations / (double) totalRelationsInPart;
		recall = (double) totalCorrectRelations / (double) totalRelationsInGC;
		f = (2 * precision * recall) / (precision + recall);

		System.out.println("\n"+RELATIONS_HEADER);
		System.out.println(TOTAL_IN_GC + ": " + totalRelationsInGC);
		System.out.println(TOTAL_IDENTIFIED + ": " + totalRelationsInPart);
		System.out.println(TOTAL_CORRECT_F + ": " + totalCorrectRelations);
		System.out.println(SPURIOUS + ": " + totalSpuriousRelations);
		System.out.println(MISSING + ": " + totalMissingRelations);
		System.out.println(PRECISION + ": " + precision);
		System.out.println(RECALL + ": " + recall);
		System.out.println(F_MEASURE + ": " + f);


		precision = totalScore / maximumSystemScore;
		recall = totalScore / maximumScoreInGc;
		f = (2 * precision * recall) / (precision + recall);

		System.out.println("\n"+SCORE_HEADER);
		System.out.println(SCORE_IN_GC + ": " + maximumScoreInGc);
		System.out.println(MAXIMUM_SYSTEM_SCORE + ": " + maximumSystemScore);
		System.out.println(SYSTEM_SCORE + ": " + totalScore);
		System.out.println(PRECISION + ": " + precision);
		System.out.println(RECALL + ": " + recall);
		System.out.println(F_MEASURE + ": " + f);


		try
		{
			reader.close();
		}
		catch (IOException e)
		{
			e.printStackTrace();
		}
	}

	public static void main(String args[])
	{

		String alignments = null;
		boolean useTags = false;
		boolean debug = false;

		for (int i = 0; i < args.length; i++)
		{
			if (args[i].equals("-alinhamento"))
			{
				i++;
				alignments = args[i];
				continue;
			}

			if (args[i].equals("-etiquetas"))
			{
				i++;
				useTags = args[i].equalsIgnoreCase("sim");
				continue;
			}

			if (args[i].equals("-depurar") || args[i].equals("-debug"))
			{
				debug = true;
				continue;
			}
		}

		if (alignments == null)
		{
			printSynopsis();
			return;
		}

		new GlobalRelationsEvaluator(alignments, useTags, debug);
	}

	private static void printSynopsis()
	{
		System.out.println("Utiliza\u00e7\u00e3o:");
		System.out
		.println("java -Dfile.encoding=ISO-8859-1 -cp .;lib/jdom.jar pt.linguateca.harem.GlobalRelationsEvaluator -alinhamento <ficheiro_alinhamentos_corels_avaliados>");
		System.out.println("\n");
		System.out.println("Exemplo:");
		System.out
		.println("java -Dfile.encoding=ISO-8859-1 -cp .;lib/jdom.jar pt.linguateca.harem.GlobalRelationsEvaluator -alinhamento participacao.alinhado.avalida.veu.alts.emir.expandido.normalizado.avaliado");
	}
}
