package pt.linguateca.harem;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

import pt.linguateca.relations.RelatedEntity;

/** avaliacao do ReRelEM - passo 2 - normalizacao de IDs **/
public class IDNormalizer extends HaremEvaluator implements Runnable{

	private final String ID_SEP = "-";
	private long spuriousCounter;
	private EvaluatedAlignmentProcessor _processor;

	public IDNormalizer(String alignmentFile, boolean useTags)
	{
		super(alignmentFile, useTags);
		spuriousCounter = 1;
		_processor = new IdentificationEvaluatedAlignmentProcessor();
		new Thread(this).start();
	}

	public void run()
	{
		HashMap<String, String> idMap = new HashMap<String, String>();

		BufferedReader reader = null;
		String buffer;
		IdentificationEvaluatedAlignment current;
		LinkedList<IdentificationEvaluatedAlignment> alignments = null;

		try
		{
			reader = new BufferedReader(new FileReader(_alignmentsFile));
			buffer = reader.readLine();

			//filtro
			if(buffer.startsWith("#")){
				System.out.println(buffer);
			}

			while ((buffer = reader.readLine()) != null)
			{
				//DOC DOCID
				if(buffer.startsWith(_tagBase.getDocTag()))
				{
					if(alignments != null)
						printAlignments(normalize(alignments, idMap));

					alignments = new LinkedList<IdentificationEvaluatedAlignment>();
					System.out.println("\n"+buffer);
					continue;
				}
				else if (!isEvaluatable(buffer))
				{
					//System.out.println(buffer);
					continue;
				}

				current = (IdentificationEvaluatedAlignment)_processor.getEvaluatedAlignment(buffer);
				alignments.add(current);
				putInMap(idMap, current.getGoldenEntity(), current.getFirstAlignment());
			}
			
			printAlignments(normalize(alignments, idMap));
		}
		catch (IOException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		try
		{
			reader.close();
		}
		catch (IOException e)
		{
			e.printStackTrace();
		}
	}

	private void putInMap(HashMap<String, String> map, NamedEntity golden, NamedEntity other)
	{
		if(other == null)
			return;

		else if(golden.isSpurious())
			map.put(other.getId(), getNextSpuriousId());

		else
			map.put(other.getId(), golden.getId());
	}

	private String getNextSpuriousId()
	{
		return _tagBase.getSpuriousTag()+ID_SEP+(spuriousCounter++);	
	}

	private LinkedList<IdentificationEvaluatedAlignment> normalize(
			LinkedList<IdentificationEvaluatedAlignment> alignments, HashMap<String, String> map){

		RelatedEntity aligned = null;
		String oldId = null;
		LinkedList<String> corels = null;
		LinkedList<String> normalizedCorels = null;
		
		for(IdentificationEvaluatedAlignment alignment : alignments)
		{
			if(!alignment.isNullAligned())
			{
				aligned = new RelatedEntity(alignment.getFirstAlignment());
				oldId = aligned.getId();
				aligned.setId(map.get(oldId));
				
				corels = aligned.getCorels();
				normalizedCorels = new LinkedList<String>();
				for(String s : corels)
				{
					normalizedCorels.add(map.get(s));
				}
				
				aligned.setCorels(normalizedCorels);
			}
		}

		return alignments;	
	}

	private void printAlignments(LinkedList<IdentificationEvaluatedAlignment> alignments)
	{
		for(IdentificationEvaluatedAlignment alignment : alignments)
			System.out.println(alignment);
	}

	public static boolean isSpuriousId(String id)
	{
		return id.startsWith(_tagBase.getSpuriousTag());
	}
		
	public static void main(String[] args)
	{
		String alignments = null;
		boolean useTags = false;

		for (int i = 0; i < args.length; i++)
		{
			if (args[i].equals("-alinhamento"))
			{
				i++;
				alignments = args[i];
				continue;
			}

			if (args[i].equals("-etiquetas"))
			{
				i++;
				useTags = args[i].equalsIgnoreCase("sim");
				continue;
			}
		}

		if (alignments == null)
		{
			printSynopsis();
			return;
		}

		new IDNormalizer(alignments, useTags);
	}

	private static void printSynopsis()
	{
		System.out.println("Utilizacao:" +
				"\njava -Dfile.encoding=ISO-8859-1 -cp .;lib/jdom.jar pt.linguateca.harem.IDNormalizer -alinhamento ficheiro.alinhado.alts.expandido");
	}
}
