package pt.linguateca.harem;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

import org.jdom.Element;

import pt.linguateca.relations.RelatedEntity;
import pt.linguateca.relations.Relation;

//relacoes numa CD para um CSV
public class PrintAllRelations extends Thread{

	private static final String SEP = ",";
	
	private DocumentReader _reader;
	private TagBase _tagBase;

	public PrintAllRelations(String file){

		_tagBase = TagBase.getInstance();
		_reader = new DocumentReader(file);
	}

	public void run()
	{		
		Element doc;
		NamedEntityTagParser parser = new NamedEntityTagParser();
		Iterator it = _reader.getIterator();
		HaremEntity current;
		RelatedEntity related;
		LinkedHashMap<String, RelatedEntity> map = null;
		//LinkedHashMap<String, RelatedEntity> map = new LinkedHashMap<String, RelatedEntity>();

		while(it.hasNext())
		{
			doc = (Element)it.next();
			parser.setDocument(doc);
			map = new LinkedHashMap<String, RelatedEntity>();
			while(parser.recognize()){

				current = parser.getEntity();

				if(current instanceof NamedEntity){
					
					related = new RelatedEntity((NamedEntity)current);
					map.put(related.getId(), related);
					

				} else if(current instanceof ALTEntity){
					ALTEntity alt = (ALTEntity)current;
					LinkedList<NamedEntity> entities = alt.getAllEntities();

					Iterator<NamedEntity> it_entities = entities.iterator();
					while(it_entities.hasNext()){

						related = new RelatedEntity(it_entities.next());
						map.put(related.getId(), related);

					}					
				}
			}
			
			printRelations(doc.getAttributeValue(_tagBase.getDocIDTag()), map);
		}
	}
	
	private void printRelations(String docid, Map<String, RelatedEntity> map)
	{
		System.out.println();
		printLine("DOC", docid, "", "", "", "", "");
		printHeader();
		
		for(RelatedEntity entity : map.values())
		{
			for(Relation r : entity.getRelationsList())
			{				
				printLine(
						map.get(r.getA()).getEntity(),
						r.getType(),
						map.get(r.getB()).getEntity(),
						r.getA(),
						reformatCategories(map.get(r.getA()).getCategories()),
						r.getB(),
						reformatCategories(map.get(r.getB()).getCategories())
						);
			}
		}
	}
	
	private String reformatCategories(LinkedList<String> categories)
	{
		return categories.toString().replace(", ", "|");
	}
	
	/*private String getIdPlusEntity(String id, Map<String, RelatedEntity> map)
	{
		return id+"_"+map.get(id).getEntity();
	}*/
	
	private void printHeader()
	{
		printLine("EM1", "TIPO", "EM2", "ID1", "CATEG1", "ID2", "CATEG2");
	}

	private void printLine(String col1, String col2, String col3, String col4, String col5, String col6, String col7)
	{
		System.out.println(col1+SEP+col2+SEP+col3+SEP+col4+SEP+col5+SEP+col6+SEP+col7);
	}
	
	public static void main(String args[]){

		if(args.length != 1)
			System.err.println("Utilizacao:\n" +
			"java PrintAllRelations <coleccao.xml>");
		else
			new PrintAllRelations(args[0]).start();
	}
}
