package pt.linguateca.harem;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

import pt.linguateca.relations.RelatedEntity;
import pt.linguateca.relations.Relation;
import pt.linguateca.relations.RelationsGraph;
import pt.linguateca.relations.RelationsList;
import pt.linguateca.relations.RelationsPair;
import pt.linguateca.relations.TransitiveRules;

/** avaliacao do ReRelEM - passo 1 **/
public class RelationExpander extends HaremEvaluator implements Runnable
{

	//TODO: ideia para diminuir o tempo de expanso:
	//guardar os pares que no resultaram em nada e no voltar a passar por eles 

	private boolean _expandParticipation;
	private boolean _debug;
	private EvaluatedAlignmentProcessor _processor;

	private static final int MAX_ITERATIONS = 10;

	public RelationExpander(String alignmentFile, boolean useTags, boolean expPart, boolean debug){
		super(alignmentFile, useTags);

		_expandParticipation = expPart;
		_debug = debug;
		_processor = new IdentificationEvaluatedAlignmentProcessor();

		new Thread(this).start();
	}

	public void run()
	{
		GregorianCalendar inicio = null;
		if(_debug)
		{
			inicio = new GregorianCalendar();
			System.out.println("inicio= "+getTime(inicio));
		}

		BufferedReader reader = null;
		String buffer;
		IdentificationEvaluatedAlignment current;
		RelationsGraph goldenGraph = null;
		RelationsGraph subGraph = null;

		LinkedList<IdentificationEvaluatedAlignment> alignments = null;

		//System.out.println("--- INICIO ---");
		Set<RelationsPair> noMoreExpansionGC = new HashSet<RelationsPair>();
		Set<RelationsPair> noMoreExpansionPart = new HashSet<RelationsPair>();

		try
		{
			reader = new BufferedReader(new FileReader(_alignmentsFile));
			buffer = reader.readLine();

			//filtro
			if(buffer.startsWith("#")){
				System.out.println(buffer);
			}			

			while ((buffer = reader.readLine()) != null)
			{
				if(buffer.startsWith(_tagBase.getDocTag()))
				{
					if(goldenGraph != null){
						if(_debug) System.out.println("GOLDEN:");
						expand(goldenGraph, noMoreExpansionGC);
					}

					if(subGraph != null && _expandParticipation){
						if(_debug) System.out.println("PART:");
						expand(subGraph, noMoreExpansionPart);
					}

					//mostrar os alinhamentos
					if(alignments != null)
						printAlignments(alignments);

					System.out.println("\n"+buffer);
					alignments = new LinkedList<IdentificationEvaluatedAlignment>();
					goldenGraph = new RelationsGraph();
					subGraph = new RelationsGraph();

					continue;
				}

				else if (!isEvaluatable(buffer))
				{
					//System.out.println(buffer); //TODO: alem dos ALTs nao aparecem ha' mais alguma coisa?
					continue;
				}

				current = (IdentificationEvaluatedAlignment) _processor.getEvaluatedAlignment(buffer);

				//eliminar os atributos que nao interessam...
				//current.removeClassicAttributes();
				current.removeComments();
				alignments.add(current);

				if(!current.getGoldenEntity().isSpurious())
					goldenGraph.addNode(new RelatedEntity(current.getGoldenEntity()));

				if(!current.isNullAligned()){
					Iterator<NamedEntity> i = current.getAligned();
					while(i.hasNext())
						subGraph.addNode(new RelatedEntity(i.next()));
				}
			}

			//isto tem de ser feito, porque o ficheiro nao acaba numa linha DOC
			if(_debug) System.out.println("GOLDEN:");
			expand(goldenGraph, noMoreExpansionPart);

			if(_expandParticipation)
			{
				if(_debug) System.out.println("PART:");
				expand(subGraph, noMoreExpansionPart);
			}

			printAlignments(alignments);
		}

		catch (IOException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		try
		{
			reader.close();
		}
		catch (IOException e)
		{
			e.printStackTrace();
		}

		if(_debug)
		{
			GregorianCalendar fim = new GregorianCalendar();
			System.out.println("fim= "+getTime(fim));
			System.out.println("tempo= "+getIntervalInSeconds(inicio, fim));
		}
	}

	private void expand(RelationsGraph graph, Set<RelationsPair> dontExpand)
	{
		//passado por referencia
		inverseRelations(graph);

		//System.out.println("graph 1:\n"+graph);
		int i = 0;
		while(transitiveRelations(graph, dontExpand) && ++i < MAX_ITERATIONS)
		{
			//System.out.println("graph "+(i+1)+":\n"+graph);

			/*if(_debug)
				for(RelatedEntity entity : graph.getAllNodes())
					detectInconsistence(entity, "");*/


			inverseRelations(graph);

			if(_debug) System.out.println("[----- Fim da iteracao n."+i+" -----]");
		}

		//transitiveRelations(graph);
	}

	private void inverseRelations(RelationsGraph graph)
	{
		//System.out.println("INVERSE RELATIONS");

		Relation inverse = null;
		RelatedEntity otherEntity = null;
		boolean addedRelation = false;

		//inverse relations;
		for(RelatedEntity entity : graph){
			for(Relation r : entity){

				if((inverse = _tagBase.getInverse(r)) != null){

					otherEntity = graph.get(inverse.getA());
					if(otherEntity != null && !otherEntity.containsRelation(inverse))
					{
						addedRelation = otherEntity.addEdge(inverse);
						if(_debug && addedRelation)
							System.out.println("Adicionada inversa: "+inverse);

					}
				}					
			}
		}
	}

	private boolean transitiveRelations(RelationsGraph graph, Set<RelationsPair> dontExpand)
	{	
		//System.out.println("TRANSITIVE RELATIONS");

		Relation transitive = null;
		boolean addedRelation = false;

		Iterator<RelatedEntity> i1 = graph.iterator(); //ns 1 
		Iterator<RelatedEntity> i2 = null; //ns 2
		RelatedEntity left = null;
		RelatedEntity right = null;

		ArrayList<RelatedEntity> entities = new ArrayList<RelatedEntity>(graph.getAllNodes());
		Set<Relation> toAdd = new HashSet<Relation>();

		TransitiveRules rules = TransitiveRules.getInstance(_tagBase);

		HashMap<Relation, String> _debugMap = new HashMap<Relation, String>();

		while(i1.hasNext())
		{
			left = i1.next();
			entities.remove(left);

			i2 = entities.iterator();
			//System.out.println("left = "+left);

			while(i2.hasNext())
			{
				right = i2.next();
				//System.out.println("right = "+right);

				for(Relation r1 : left.getRelationsList())
				{
					for(Relation r2 : right.getRelationsList())
					{
						if(dontExpand.contains(new RelationsPair(r1, r2)))
						{
							//System.out.print("#");
							continue;
						}

						//System.out.print("\n$");
						transitive = rules.getTransitiveRelation(r1, r2);
						if(transitive != null){

							//if(_debug) System.out.println(r1 + " e " + r2 + " --> " + transitive);
							if(_debug) _debugMap.put(transitive, r1 + " e " + r2 + " --> " + transitive);
							toAdd.add(transitive);

						} //else {
						//NO TEXTO MAIOR DA' OUTOFMEMORY...
						/* Exception in thread "Thread-0" java.lang.OutOfMemoryError: Java heap space
									at java.util.LinkedList.listIterator(Unknown Source)
									at java.util.AbstractList.listIterator(Unknown Source)
									at java.util.AbstractSequentialList.iterator(Unknown Source)
									at pt.linguateca.harem.TagBaseReader.getInverse(TagBaseReader.java:203)
									at pt.linguateca.harem.TagBase.getInverseType(TagBase.java:278)
									at pt.linguateca.relations.TransitiveRule.getInverse(TransitiveRule.java:66)
									at pt.linguateca.relations.TransitiveRule.getNormalizedRelation(TransitiveRule.java:59)
									at pt.linguateca.relations.TransitiveRule.getNormalizedPair(TransitiveRule.java:29)
									at pt.linguateca.relations.TransitiveRule.getTransitiveRelation(TransitiveRule.java:90)
									at pt.linguateca.relations.TransitiveRules.getTransitiveRelation(TransitiveRules.java:58)
									at pt.linguateca.harem.RelationExpander.transitiveRelations(RelationExpander.java:243)
									at pt.linguateca.harem.RelationExpander.expand(RelationExpander.java:162)
									at pt.linguateca.harem.RelationExpander.run(RelationExpander.java:79)
									at java.lang.Thread.run(Unknown Source)
						 */

						//dontExpand.add(new RelationsPair(r1, r2));
						//System.out.println();
						//}
					}
				}
			}
		}

		boolean test = false;
		//System.out.println("A adicionar: "+toAdd);

		//se a relao j existir, addEdge retorna false
		for(Relation r : toAdd)
		{		
			/*System.out.println("graph= "+graph);
			System.out.println("r.getA()= "+r.getA());
			System.out.println("graph.get(r.getA())= "+graph.get(r.getA()));*/

			if(!graph.containsNode(r.getA()))
			{
				System.err.println("COREL com ID inexistente! "+r.getA());
				continue;
			}

			test = (graph.get(r.getA())).addEdge(r);
			addedRelation = test || addedRelation;
			if(_debug && test)
			{
				System.out.println("Adicionada por transitividade:");
				System.out.println("\t"+_debugMap.get(r));
			}
		}	

		return addedRelation;
	}

	private void detectInconsistence(RelatedEntity entity, String where)
	{
		RelationsList relations = entity.getRelationsList();
		String inverse;
		Relation test;
		for(Relation r : relations)
		{		
			inverse = _tagBase.getInverseType(r.getType());

			if(inverse == null)
				continue;

			test = new Relation(inverse, r.getA(), r.getB());

			if(!test.equals(r) && relations.containsRelation(test))
			{
				//System.out.println(relations);
				System.out.println(where+": "+entity + " --> " +r + " e " + test);
				break;
			}
		}
	}

	private void printAlignments(LinkedList<IdentificationEvaluatedAlignment> alignments)
	{
		for(IdentificationEvaluatedAlignment al : alignments)
			System.out.println(al);
	}

	public static void main(String args[]){
		String alignments = null;
		boolean useTags = false;
		boolean debug = false;
		boolean expandParticipation = true;

		try{

			for (int i = 0; i < args.length; i++)
			{
				if (args[i].equals("-alinhamento"))
				{
					alignments = args[++i];
					continue;
				}

				if (args[i].equals("-exptudo"))
				{
					//default  expandir tudo
					expandParticipation = args[++i].equalsIgnoreCase("sim");
					continue;
				}

				if (args[i].equals("-etiquetas"))
				{
					useTags = args[++i].equalsIgnoreCase("sim");
					continue;
				}

				if (args[i].equals("-depurar") || args[i].equals("-debug"))
				{
					debug = true;
					continue;
				}
			}
		} catch (Exception e)
		{
			printSynopsis();
			return;
		}

		/*		try {
			System.setOut(new PrintStream("tempos"));
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}*/

		new RelationExpander(alignments, useTags, expandParticipation, debug);
	}

	/**
	 * No caso de os argumentos de entrada nao serem correctamente fornecidos.
	 * Este metodo imprime uma mensagem de ajuda para a consola.
	 * 
	 */
	private static void printSynopsis()
	{
		System.out.println("Utiliza\u00e7\u00e3o:");
		System.out
		.println("java -Dfile.encoding=ISO-8859-1 cp .;lib/jdom.jar [-Xmx512M] pt.linguateca.harem.RelationsExpander -alinhamento <ficheiro_alinhamentos_alts> [-exptudo <sim|nao>] [-etiquetas <sim|nao>]");
		System.out.println("\n");
		System.out.println("Exemplo:");
		System.out
		.println("java -Dfile.encoding=ISO-8859-1 cp .;lib/jdom.jar pt.linguateca.harem.RelationsExpander -alinhamento ficheiro.alinhado.alts -exptudo sim");
	}


	private String getTime(GregorianCalendar calendar)
	{
		return calendar.get(Calendar.HOUR_OF_DAY)
		+":"+calendar.get(Calendar.MINUTE)
		+":"+calendar.get(Calendar.SECOND);
	}

	private String getIntervalInSeconds(GregorianCalendar c1, GregorianCalendar c2)
	{
		long ms1 = c1.getTimeInMillis();
		long ms2 = c2.getTimeInMillis();
		long interval = Math.abs(ms1 - ms2);
		return Math.abs(interval/1000f)+"";
	}
}
