package pt.linguateca.harem;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

import pt.linguateca.relations.RelationAttributesEvaluation;

/** avaliacao do ReRelEM - passo 3 - pontuacao de Relacoes **/
public class RelationsEvaluator extends HaremEvaluator implements Runnable{

	private EvaluatedAlignmentProcessor _processor;
	
	private boolean IGNORE_SPURIOUS_IDS = true;
	
	public RelationsEvaluator(String alignmentFile, boolean useTags){

		super(alignmentFile, useTags);
		_processor = new IdentificationEvaluatedAlignmentProcessor();
		new Thread(this).start();
	}

	public void run()
	{	
		BufferedReader reader = null;
		String buffer;
		IdentificationEvaluatedAlignment current;
		RelationAttributesEvaluation evaluation;

		try
		{
			reader = new BufferedReader(new FileReader(_alignmentsFile));
			buffer = reader.readLine();

			//filtro
			if(buffer.startsWith("#")){
				System.out.println(buffer);
			}			

			while ((buffer = reader.readLine()) != null)
			{
				if(buffer.startsWith(_tagBase.getDocTag())){
					System.out.println(buffer);
					continue;
				}

				else if (!isEvaluatable(buffer))
				{
					//System.out.println(buffer); //TODO: alem dos ALTs nao aparecem ha' mais alguma coisa?
					continue;
				}

				current = (IdentificationEvaluatedAlignment) _processor.getEvaluatedAlignment(buffer);
				
				evaluation = new RelationAttributesEvaluation(current, IGNORE_SPURIOUS_IDS);
				evaluation.evaluate();
				
				System.out.println(current.getGoldenEntity() + Aligner.ALIGNMENT_CONNECTOR + 
						current.getAlignedList() + IndividualAlignmentEvaluator.EVALUATION_MARKER + evaluation);
			}
		}

		catch (IOException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		try
		{
			reader.close();
		}
		catch (IOException e)
		{
			e.printStackTrace();
		}
	}

	/*private double evaluate(IdentificationEvaluatedAlignment alignment){
		
		if(alignment.isNullAligned())
		{
			return 0.0;
		}
		
		else if(alignment.isSpurious())
		{
			return 0.0; //TODO: confirmar
		}
		
		else
		{
			
			//NOTA 1: Tentar avaliar s os corels, garantindo que um repetido nao pode
			//contar positivamente duas vezes nem negativamente duas vezes
			//e depois avaliar os TIPORels+COREL correspondente
			
			//NOTA 2: Ao comparar um tiporel que no faa parte dos iniciais
			//a sua comparao com outra deve dar true
			
			RelatedEntity golden = new RelatedEntity(alignment.getGoldenEntity());
			RelatedEntity other = new RelatedEntity(alignment.getAlignedList().get(0));
			
			RelationsList goldenRelations = golden.getRelationsList();
			RelationsList identifiedRelations = (RelationsList)other.getRelationsList().clone();
			
			double evaluation = 0.0;
			Set<String> penalizedIds = new HashSet<String>();
			
			//para isto, os IDs ja' tem de estar normalizados!
			for(Relation r : goldenRelations)
			{
				if(identifiedRelations.containsRelation(r))
				{
					evaluation += (COREL_CORRECT + TIPOREL_CORRECT);
					//identifiedRelations.removeRelation(r);
					//isto garante que o mesmo COREL no conta duas vezes como positivo
					identifiedRelations.removeAllRelationsWith(r.getB());
				}
				else if(identifiedRelations.containsRelationWith(r.getB()))
				{
					evaluation += COREL_CORRECT;
					identifiedRelations.removeAllRelationsWith(r.getB());
				}				
				//System.out.println(r + "= "+evaluation);
			}
			
			for(String s : identifiedRelations.getRelatedIds())
			{
				if(!s.startsWith(_tagBase.getSpuriousTag()) && !penalizedIds.contains(s))
				{
					evaluation -= COREL_SPURIOUS;
					penalizedIds.add(s);
				}
			}
						
			return evaluation;
		}
	}*/
	
	public static void main(String args[]){

		String alignments = null;
		boolean useTags = false;

		for (int i = 0; i < args.length; i++)
		{
			if (args[i].equals("-alinhamento"))
			{
				i++;
				alignments = args[i];
				continue;
			}

			if (args[i].equals("-etiquetas"))
			{
				i++;
				useTags = args[i].equalsIgnoreCase("sim");
				continue;
			}
		}

		new RelationsEvaluator(alignments, useTags);
	}
}
