package pt.linguateca.harem;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;

import pt.linguateca.relations.RelatedEntity;
import pt.linguateca.relations.Relation;
import pt.linguateca.relations.RelationsGraph;
import pt.linguateca.relations.RelationsList;

/** ReRelEM - detector de inconsistncias **/
public class RelationsInconsistenceDetector extends HaremEvaluator implements Runnable{

	private static final int CD = 0;
	private static final int PART = 1;

	private EvaluatedAlignmentProcessor _processor;
	private boolean _gc;
	private boolean _part;

	public RelationsInconsistenceDetector(String alignmentFile, boolean useTags, int test)
	{
		super(alignmentFile, useTags);
		_processor = new IdentificationEvaluatedAlignmentProcessor();

		if(test == CD)
			_gc = true;
		else if(test == PART)
			_part = true;
		else
		{
			_gc = true;
			_part = true;
		}


		new Thread(this).start();
	}

	public void run()
	{
		BufferedReader reader = null;
		String buffer;
		IdentificationEvaluatedAlignment current;

		RelationsGraph graph = null;
		RelatedEntity entity = null;

		try
		{
			reader = new BufferedReader(new FileReader(_alignmentsFile));
			buffer = reader.readLine();

			//filtro
			/*if(buffer.startsWith("#")){
				System.out.println(buffer);
			}*/

			while ((buffer = reader.readLine()) != null)
			{
				//DOC DOCID
				if(buffer.startsWith(_tagBase.getDocTag()))
				{
					if(graph != null)
						detectInconsistences(graph);
					
					graph = new RelationsGraph();

					System.out.println("\n"+buffer);
					continue;
				}
				else if (!isEvaluatable(buffer))
				{
					//System.out.println(buffer);
					continue;
				}

				current = (IdentificationEvaluatedAlignment)_processor.getEvaluatedAlignment(buffer);

				if(_gc && !current.isSpurious())
				{
					entity = new RelatedEntity(current.getGoldenEntity());
					graph.addNode(entity);
				}

				if(_part && !current.isNullAligned())
				{
					for(NamedEntity ne : current.getAlignedList())
					{
						entity = new RelatedEntity(ne);
						graph.addNode(entity);
					}
				}
			}
			
			if(graph != null)
				detectInconsistences(graph);
		}
		catch (IOException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		try
		{
			reader.close();
		}
		catch (IOException e)
		{
			e.printStackTrace();
		}
	}

	private void detectInconsistences(RelationsGraph graph)
	{
		RelationsList relations = null;
		String inverse;
		Relation test;

		LinkedList<String> cats1 = null;
		LinkedList<String> cats2 = null;

		for(RelatedEntity entity : graph)
		{
			relations = entity.getRelationsList();
			for(Relation r : relations)
			{
				//rel(A, B) e inv(A, B)
				inverse = _tagBase.getInverseType(r.getType());

				if(inverse == null)
					continue;

				test = new Relation(inverse, r.getA(), r.getB());

				if(!test.equals(r) && relations.containsRelation(test))
				{
					//System.out.println(relations);
					//System.out.println(" --> Inconsistente: "+r + " e " + test+"\tem "+entity);
					break;
				}

				//ident(CATEG1, CATEG2)
				//TODO; olhar s facetas!!
				if(r.getType().equals(Relation.IDENTIDADE))
				{
					if(graph.containsNode(r.getA()) && graph.containsNode(r.getB()))
					{
						cats1 = graph.get(r.getA()).getCategories();
						cats2 = graph.get(r.getB()).getCategories();

						if(getIntersection(cats1, cats2).size() == 0)
						{
							System.out.println(" --> Identidade entre categorias diferentes: "+r + "\tem "+entity);
							break;
						}
					}
				}
			}
		}
	}

	private LinkedList<String> getIntersection( LinkedList<String> list1,  LinkedList<String> list2)
	{
		LinkedList<String> intersection = new LinkedList<String>();

		if (list1 == null || list2 == null)
		{
			return intersection;
		}

		for (String s : list1)
		{
			if (list2.contains(s))
			{
				intersection.add(s);
			}
		}

		return intersection;
	}
	
	@Deprecated
	private void detectInconsistence(RelatedEntity entity, String where)
	{
		RelationsList relations = entity.getRelationsList();
		String inverse;
		Relation test;

		for(Relation r : relations)
		{
			//rel(A, B) e inv(A, B)
			inverse = _tagBase.getInverseType(r.getType());

			if(inverse == null)
				continue;

			test = new Relation(inverse, r.getA(), r.getB());

			if(!test.equals(r) && relations.containsRelation(test))
			{
				//System.out.println(relations);
				System.out.println(where+": "+r + " e " + test+"\tem "+entity);
				break;
			}
		}
	}

	public static void main(String[] args)
	{
		String alignments = null;
		boolean useTags = false;
		int test = -1;

		for (int i = 0; i < args.length; i++)
		{
			if (args[i].equals("-alinhamento"))
			{
				i++;
				alignments = args[i];
				continue;
			}

			if (args[i].equals("-etiquetas"))
			{
				i++;
				useTags = args[i].equalsIgnoreCase("sim");
				continue;
			}

			if (args[i].equals("-testar"))
			{
				i++;
				if(args[i].equalsIgnoreCase("cd"))
					test = CD;
				else if(args[i].equalsIgnoreCase("part"))
					test = PART;

				continue;
			}
		}

		new RelationsInconsistenceDetector(alignments, useTags, test);
	}
}
