package pt.linguateca.harem;

import java.util.HashSet;
import java.util.Set;

import pt.linguateca.relations.RelationAttributesEvaluation;

public class RelationsScoreParser {

	private String _score;
	private boolean _ignoreSpuriousIds;
	
	public RelationsScoreParser(boolean ignore)
	{
		_score = null;
		_ignoreSpuriousIds = ignore;
	}
	
	public void setBuffer(String buffer)
	{
		_score = buffer;
		//System.out.println(_score);
	}
	
	public double getEvaluation()
	{
		int index = _score.lastIndexOf(RelationAttributesEvaluation.EVALUATION);
		return getDouble(index + RelationAttributesEvaluation.EVALUATION.length());
	}
	
	public double getMaximumGCEval()
	{
		int index = _score.lastIndexOf(RelationAttributesEvaluation.MAX_IN_GC);
		return getDouble(index + RelationAttributesEvaluation.MAX_IN_GC.length());
	}
	
	public double getMaximumSystemEval()
	{
		int index = _score.lastIndexOf(RelationAttributesEvaluation.MAX_IN_SYST);
		return getDouble(index + RelationAttributesEvaluation.MAX_IN_SYST.length());
	}
	
	public int getNumberOfCorrectRelations()
	{
		int index = _score.lastIndexOf(RelationAttributesEvaluation.CORRECT_RELATIONS);
		return getSet(index + RelationAttributesEvaluation.CORRECT_RELATIONS.length()).size();
	}
	
	public int getNumberOfCorrectCorels()
	{
		int index = _score.lastIndexOf(RelationAttributesEvaluation.CORELS);
		index = _score.indexOf(IndividualAlignmentEvaluator.CORRECT, index);
		return getSet(index + IndividualAlignmentEvaluator.CORRECT.length()).size();
	}
	
	public int getNumberOfSpuriousCorels()
	{
		int number = 0;
		
		int index = _score.lastIndexOf(RelationAttributesEvaluation.CORELS);
		index = _score.indexOf(IndividualAlignmentEvaluator.SPURIOUS, index);
		
		Set<String> corels = getSet(index + IndividualAlignmentEvaluator.SPURIOUS.length());
		for(String id : corels)
			if(!_ignoreSpuriousIds || !IDNormalizer.isSpuriousId(id))
				number++;		
		
		return number;
	}

	
	public int getNumberOfMissingCorels()
	{
		int index = _score.lastIndexOf(RelationAttributesEvaluation.CORELS);
		index = _score.indexOf(IndividualAlignmentEvaluator.MISSING, index);
		return getSet(index + IndividualAlignmentEvaluator.MISSING.length()).size();
	}
	
	private Set<String> getSet(int index)
	{
		int state = 0;
		Set<String> toReturn = new HashSet<String>();
		char current;
		String entry = "";
		
		//System.out.println(_score.substring(index));
		
		for (; index < _score.length(); index++)
		{
			current = _score.charAt(index);

			if(current == ' ')
			{
				continue;
			}
			
			if (state == 0 && current == '[')
			{
				state = 1;
				continue;
			}
			
			if (state == 1 && current == ',')
			{
				toReturn.add(entry);
				entry = "";
				continue;
			}

			if (state == 1 && current == ']')
			{
				if(entry.length() > 0)
					toReturn.add(entry);
				
				break;
			}
			
			entry += current;						
		}

		//System.out.println(toReturn);
		return toReturn;
	}
	
	private double getDouble(int index)
	{
		int state = 0;
		String number = "";
		char current;

		for (; index < _score.length(); index++)
		{
			current = _score.charAt(index);

			if (state == 0 && current == '(')
			{
				state = 1;
				continue;
			}

			if (state == 1 && current == ')')
				break;

			number += current;
		}

		return Double.parseDouble(number);
	}
}
