package pt.linguateca.harem;

import java.io.IOException;
import java.util.Iterator;

import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.filter.ElementFilter;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

import pt.linguateca.relations.Relation;

import com.sun.xml.internal.messaging.saaj.util.ByteOutputStream;

public class RerelemChangeNotation extends Thread{

	private static final String CHARSET = "ISO-8859-1";
	private static final String T1TOT2 = "-t1t2";
	private static final String FAC_RIGHT = "FACS_DIR";
	private static final String FAC_LEFT = "FACS_ESQ";
	public static final String UNVAGUE_EM = "ENV";
	private static final String T2_SEP = "\\*\\*";
	private static final int THINGS_IN_TIPOREL = 4;

	private Document _doc;
	private boolean t1ToT2 = false;
	private boolean _debug;

	private TagBase _tagBase;

	//TODO: ISTO NAO TEM EM CONTA TIPORELs MISTOS!
	//A NOTACAO VELHA AGORA VAI TER OS CORELS PELA ORDEM RESPECTIVA AOS TIPORELS
	//PODENDO HAVER REPETICOES E E' LA' QUE VOU BUSCAR QUANDO ME FALTAR O COREL
	//(EM TIPORELS MISTOS)
	//-> Faz com que seja necessario um tipo de FAC_ESQ/DIR para quando nao ha' faceta

	public RerelemChangeNotation(String file, String tipo, boolean debug){

		_tagBase = TagBase.getInstance();
		SAXBuilder builder = new SAXBuilder();

		t1ToT2 = tipo.equals(T1TOT2);
		_debug = debug;

		try {
			_doc = builder.build(file);
		} catch (JDOMException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public void run(){

		ElementFilter docFilter = new ElementFilter(_tagBase.getSimpleEntityTag());
		Iterator it = _doc.getDescendants(docFilter);

		if(t1ToT2)
			allType1To2(it);
		else
			allType2To1(it);

		if(!_debug)
			System.out.println(output(_doc));
	}

	private void allType1To2(Iterator it)
	{
		Element tmp;
		while(it.hasNext()){
			tmp = (Element)it.next();
			type1To2(tmp);
		}
	}

	private void type1To2(Element el)
	{
		Attribute corel, tiporel, facRight, facLeft;

		if((corel = el.getAttribute(_tagBase.getCorelAt())) == null)
			return;

		if((tiporel = el.getAttribute(_tagBase.getTipoRelAt())) == null)
		{
			String t = "";
			for(String s : corel.getValue().split(_tagBase.getCorelSep()))
				t += Relation.IDENTIDADE+_tagBase.getCorelSep();

			el.setAttribute(_tagBase.getTipoRelAt(), t);
			tiporel = el.getAttribute(_tagBase.getTipoRelAt());
		}

		//detecta quando h nmero diferente de COREls e TIPORELs
		if(corel.getValue().split(_tagBase.getCorelSep()).length != tiporel.getValue().split(_tagBase.getCorelSep()).length)
			System.err.println("COREL=\""+corel.getValue()+"\" TIPOREL=\""+tiporel.getValue()+"\"");

		if((facRight = el.getAttribute(FAC_RIGHT)) == null)
		{
			System.err.println("EM "+ el.getAttributeValue(_tagBase.getIdAt()) +"nao tem atributo "+FAC_RIGHT);
			return;
		}

		if((facLeft = el.getAttribute(FAC_LEFT)) == null)
		{
			System.err.println("EM "+ el.getAttributeValue(_tagBase.getIdAt()) +"nao tem atributo "+FAC_RIGHT);
			return;
		}

		String tiporelT2 = getTiporelT2(corel, tiporel, facRight, facLeft);
		//el.removeAttribute(_tagBase.getCorelAt());
		//COREL fica igual!
		el.removeAttribute(FAC_RIGHT);
		el.removeAttribute(FAC_LEFT);
		tiporel.setValue(tiporelT2);
	}

	private String getTiporelT2(Attribute corel, Attribute tiporel, Attribute facright, Attribute facleft)
	{
		String[] corels = corel.getValue().split(_tagBase.getCorelSep());
		String[] tiporels = tiporel.getValue().split(_tagBase.getCorelSep());
		String[] facsright = facright.getValue().split(_tagBase.getCorelSep());
		String[] facsleft = facleft.getValue().split(_tagBase.getCorelSep());

		String toReturn = "";
		for(int i = 0; i < corels.length; i++)
		{
			toReturn += facsright[i]+T2_SEP+tiporels[i]+T2_SEP+corels[i]+T2_SEP+facsleft[i];
			if(i > 0)
				toReturn += " ";
		}

		return toReturn;
	}

	private void allType2To1(Iterator it)
	{
		Element tmp;
		while(it.hasNext()){
			tmp = (Element)it.next();
			type2To1(tmp);
		}
	}

	private void type2To1(Element el)
	{		
		Attribute tiporel = el.getAttribute(_tagBase.getTipoRelAt());
		if(tiporel == null)
			return;

		//TODO: Pode ser preciso alterar algo aqui por causa dos CORELs agora estarem certos
		Attribute corel = el.getAttribute(_tagBase.getCorelAt());
		if(corel == null)
			return;

		String[] tiporels = tiporel.getValue().split(_tagBase.getCorelSep());
		String[] corels = corel.getValue().split(_tagBase.getCorelSep());

		if(_debug && corels.length != tiporels.length)
			System.err.println(elementToString(el));
		/*else
			System.out.println(corel.getValue()+" -- "+tiporel.getValue());*/

		String [] tiporelValues;
		String newCorelValue = "";
		String newTiporelValue = "";
		String facRight = "";
		String facLeft = "";

		boolean t1 = false;
		boolean t2 = false;
		String t;

		for(int i = 0; i < tiporels.length; i++)
		{
			t = tiporels[i];

			if(!newTiporelValue.equals(""))
			{
				newCorelValue += _tagBase.getCorelSep();
				newTiporelValue += _tagBase.getCorelSep();
				facRight += _tagBase.getCorelSep();
				facLeft += _tagBase.getCorelSep();
			}

			//System.out.println("TIPOREL="+t);
			if((tiporelValues = t.split(T2_SEP)).length >= THINGS_IN_TIPOREL)
			{
				/*if(t1)
				{
					System.err.println(tiporel.getValue());
					t1 = false;
				}
				t2 = true;*/


				//FACDIR**COREL_ID**TIPOREL**FACESQ
				facRight += tiporelValues[0];
				newCorelValue += tiporelValues[2]; 
				newTiporelValue += tiporelValues[1];
				facLeft += tiporelValues[3];

				/*for(String tv : tiporelValues)
						System.out.print(tv+", ");
					System.out.println();*/	

			} else 
			{
				/*if(t2)
				{
					System.err.println(tiporel.getValue());
					t2 = false;
				}
				t1 = true;*/

				//FACDIR**COREL_ID**TIPOREL**FACESQ
				facRight += UNVAGUE_EM;
				newCorelValue += corels[i]; 
				newTiporelValue += t;
				facLeft += UNVAGUE_EM;
			}
		}

		el.getAttribute(_tagBase.getCorelAt()).setValue(newCorelValue);
		tiporel.setValue(newTiporelValue);

		el.setAttribute(FAC_RIGHT, facRight);
		el.setAttribute(FAC_LEFT, facLeft);

	}

	/*private LinkedList<String> getAttributes(Document doc, ElementFilter filter, String attribute){

		LinkedList<String> toReturn = new LinkedList<String>();
		Iterator i = doc.getDescendants(filter);

		while(i.hasNext()){
			toReturn.add(((Element)i.next()).getAttributeValue(attribute));
		}

		return toReturn;
	}*/

	private String output(Document doc){
		Format format = Format.getRawFormat().setEncoding(CHARSET);
		XMLOutputter out = new XMLOutputter(format);
		ByteOutputStream bos = new ByteOutputStream();

		try {
			out.output(doc, bos);

		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return bos.toString();
	}

	private String elementToString(Element el)
	{
		String toReturn = el.getName();
		Attribute at;
		for(Object obj : el.getAttributes())
		{
			at = (Attribute)obj;
			toReturn += " " + at.getName()+"="+_tagBase.asQuotedType(at.getValue());
		}

		return _tagBase.openTag(toReturn);
	}

	public static void main(String args[]){

		if(args.length < 2)
			System.err.println("Utilizacao:\n" +
					"java RerelemChangeNotation <de-para> <coleccao_original.xml> <-debug>" +
					"\n\tde-para: -t1t2 ou -t2t1" +
					"\n\ttipo t1: COREL=\"X\" TIPOREL=\"rel\" FACS_ESQ=\"CATEG1\" FACS_DIR=\"CATEG2\"" +
					"\n\ttipo t2: TIPOREL=\"CATEG1"+T2_SEP+"rel"+T2_SEP+"id"+T2_SEP+"CATEG2\"");
		else if(args.length == 3 && (args[2].equals("-debug") || args[2].equals("-depurar")))
			new RerelemChangeNotation(args[1], args[0], true).start();
		else
			new RerelemChangeNotation(args[1], args[0], false).start();
	}
}
