/*
 * Created on Jun 15, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package pt.linguateca.harem;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;

import pt.linguateca.util.BucketHashMap;

/**
 * @author nseco
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style -
 * Code Templates
 */
public class SystemKeyExtractor implements Runnable
{
	private static final String FILE_TYPE_TOKEN = "Ficheiros utilizados:";

	private static final String TIME_STAMP_TOKEN = "Página gerada automaticamente em:";

	private FilenameFilter _filter;

	private BucketHashMap _systemMap;

	public SystemKeyExtractor(String filter)
	{
		_systemMap = new BucketHashMap(new LinkedList());
		_filter = new KeyFilter(filter);
		new Thread(this).start();
	}

	public void run()
	{
		BufferedReader reader;
		String buffer;
		String currentDataFile = null;
		String currentTimeStamp = null;
		String currentHTMLFile = null;
		File[] files = new File(".").listFiles(_filter);

		try
		{
			for (int i = 0; i < files.length; i++)
			{
				reader = new BufferedReader(new FileReader(files[i]));

				currentHTMLFile = files[i].getName();

				while ((buffer = reader.readLine()) != null)
				{
					if (buffer.startsWith(FILE_TYPE_TOKEN))
					{
						currentDataFile = buffer.split("[\\[\\]]")[1];
						continue;
					}

					if (buffer.startsWith(TIME_STAMP_TOKEN))
					{
						currentTimeStamp = buffer.split(": ")[1];
						continue;
					}

					if (buffer.startsWith("---") || buffer.equals(""))
					{
						continue;
					}

					fillSystemMap(currentHTMLFile, currentDataFile, currentTimeStamp, buffer);

				}

				reader.close();
			}

			writeOutSystemMap();

		}
		catch (IOException e)
		{
			e.printStackTrace();
		}

	}

	private void writeOutSystemMap()
	{
		LinkedList tuples;
		ClassificationTuple tuple;
		String key;
		Iterator i, j;
		BufferedWriter writer;

		try
		{
			for (i = _systemMap.keySet().iterator(); i.hasNext();)
			{
				key = (String) i.next();
				tuples = (LinkedList) _systemMap.get(key);

				writer = new BufferedWriter(new FileWriter(key + ".chaves"));

				for (j = tuples.iterator(); j.hasNext();)
				{
					tuple = (ClassificationTuple) j.next();
					writer.write("Página HTML: " + tuple._htmlFile);
					writer.newLine();
					writer.write(FILE_TYPE_TOKEN + " " + tuple._dataFile);
					writer.newLine();
					writer.write(TIME_STAMP_TOKEN + " " + tuple._timeStamp);
					writer.newLine();
					writer.write("Código: " + tuple._codeName);
					writer.newLine();
					writer.newLine();
				}
				writer.close();
			}
		}
		catch (IOException ex)
		{
			ex.printStackTrace();
		}
	}

	private void fillSystemMap(String htmlFile, String dataFile, String currentTimeStamp, String codeNames)
	{
		String[] codes = codeNames.split("[{},]");
		String[] codeNamePair;
		ClassificationTuple tuple;

		for (int i = 0; i < codes.length; i++)
		{
			if (codes[i].trim().equals(""))
				continue;

			codeNamePair = codes[i].split("=");
			tuple = new ClassificationTuple();

			tuple._codeName = codeNamePair[1].trim();
			tuple._dataFile = dataFile;
			tuple._htmlFile = htmlFile.replaceAll("chave", "html");
			tuple._timeStamp = currentTimeStamp;

			_systemMap.put(codeNamePair[0].split("\\.")[0].trim(), tuple);
		}

	}

	public static void main(String[] args)
	{
		new SystemKeyExtractor(args[0]);
	}

	class KeyFilter implements FilenameFilter
	{

		private String _suffix;

		public KeyFilter(String suffix)
		{
			_suffix = suffix;
		}

		public boolean accept(File dir, String name)
		{
			return name.endsWith(_suffix);
		}
	}

	class ClassificationTuple
	{
		private String _dataFile;

		private String _htmlFile;

		private String _timeStamp;

		private String _codeName;

		public String toString()
		{
			return _htmlFile + "\t" + _dataFile + "\t" + _timeStamp + "\t" + _codeName + "\t";
		}
	}
}
