package pt.linguateca.harem;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import pt.linguateca.relations.RelatedEntity;
import pt.linguateca.relations.RelationsGraph;
import pt.linguateca.relations.RelationsGraphDrawer;

public class ViewRelationGraphs extends HaremEvaluator implements Runnable{

	private static final String DOC_SEP = ";";
	
	private EvaluatedAlignmentProcessor _processor;
	private boolean _showGC;
	private boolean _showPart;
	private List<String> _docids;

	private int _labelType;
	
	public ViewRelationGraphs(String alignmentFile, boolean useTags, boolean gc, boolean part, String[] docs, int label){
		super(alignmentFile, useTags);

		_processor = new IdentificationEvaluatedAlignmentProcessor();
		_showGC = gc;
		_showPart = part;
		
		_docids = (docs != null ? Arrays.asList(docs) : null);
		_labelType = label;

		new Thread(this).start();
	}

	public void run()
	{
		BufferedReader reader = null;
		String buffer;
		IdentificationEvaluatedAlignment current;
		RelationsGraph goldenGraph = null;
		RelationsGraph subGraph = null;
		String title = "";

		LinkedList<IdentificationEvaluatedAlignment> alignments = null;

		try
		{
			reader = new BufferedReader(new FileReader(_alignmentsFile));
			buffer = reader.readLine();

			while ((buffer = reader.readLine()) != null)
			{
				if(buffer.length() != 0)
					title = buffer;
				
				if(buffer.startsWith(_tagBase.getDocTag()))
				{
					//mostrar os alinhamentos
					/*if(alignments != null)
						printAlignments(alignments);*/

					if(goldenGraph != null && _showGC){
						
						if(_docids == null || _docids.contains(buffer.split(" ")[1]))
							goldenGraph.draw(title+" - CD", _labelType);
					}

					if(subGraph != null && _showPart){
						
						if(_docids == null || _docids.contains(buffer.split(" ")[1]))
							subGraph.draw(title+" - Part");
					}

					System.out.println("\n"+buffer);
					alignments = new LinkedList<IdentificationEvaluatedAlignment>();
					goldenGraph = new RelationsGraph();
					subGraph = new RelationsGraph();

					continue;
				}

				else if (!isEvaluatable(buffer))
				{
					continue;
				}

				current = (IdentificationEvaluatedAlignment) _processor.getEvaluatedAlignment(buffer);

				//eliminar os atributos que nao interessam...
				current.removeClassicAttributes();
				current.removeComments();
				alignments.add(current);

				if(!current.getGoldenEntity().isSpurious())
					goldenGraph.addNode(new RelatedEntity(current.getGoldenEntity()));

				if(!current.isNullAligned()){
					Iterator<NamedEntity> i = current.getAligned();
					while(i.hasNext())
						subGraph.addNode(new RelatedEntity(i.next()));
				}
			}

			//printAlignments(alignments);

			if(goldenGraph != null && _showGC){
				
				if(_docids == null || _docids.contains(title.split(" ")[1]))
					goldenGraph.draw(title);
			}

			if(subGraph != null && _showPart){
				
				if(_docids == null || _docids.contains(title.split(" ")[1]))
					subGraph.draw(title);
			}
		}

		catch (IOException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		try
		{
			reader.close();
		}
		catch (IOException e)
		{
			e.printStackTrace();
		}
	}

	private void printAlignments(LinkedList<IdentificationEvaluatedAlignment> alignments)
	{
		for(IdentificationEvaluatedAlignment al : alignments)
			System.out.println(al);
	}

	public static void main(String args[]){

		String alignments = null;
		//boolean debug = false;
		boolean showGC = true;
		boolean showPart = true;
		String[] docs = null;
		int label = -1;

		try{

			for (int i = 0; i < args.length; i++)
			{
				if (args[i].equals("-alinhamento"))
				{
					alignments = args[++i];
					continue;
				}

				if (args[i].equals("-docs"))
				{
					docs = args[++i].split(DOC_SEP);
					continue;
				}
				
				if (args[i].equals("-ver"))
				{
					i++;
					if(args[i].equalsIgnoreCase("cd"))
					{
						showGC = true;
						showPart = false;
					}
					else if(args[i].equalsIgnoreCase("part"))
					{
						showPart = true;
						showGC = false;
					}

					continue;
				}

				if (args[i].equals("-nos"))
				{
					i++;
					if(args[i].equalsIgnoreCase("id"))
					{
						label = RelationsGraphDrawer.nodeLabel.ID.ordinal();
											}
					else if(args[i].equalsIgnoreCase("em"))
					{
						label = RelationsGraphDrawer.nodeLabel.CONTENT.ordinal();
					}
					else if(args[i].equalsIgnoreCase("ambos"))
					{
						label = RelationsGraphDrawer.nodeLabel.BOTH.ordinal();
					}

					continue;
				}

				/*if (args[i].equals("-depurar") || args[i].equals("-debug"))
				{
					debug = true;
					continue;
				}*/
			}
		} catch (Exception e)
		{
			System.out.println(e);
			printSynopsis();
			return;
		}

		new ViewRelationGraphs(alignments, false, showGC, showPart, docs, label);
	}

	private static void printSynopsis()
	{
		System.out.println("Utiliza\u00e7\u00e3o:");
		System.out
		.println("java -Dfile.encoding=ISO-8859-1 cp .;lib/jdom.jar;lib/jgraph.jar pt.linguateca.harem.ViewRelationsGraphs" +
				"-alinhamento <ficheiro_alinhamentos> [-ver <cd|part>] -docs docid1;docid3 [-nos <id|em|ambos>]");
		System.out.println("Info adicional:");
		System.out.println("\t<ficheiro_alinhamentos> deve ser um ficheiro de saida do organizador de ALTs, Expandidor de relacoes ou Normalizador de IDs");
		System.out.println("\tSe a opcao -ver nao for especificada, sao mostrados os grafos dois dois lados");
		System.out.println("\tSe a opcao -nos nao for especificada, os nos mostrarao apenas o ID");
	}
}
