package pt.linguateca.relations;

import java.util.Iterator;
import java.util.LinkedList;

import pt.linguateca.harem.GlobalRelationsEvaluator;
import pt.linguateca.harem.NamedEntity;
import pt.linguateca.harem.RelationsEvaluator;

public class RelatedEntity extends NamedEntity implements Node<Relation>{

	private RelationsList _relations;

	public RelatedEntity(NamedEntity entity){

		super(entity.getElement());
		_relations = new RelationsList(getId());
		fillRelations();
	}

	private void fillRelations(){

		LinkedList<String> corels = getCorels();
		LinkedList<String> tiporels = getTipoRels();

		//System.err.println("CORELS="+corels);
		//System.err.println("TIPORELS="+tiporels);
		
		Iterator<String> i, j;

		if(!corels.isEmpty()){

			i = corels.iterator();

			if(tiporels.isEmpty())
			{
				while(i.hasNext()) //a identidade tem de ser a primeira no harem3.conf!
				{
					//explicitar as identidades
					super.addAttributeValue(_tagBase.getTipoRelAt(), _tagBase.getPossibleTiposRel().get(0)[0]);
					_relations.addRelation(new Relation(_tagBase.getPossibleTiposRel().get(0)[0], getId(), i.next()));
				}

			} else {

				try {
				j = tiporels.iterator();
				while(j.hasNext())
				{
					_relations.addRelation(new Relation(j.next(), getId(), i.next()));
				}
				} catch(Exception e)
				{
					System.err.println("ID="+getId());
					System.err.println("CORELS="+corels);
					System.err.println("TIPORELS="+tiporels);
					System.err.println(e);
					System.exit(0);
				}
			}		
		}
	}

	public void setCorels(LinkedList<String> corels)
	{
		if(!corels.isEmpty())
		{
			String newValue = "";
			for(String s : corels)
				newValue += s + _tagBase.getCorelSep();

			//retirar o espao do fim
			newValue = newValue.trim();
			_entityElement.setAttribute(_tagBase.getCorelAt(), newValue);
		}
	}

	public RelationsList getRelationsList(){
		return _relations;
	}

	@Override
	public String getKey() {
		return super.getId();
	}

	@Override
	public Iterator<Relation> iterator() {
		return _relations.iterator();
	}

	@Override
	public boolean addEdge(Relation edge) {

		if(_relations.addRelation(edge))
		{
			super.addAttributeValue(_tagBase.getCorelAt(), edge.getB());
			super.addAttributeValue(_tagBase.getTipoRelAt(), edge.getType());
			return true;
		}
		return false;
	}

	public boolean containsRelation(Relation r){
		return _relations.containsRelation(r);
	}
	
	public double getMaximumRelationsEvaluation()
	{
		return _relations.size() * (RelationAttributesEvaluation.COREL_CORRECT + RelationAttributesEvaluation.TIPOREL_CORRECT);
	}
}
