package pt.linguateca.relations;

import java.util.Arrays;
import java.util.LinkedList;

import pt.linguateca.harem.TagBase;

public class Relation
{
	public static final String IDENTIDADE = "ident";
	public static final String INCLUI = "inclui";
	public static final String INCLUIDO = "incluido";
	public static final String OCORRE = "ocorre_em";
	public static final String SEDE = "sede_de";
	public static final String OUTRA = "outra";

	public static final String[] BASIC_TYPES = {IDENTIDADE, INCLUI, INCLUIDO, OCORRE, SEDE};

	private static final boolean NEW_TYPE_EQUALS_OUTRA = true;

	private String _type;
	private String _a, _b;

	public Relation(String type, String a, String b){

		_type = type;

		_a = a;
		_b = b;
	}

	public Relation(String representation){
		//type(A B)
		
		representation = representation.replace("(", " ").replace(")", "");
		String[] split = representation.split(" ");		
		
		_type = split[0];
		_a = split[1];
		_b = split[2];
	}
	
	public boolean isBasicType()
	{
		return Arrays.asList(BASIC_TYPES).contains(_type);
	}

	public String getType() {
		return _type;
	}

	public String getA() {
		return _a;
	}

	public String getB() {
		return _b;
	}

/*	public void setA(String str) {
		_a = str;
	}
	
	public void setB(String str) {
		_b = str;
	}*/
	
	public String toString(){
		return _type+"("+_a+" "+_b+")";
	}

	public boolean hasOnlyOneCommonArgument(Relation other)
	{
		return 
		(_a.equals(other.getA()) && !_b.equals(other.getB())) || 
		(_a.equals(other.getB()) && !_b.equals(other.getA())) ||
		(_b.equals(other.getA()) && !_a.equals(other.getB())) || 
		(_b.equals(other.getB()) && !_a.equals(other.getA()));
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((_a == null) ? 0 : _a.hashCode());
		result = prime * result + ((_b == null) ? 0 : _b.hashCode());
		result = prime * result + ((_type == null) ? 0 : _type.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final Relation other = (Relation) obj;
		if (_a == null) {
			if (other._a != null)
				return false;
		} else if (!_a.equals(other._a))
			return false;		
		if (_b == null) {
			if (other._b != null)
				return false;
		} else if (!_b.equals(other._b))
			return false;

		if (_type == null) {
			if (other._type != null)
				return false;

		}
		
		//aqui garante-se que a comparacao entre um tipo nao basico e outra d true
		else if (NEW_TYPE_EQUALS_OUTRA && _type.equals(this.OUTRA) && !other.isBasicType())
			return true;

		else if (NEW_TYPE_EQUALS_OUTRA && !isBasicType() && other._type.equals(this.OUTRA))
			return true;

		else if (!_type.equals(other._type))
			return false;

		//System.out.println("IGUAIS: "+this +" e "+other);
		return true;
	}
}
