package pt.linguateca.relations;

import java.util.HashSet;
import java.util.Set;

import pt.linguateca.harem.IdentificationEvaluatedAlignment;
import pt.linguateca.harem.IndividualAlignmentEvaluator;
import pt.linguateca.harem.TagBase;

public class RelationAttributesEvaluation
{
	public static final String CORRECT_RELATIONS = "RelsCorrectas";
	public static final String CORELS = TagBase.getInstance().getCorelAt();
	public static final String MAX_IN_GC = "MaxAval_CD";
	public static final String MAX_IN_SYST = "MaxAval_S";
	public static final String EVALUATION = "Avaliacao";

	public static final double COREL_CORRECT = 0.5;
	public static final double TIPOREL_CORRECT = 0.5;
	public static final double COREL_SPURIOUS = 0.2;

	private boolean _ignoreSpuriousIds;

	private RelatedEntity _golden;
	private RelatedEntity _toEvaluate;

	private Set<Relation> _correctRelations;
	private Set<String> _correctCorels;
	private Set<String> _spuriousCorels;
	private Set<String> _missingCorels;

	public RelationAttributesEvaluation(IdentificationEvaluatedAlignment alignment, boolean ignore)
	{
		_golden = new RelatedEntity(alignment.getGoldenEntity());
		_toEvaluate = (alignment.isNullAligned() ? null : new RelatedEntity(alignment.getFirstAlignment()));

		_ignoreSpuriousIds = ignore;

		_correctRelations = new HashSet<Relation>();
		_correctCorels = new HashSet<String>();
		_spuriousCorels = new HashSet<String>();
		_missingCorels = new HashSet<String>();
	}

	/*public RelationAttributesEvaluation(NamedEntity golden, NamedEntity toEvaluate, String buffer)
	{
		_tagBase = TagBase.getInstance();
		_golden = new RelatedEntity(golden);
		_toEvaluate = (toEvaluate == null ? null : new RelatedEntity(toEvaluate));

		parseEvaluation(buffer);
	}*/

	public void evaluate()
	{	
		if(_toEvaluate != null && !_golden.isSpurious() )
		{	
			RelationsList goldenRelations = _golden.getRelationsList();
			RelationsList identifiedRelations = (RelationsList)_toEvaluate.getRelationsList().clone();
			
			Set<Relation> relationsInGCWithId, relationsInPartWithId;
			
			Set<String> testSpurious;

			//ATENCAO: para isto, os IDs ja' tem de estar normalizados!
			for(String id : goldenRelations.getRelatedIdsNoRepetition()) //agora podem ter CORELs repetidos!!!
			{
				relationsInGCWithId = goldenRelations.getAllRelationsWith(id);
				relationsInPartWithId = identifiedRelations.getAllRelationsWith(id);
				if(!relationsInPartWithId.isEmpty())
				{
					for(Relation r : relationsInGCWithId)
					{
						if(relationsInPartWithId.contains(r))
						{
							if(!_correctRelations.contains(r))
								_correctRelations.add(r);
	
							//break;
						}	
					}
					if(!_correctCorels.contains(id))
						_correctCorels.add(id);
					
					identifiedRelations.removeAllRelationsWith(id);
				}
				else
				{
					if(!_missingCorels.contains(id))
						_missingCorels.add(id);
				}
			}
			
			if(_ignoreSpuriousIds)
				testSpurious = identifiedRelations.getRelatedIdsNoRepetitionNoSpurious();
			else
				testSpurious = identifiedRelations.getRelatedIdsNoRepetition();
				
			for(String id : testSpurious)
			{
				if(!_spuriousCorels.contains(id))
					_spuriousCorels.add(id);
			}				
		}

		else if(_toEvaluate == null)
		{
			_missingCorels.addAll(_golden.getRelationsList().getRelatedIdsNoRepetition());
		}

		else if(_golden.isSpurious())
		{
			if(_ignoreSpuriousIds)
				_spuriousCorels.addAll(_toEvaluate.getRelationsList().getRelatedIdsNoRepetitionNoSpurious());
			else
				_spuriousCorels.addAll(_toEvaluate.getRelationsList().getRelatedIdsNoRepetition());
		}
	}

	private double calculateScore()
	{
		double evaluation = _correctRelations.size() * (COREL_CORRECT + TIPOREL_CORRECT);
		
		//evaluation += (_correctCorels.size() * COREL_CORRECT);
		evaluation += correctCorelsNotInRelations().size() * COREL_CORRECT;

		evaluation -= (_spuriousCorels.size() * COREL_SPURIOUS);

		return evaluation;
	}

	private Set<String> correctCorelsNotInRelations()
	{
		Set<String> toReturn = (Set<String>)((HashSet<String>)_correctCorels).clone();
		for(Relation r : _correctRelations)
		{
			if(toReturn.contains(r.getB()))
				toReturn.remove(r.getB());
		}
		
		//System.out.println(_correctCorels.size()+" "+toReturn.size());
		
		return toReturn;
	}
	
	private double getMaximumScore(RelatedEntity entity)
	{
		if(entity == null || entity.isSpurious())
			return 0.0;

		return entity.getMaximumRelationsEvaluation();
	}

	public Set<Relation> getCorrectRelations() {
		return _correctRelations;
	}

	public Set<String> getCorrectCorels() {
		return _correctCorels;
	}

	public Set<String> getSpuriousCorels() {
		return _spuriousCorels;
	}

	public Set<String> getMissingCorels() {
		return _missingCorels;
	}

	public String toString()
	{		
		String toReturn = CORRECT_RELATIONS+_correctRelations+" "+
		CORELS + "(" + IndividualAlignmentEvaluator.CORRECT + _correctCorels + " " +
		IndividualAlignmentEvaluator.SPURIOUS + _spuriousCorels + " " +
		IndividualAlignmentEvaluator.MISSING + _missingCorels+ ") " +
		MAX_IN_GC + "(" + getMaximumScore(_golden) + ") " +
		MAX_IN_SYST + "(" + getMaximumScore(_toEvaluate) + ") " +
		EVALUATION + "(" + calculateScore() + ")";

		return toReturn;
	}
}
