package pt.linguateca.relations;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.LinkedList;

import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JScrollPane;

import org.jgraph.JGraph;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.graph.DefaultCellViewFactory;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;

public class RelationsGraphDrawer implements GraphModelListener{

	private static final int X_INCREMENT = 200;
	private static final int Y_INCREMENT = 100;
	private static final int NODE_WIDTH = 100;
	private static final int NODE_HEIGHT = 20;
	private static final int NODES_PER_LINE = 8;
	
	private static final int FONT_SIZE = 9;
	private static final Font NODE_FONT = new Font("qq", Font.PLAIN, FONT_SIZE);
	
	private static final Color IDENT_COLOR = Color.green;
	private static final Color INCLUI_COLOR = Color.red;
	private static final Color INCLUIDO_COLOR = Color.magenta;
	private static final Color OCORRE_COLOR = Color.blue;
	private static final Color SEDE_COLOR = Color.cyan;
	private static final Color NOT_BASIC_COLOR = Color.black;
	
	public static enum nodeLabel{
		CONTENT, ID, BOTH;
	}
	
	private int _labelType;
	
	private RelationsGraph _relGraph;
	private JGraph _jGraph;
	
	private HashMap<String, DefaultGraphCell> _cellMap;
	private HashMap<String, Color> _colorMap;
	
	public RelationsGraphDrawer(RelationsGraph graph, int labelType)
	{
		_relGraph = graph;		
		_cellMap = new HashMap<String, DefaultGraphCell>();
		
		_labelType = labelType;
		
		GraphModel model = new DefaultGraphModel();
		GraphLayoutCache view = new GraphLayoutCache(model, new	DefaultCellViewFactory());
		
		_jGraph = new JGraph(model, view);
		_jGraph.getModel().addGraphModelListener(this);
		
		initColorMap();
	}
	
	private void initColorMap()
	{
		_colorMap = new HashMap<String, Color>();
		
		_colorMap.put(Relation.IDENTIDADE, IDENT_COLOR);
		_colorMap.put(Relation.INCLUI, INCLUI_COLOR);
		_colorMap.put(Relation.INCLUIDO, INCLUIDO_COLOR);
		_colorMap.put(Relation.OCORRE, OCORRE_COLOR);
		_colorMap.put(Relation.SEDE, SEDE_COLOR);
		_colorMap.put(Relation.OUTRA, NOT_BASIC_COLOR);
	}
	
	public void drawGraph()
	{
		LinkedList<RelatedEntity> nodes = new LinkedList<RelatedEntity>(_relGraph.getAllNodes());
		
		int x = 0, y = 0;
		DefaultGraphCell cell;
		DefaultPort port;
		String label;
		
		for(RelatedEntity entity : nodes)
		{
			label = getLabel(entity);
			
			//cell = new DefaultGraphCell(entity.getId());
			//cell = new DefaultGraphCell(entity.getId()+"\n"+entity.getEntity());
			cell = new DefaultGraphCell(entity.getEntity());
			drawNode(cell, x, y);
			
			port = new DefaultPort();
			cell.add(port);
			
			_jGraph.getGraphLayoutCache().insert(cell);
			_cellMap.put(entity.getId(), cell);
			
			x += X_INCREMENT;
			if((x / X_INCREMENT) == NODES_PER_LINE)
			{
				y += Y_INCREMENT;
				x = 0;
			}
		}
		
		for(RelatedEntity entity : nodes)
		{
			for(Relation r : entity.getRelationsList())
			{
				if(!_cellMap.containsKey(r.getB()))
				{
					System.out.println("ID= "+r.getB());
					System.out.println(_cellMap);
				}
				
				drawEdge(_cellMap.get(r.getA()), _cellMap.get(r.getB()), r.getType());
			}
		}
	}
	
	private String getLabel(RelatedEntity entity)
	{
		if(_labelType == nodeLabel.ID.ordinal())
			return entity.getId();
		else if(_labelType == nodeLabel.CONTENT.ordinal())
			return entity.getEntity();
		else if(_labelType == nodeLabel.BOTH.ordinal())
			return entity.getId()+"_"+entity.getEntity();
		else
			return entity.getId();
	}
	
	private void drawNode(DefaultGraphCell cell, int x, int y)
	{
		GraphConstants.setFont(cell.getAttributes(), NODE_FONT);
		GraphConstants.setBounds(cell.getAttributes(), new Rectangle2D.Double(x,y,NODE_WIDTH,NODE_HEIGHT));
		GraphConstants.setOpaque(cell.getAttributes(), true);
		GraphConstants.setEditable(cell.getAttributes(), false);
		GraphConstants.setBorder(cell.getAttributes(), BorderFactory.createLineBorder(Color.black));
		//GraphConstants.setBackground(cell.getAttributes(), Color.lightGray);
		//GraphConstants.setForeground(cell.getAttributes(), Color.black);
	}
	
	private void drawEdge(DefaultGraphCell a, DefaultGraphCell b, String type)
	{	
		//System.out.println("A:"+a);
		//System.out.println("B:"+b);
		DefaultEdge edge = new DefaultEdge();
		
		int arrow = GraphConstants.ARROW_CLASSIC;
		GraphConstants.setLineEnd(edge.getAttributes(), arrow);
		GraphConstants.setEndFill(edge.getAttributes(), true);
		
		_jGraph.getGraphLayoutCache().insertEdge(
				edge, a.getFirstChild(), b.getFirstChild());
		
		GraphConstants.setLineColor(edge.getAttributes(), getColorForType(type));
		GraphConstants.setEndFill(edge.getAttributes(), true);
	}
	
	private Color getColorForType(String type)
	{
		if(_colorMap.containsKey(type))
			return _colorMap.get(type);
		else
			return _colorMap.get(Relation.OUTRA);
	}
	
	public void show(String title)
	{
		JFrame frame = new JFrame(title);
		frame.getContentPane().add(new JScrollPane(_jGraph));
		frame.pack();
		frame.setVisible(true);

		frame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
	}
	
	@Override
	public void graphChanged(GraphModelEvent arg0) {

	}
}
