package pt.linguateca.relations;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedList;

import pt.linguateca.harem.HaremEvaluator;
import pt.linguateca.harem.IdentificationEvaluatedAlignment;
import pt.linguateca.harem.IdentificationEvaluatedAlignmentProcessor;
import pt.linguateca.harem.NamedEntity;

public class Rerelem extends HaremEvaluator implements Runnable{

	private LinkedHashMap<String, NamedEntity> _goldenEntities;
	private LinkedHashMap<String, NamedEntity> _subEntities;
	
	//private DocumentReader _reader;

	public Rerelem(String alignment, boolean useTags){
		
		super(alignment, useTags);
		
		//_reader = new DocumentReader(alignment);
		_goldenEntities = new LinkedHashMap<String, NamedEntity>();
		_subEntities = new LinkedHashMap<String, NamedEntity>();

		new Thread(this).start();
	}
	
	public void run(){
		
		BufferedReader reader = null;
		String buffer;
		IdentificationEvaluatedAlignment current;
		IdentificationEvaluatedAlignmentProcessor processor = new IdentificationEvaluatedAlignmentProcessor();
		LinkedList<Relation> goldenRelations = null;
		LinkedList<Relation> submittedRelations = null;
		RelatedEntity goldenEntity = null;
		RelatedEntity submittedEntity = null;
		
		try
		{
			reader = new BufferedReader(new FileReader(_alignmentsFile));

			buffer = reader.readLine();

			while ((buffer = reader.readLine()) != null)
			{
				if (buffer.startsWith(_tagBase.getDocTag()))
				{
					System.out.println(buffer);
					
					if(goldenRelations != null && submittedRelations != null){
						printRelationsWithOneCommonAttribute(goldenRelations);
						printRelationsWithOneCommonAttribute(submittedRelations);
					}
					
					goldenRelations = new LinkedList<Relation>();
					submittedRelations = new LinkedList<Relation>();
					continue;
				}
				
				if (!isEvaluatable(buffer))
				{
					//System.out.println(buffer);
					continue;
				}
				
				current = (IdentificationEvaluatedAlignment) processor.getEvaluatedAlignment(buffer);
				
				goldenEntity = new RelatedEntity(current.getGoldenEntity());
				submittedEntity = new RelatedEntity(current.getAlignedList().get(0));
				
				//TODO: se for espuria ou se estiver em falta...
				
				_goldenEntities.put(goldenEntity.getId(), goldenEntity);
				_subEntities.put(submittedEntity.getId(), submittedEntity);
				
				goldenRelations.addAll(goldenEntity.getRelationsList().getList());
				submittedRelations.addAll(submittedEntity.getRelationsList().getList());
			}
						
			System.out.println("Relacoes CD:");
			//printRelations(goldenRelations);
			//printRelationsWithOneCommonAttribute(goldenRelations);
			System.out.println("Relacoes Participacao:");
			//printRelations(submittedRelations);
			printRelationsWithOneCommonAttribute(submittedRelations);
			
		}
		catch (IOException ex)
		{
			ex.printStackTrace();
		}

		try
		{
			reader.close();
		}
		catch (IOException ex)
		{
			ex.printStackTrace();
		}
	}

	private void showInverseRelations(){
		
	}
	
	/*private void doSomething(){
		NamedEntityTagParser parser = new NamedEntityTagParser();
		
		Iterator<Element> it = _reader.getIterator();

		while(it.hasNext()){
			doSomethingWithDoc(it.next(), parser);
		}
	}

	private void doSomethingWithDoc(Element doc, NamedEntityTagParser parser){

		LinkedList<Relation> relations = new LinkedList<Relation>();
		HaremEntity entity;

		parser.setDocument(doc);
		while(parser.recognize()){

			entity = parser.getEntity();

			if(entity instanceof NamedEntity){
				NamedEntity ne = (NamedEntity)entity;
				_entities.put(ne.getId(), ne);
				relations.addAll(ne.getRelations());
				//System.out.println(ne.getRelations());


			} else if(entity instanceof ALTEntity){
				ALTEntity alt = (ALTEntity)entity;
				LinkedList<NamedEntity> entities = alt.getAllEntities();

				Iterator<NamedEntity> it_entities = entities.iterator();
				while(it_entities.hasNext()){

					NamedEntity ne = it_entities.next();
					_entities.put(ne.getId(), ne);
					relations.addAll(ne.getRelations());
					//System.out.println(ne.getRelations());
				}					
			}
		}
		printRelationsWithOneCommonAttribute(relations);		
	}*/

	private boolean hasOneCommonArgument(Relation r1, Relation r2){

		//System.out.println(r1);
		//System.out.println(r2);
		
		return 
		(r1.getA().equals(r2.getA()) && !r1.getB().equals(r2.getB())) || 
		(r1.getA().equals(r2.getB()) && !r1.getB().equals(r2.getA())) ||
		(r1.getB().equals(r2.getA()) && !r1.getA().equals(r2.getB())) || 
		(r1.getB().equals(r2.getB()) && !r1.getA().equals(r2.getA()));
	}

	private void printRelations(LinkedList<Relation> relations){
		for(int i = 0; i < relations.size(); i++){
			Relation relation = relations.removeFirst();
			
			for(Relation r : relations)
				System.out.println(relation + ";" + r);
		}
	}
	
	private void printRelationsWithOneCommonAttribute(LinkedList<Relation> relations){
		
		for(int i = 0; i < relations.size(); i++){
			Relation relation = relations.removeFirst();
			
			for(Relation r : relations)
				if(hasOneCommonArgument(relation, r))
					System.out.println(relation + ";" + r);
		}
	}

	public static void main(String args[]){
		new Rerelem(args[0], false);
	}

}
