package Esfinge::PadroesExtraccaoRespostas;

use strict;
use warnings;
use Exporter;

our @ISA = qw(Exporter);
our @EXPORT_OK = qw(ExtraiRespostas);
our $VERSION = '0.01';


=head1 FUNCTIONS

=head2 ExtraiRespostas

Esta funo obtm candidatas a respostas a partir de uma pergunta, um texto e um ficheiro com padres que associam respostas a perguntas.

ENTRADA 1: Uma pergunta (string)
ENTRADA 2: Um texto (string)
ENTRADA 3: O nome de um ficheiro contendo duplas da forma PADRO DE PERGUNTA/PADRO DE RESPOSTA  (string)
SADA: Hash em que as chaves so candidatas a respostas e os valores so o nmero de vezes que elas so suportadas no texto. (hash)


=cut


sub ExtraiRespostas($ $ $)

{ 
  my $Pergunta = shift;
  my $Texto = shift;
  my $NomeFicheiroPadroes = shift;


  open (PAD , $NomeFicheiroPadroes);

  my @padroes = ();

  my %Respostas = ();


  while(<PAD>){

    $_=~s/\n//;
    push @padroes, $_;

  }

  close PAD;

  my %respostas_exactas = ();

  $Texto =~ s/\n/ /g;
	
  

  foreach (@padroes){

    my $PadraoPergunta = "";   

    if (/(.*)\/(.*)/) {

      $PadraoPergunta = $1;
      my $PadraoResposta = $2;

      my $numero_variavel = 0;

      my @variaveis_pergunta = split(/\(/,$PadraoPergunta);

      foreach (@variaveis_pergunta) {

        $numero_variavel++;

      }
        
      $PadraoPergunta =~ s/__\d__/\(\.\*\)/g;  
	

      if ($Pergunta =~ /$PadraoPergunta/) {

        my $primeira_variavel = $1;
	my $segunda_variavel = $2;
	my $terceira_variavel = $3;
	my $quarta_variavel = $4;
	my $quinta_variavel = $5;

	$PadraoResposta =~ s/__1__/$primeira_variavel/;
	$PadraoResposta =~ s/__2__/$segunda_variavel/;
	$PadraoResposta =~ s/__3__/$terceira_variavel/;
	$PadraoResposta =~ s/__4__/$quarta_variavel/;
	$PadraoResposta =~ s/__5__/$quinta_variavel/;

	  
	#substituir todos os parenteses que capturam por (?:) 
	#assim sabemos que a resposta est no $1

	$PadraoResposta=~ s/^\(/\(?:/g;
	$PadraoResposta=~ s/([^\\])\(/$1\(?:/g;

	# DVIDA: Deve-se pr a virgula ou no ???? preciso vs abrangncia

	$PadraoResposta=~ s/__RESPOSTA__/([^.;\)]*)/;
                  
	if ($Texto =~ /$PadraoResposta/i){

	  $Respostas{$1}++;

        }
      }
    }
  }

  ## retorna a hash
  return %Respostas;

}
      

1;

__END__

=head1 NAME

Esfinge::PadroesExtraccaoRespostas

=head1 SYNOPSIS

Este mdulo permite obter candidatas a respostas a partir de uma pergunta, um texto e um ficheiro com padres que associam respostas a perguntas.


Exemplo de utilizao da package PadroesExtraccaoRespostas


use Esfinge::PadroesExtraccaoRespostas qw(ExtraiRespostas);

$Pergunta = "O que  um gato?";

%Respostas = PadroesExtraccaoRespostas::ExtraiRespostas ($Pergunta, "Um gato  um felino.", "../../examples/PadroesExtraccaoRespostas.txt"); 


print "Pergunta: $Pergunta\n\n";

foreach $resposta (keys %Respostas) {

  print "Encontrada resposta \"$resposta\" com pontuao " . $Respostas {$resposta} . "\n";

}



=head1 SEE ALSO

=head1 AUTHOR

Lus Fernando Costa, E<lt>luis.f.kosta@gmail.comE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2008 by Linguateca

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.6 or,
at your option, any later version of Perl 5 you may have available.


=cut
