package Esfinge::REM;

use strict;
use warnings;


our $VERSION = '0.01';

# Dependncias

use AS::REM::SIEMES;
use AS::BASE::UtilLex;



=head1 FUNCTIONS

=head2 new

Construtor

=cut


sub new
{

  my $this = {};

  $this->{objectoREM} =  new AS::REM::SIEMES;

  $this->{objectoREM}->usaExacto(1); 
  $this->{objectoREM}->usaRegrasSimples(1);
  $this->{objectoREM}->usaEstruturaPrefixo(1);
  $this->{objectoREM}->usaRegrasPosteriores(1); 
  $this->{objectoREM}->usaDifuso1(0); 
  $this->{objectoREM}->usaDifuso2(1); 

  bless $this;
  return $this;
}



sub submete_texto_siemes ($)
{
  my $this = shift;
  my $Texto = shift;

  $Texto =~ s/\\par//g;
  $Texto =~ s/\\/ /g;

  $Texto = trataPontuacao($Texto);

#  print "TRATANDO TEXTO: $Texto\n";

#  $Texto =~ s/;//g;
#  $Texto =~ s/&//g;

  $this->{objectoREM}->texto($Texto);

  $this->{objectoREM}->identificaSementes();
  $this->{objectoREM}->expandeSementesNumericas();
  $this->{objectoREM}->expandeSementesAlfa();
  $this->{objectoREM}->classificaSementesAlfa();

  ## imprimir as frases em formato XML...

  my $retorno = "";

  for( $this->{objectoREM}->frases() ) {
 #   print $_->XML()."\n";
    $retorno .= $_->XML() . " ";  
  }


#  print "RESULTADO: $retorno\n";

  return $retorno;
}

sub ReformulaPedidoCQP ($)
{
  my $this = shift;
  my $Pedido = shift;

  if (! ($Pedido =~ /"/)) {
    
    my $string_siemes = $this->submete_texto_siemes($Pedido);

    $Pedido = $string_siemes;

    $Pedido =~ s/^(<[^>]*>)//;

    $Pedido =~ s/<\/F>//;
   
    # $Pedido =~ s/<[^>]*>([^<]*)<[^>]*>/"$1"/g;

    while ($Pedido =~ /(<[^>]*>)([^<]*)<[^>]*>/g) {

      my $Etiqueta = $1;
      my $Em = $2;

      if ($Etiqueta =~ /SUBCLASSE=CARGO/) {

        $Pedido =~ s/$Etiqueta($Em)<\/UL>/$1/;

      }
      else {

        $Pedido =~ s/$Etiqueta($Em)<\/UL>/"$1"/;

      }

    }


  }

  return $Pedido;

}

sub Entidades_Categoria ($ @)
{
  my $this = shift;
  my $TextoEtiquetado = shift; 

#  open TESTE,">>teste.txt";

#  print TESTE "\n$TextoEtiquetado\n";

  my @Categorias = ();

  foreach $_ (@_) {
      
    push(@Categorias, $_);
      
  } 

  my %ContabilizacaoEM = ();

  foreach my $Categoria (@Categorias) {

#      print "VERIFICANDO $Categoria\n";

      while ($TextoEtiquetado =~ m/$Categoria([^>]*)>([^<]*)</g) {

#          print "ENCONTREI $2 como $Categoria\n";
          $ContabilizacaoEM {$Categoria} {$2} ++;
       } 

  }
 
  return (%ContabilizacaoEM); 

 
}


sub categorias_pergunta
{
  my $this = shift;
  my $Pergunta = shift; 
  my $NomeFicheiroPadroes = shift;
 
  my @categorias = ();

  open (CAT, $NomeFicheiroPadroes);

  while (<CAT>) {
    my ($padrao,$categoria) = /(.+?)\/(.+)/; 
    if ($Pergunta =~ /$padrao/i) {

      if  ($Pergunta =~ /Quem.*/ and
           !($Pergunta =~ /Quem.*(mulher|filha|filho|marido|pai|me|esposa|amante|viva|vivo|sucessor)/) and
	   !($Pergunta =~ /Quem.*escreveu/) and
	   !($Pergunta =~ /Quem fabrica.*/)  ) {

        my %ContabilizacaoEM = $this->Entidades_Categoria($this->submete_texto_siemes ($Pergunta), ("SUBCLASSE=HUM","SUBCLASSE=MITLG"));
  
        # Perguntas do tipo "Quem e <HUM>?"
        if (!(exists $ContabilizacaoEM {"SUBCLASSE=HUM"}) and
	    !(exists $ContabilizacaoEM {"SUBCLASSE=MITLG"})) {

          push @categorias, $categoria;

 
        }
           
      }
      else {
        push @categorias, $categoria;
      }

    }    

  }   

  return @categorias;

}

1;


__END__

=head1 NAME

Esfinge::Filtros

=head1 SYNOPSIS


Este mdulo contm mtodos que permitem a interaco com o reconhecedor de entidades mencionadas SIEMS. Inclui um mtodo que chama o SIEMS para analisar textos, um mtodo para determinar quais os tipos de resposta esperados para uma pergunta e um mtodo para contabilizar as ocorrncias de entidades mencionadas de categorias determinadas num texto.


#Exemplo de utilizao da package REM

#!/usr/local/bin/perl


use Esfinge::REM;

$Texto = "A ndia suspeita que dois dirigentes de um grupo clandestino paquistans esto por detrs dos ataques terroristas dos ltimos dias em Bombaim, que causaram a morte a pelo menos 171 pessoas, referiram esta quinta-feira fontes governamentais indianas, citadas pela Lusa. 
Provas recolhidas pelos investigadores apontam para Zaki-ur-Rehman Lakhvi e Yusuf Muzammil como cabecilhas dos sangrentos ataques da semana passada na capital financeira do pas, de acordo com as mesmas fontes, hoje citadas pela agncia AP. Lakhvi e Muzammil pertencem ao grupo clandestino paquistans Lashkar-e-Taiba, que a ndia responsabiliza pelos ataques, e presume-se que estejam a viver no Paquisto, acrescentaram. 
Lakhvi foi identificado como o chefe de operaes do grupo e Muzamil como o responsvel operacional em Caxemira e noutras regies da ndia. 
O nico terrorista que sobreviveu confessou  polcia que foi recrutado por Lakhvi para a operao e os membros do grupo atacante falaram por telefone-satlite com Muzamil depois de terem desviado um navio indiano em rota para Bombaim. 
Durante os trs dias de ataques, os terroristas usaram telemveis dos hspedes dos hotis para telefonar para a cidade paquistanesa de Lahore. 
As fontes falaram na condio de manterem o anonimato por no estarem autorizadas a revelar  imprensa detalhes das investigaes. 
Estas informaes reforam os crescentes indcios que ligam os ataques a militantes residentes no Paquisto e a sua divulgao coincide com a chegada da secretria de Estado norte-americana, Condoleezza Rice, ao Paquisto para conversaes com dirigentes civis e militares, depois de uma visita  ndia. 
Rice dever pressionar o governo paquistans a partilhar mais informao secreta e perseguir clulas terroristas que se presume estarem radicadas no pas.";

@Categorias = ("SUBCLASSE=POV", "SUBCLASSE=PAIS");

$ObjectoREM = new Esfinge::REM;

%entidades_categoria = ();


%entidades_categoria = $ObjectoREM->Entidades_Categoria($ObjectoREM->submete_texto_siemes($Texto), @Categorias);


print "\n\nPASES:\n\n";

foreach $em (sort {$entidades_categoria {"SUBCLASSE=PAIS"} {$b} <=> $entidades_categoria {"SUBCLASSE=PAIS"} {$a}} keys %{$entidades_categoria {"SUBCLASSE=PAIS"}})  {

  print "$em: " . $entidades_categoria {"SUBCLASSE=PAIS"} {$em} . "\n";

}


print "\n\nCIDADES:\n\n";

foreach $em (sort {$entidades_categoria {"SUBCLASSE=POV"} {$b} <=> $entidades_categoria {"SUBCLASSE=POV"} {$a}} keys %{$entidades_categoria {"SUBCLASSE=POV"}})  {

  print "$em: " . $entidades_categoria {"SUBCLASSE=POV"} {$em} . "\n";

}

print "\n\n";	    




=head1 SEE ALSO

=head1 AUTHOR

Lus Fernando Costa, E<lt>luis.f.kosta@gmail.comE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2008 by Linguateca

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.6 or,
at your option, any later version of Perl 5 you may have available.


=cut
