package Esfinge::Web;

use strict;
use warnings;
use HTTP::Request;
use LWP::UserAgent;

our $VERSION = '0.02';



=head1 FUNCTIONS

=head2 buscaURL

Esta função permite extrair o conteúdo de uma página Web
ENTRADA 1: Um URL (string)
ENTRADA 2: Método que se pretende utilizar (GET ou POST). (string)
ENTRADA 3: Valores que se pretendam submeter (usado em formulários). (string)
ENTRADA 4: Indicação de que o acesso é feito a partir de um browser (0 ou 1).  (string)
SAÍDA: Array em que a primeira posição tem 0 no caso de um acesso bem sucedido, -1 no caso contrário. A segunda posição tem o condeúdo da página web da qual se pretendia extrair o conteúdo. (array)

Função adaptada a partir da package CG_METRA desenvolvida por Luis Sarmento

=cut


sub buscaURL($ $ $ $)
{
       
  my $url=shift;
  my $metodo = shift;
  my $conteudo = shift;
  my $camufla = shift;

  my $UserAgent = new LWP::UserAgent;
  $UserAgent->timeout(100);
  my $header = HTTP::Headers->new(Accept=>'text/html; charset=ISO-8859-1');

  my $req = HTTP::Request->new($metodo,$url, $header);

  if ($metodo eq "POST") 
  {
    $req->content_type('multipart/form-data');
                
    if (!($conteudo eq "")) {$req->content($conteudo)};

  }
  $req->content_type('charset=ISO-8859-1');

  if ($camufla == 1) {$UserAgent->agent("Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.0.2) Gecko/20021120 Netscape/7.01");}
        
  my $resp = $UserAgent->request($req);

  my @retorno = ();
  if ($resp->is_success)
  {
    $retorno[0]=0;       
    $retorno[1]=$resp->content;
   }
   else
   {
     $retorno[0]=-1;       
     $retorno[1]= "Acesso Falhado";
   }
   return @retorno;
}


=head2 HTMLTexto

Esta função converte códigos HTML para ascii.
ENTRADA: Um texto (string)
SAÍDA: O texto de entrada com os códigos HTML convertidos (string)

Desenvolvida a partir de uma função existente na biblioteca bib_gestao_paginas.pl da Linguateca

=cut


sub HTMLTexto ($)
{

  $_= shift;
  s/&#193;/Á/g;
  s/&#225;/á/g;
  s/&#194;/Â/g;
  s/&#226;/â/g;
  s/&#224;/à/g;
  s/&#192;/À/g;
  s/&#227;/ã/g;
  s/&#195;/Ã/g;
  s/&#231;/ç/g;
  s/&#199;/Ç/g;
  s/&#233;/é/g;
  s/&#201;/É/g;
  s/&#234;/ê/g;
  s/&#202;/Ê/g;
  s/&#205;/Í/g;
  s/&#237;/í/g;
  s/&#211;/Ó/g;
  s/&#243;/ó/g;
  s/&#244;/ô/g;
  s/&#212;/Ô/g;   
  s/&#245;/õ/g;
  s/&#213;/Õ/g;
  s/&#218;/Ú/g;
  s/&#250;/ú/g;
  s/&#252;/ü/g;
  s/&#220;/Ü/g;
  s/&#169;/©/g;
  s/&#179;/«/g;
  s/&#178;/»/g;
  s/&#(\d+);/chr($1)/ge;
  s/&ordm;/º/g;
  s/&ordf;/ª/g;
  s/&atilde;/ã/g;
  s/&ntilde;/ñ/g;
  s/&otilde;/õ/g;
  s/&Atilde;/Ã/g;
  s/&Ntilde;/Ñ/g;
  s/&Otilde;/Õ/g;
  s/&Aacute;/Á/g;
  s/&Eacute;/É/g;
  s/&Iacute;/Í/g;
  s/&Oacute;/Ó/g;
  s/&Uacute;/Ú/g;
  s/&aacute;/á/g;
  s/&eacute;/é/g;
  s/&iacute;/í/g;
  s/&oacute;/ó/g;
  s/&uacute;/ú/g;
  s/&Agrave;/À/g;
  s/&Egrave;/È/g;
  s/&Igrave;/Ì/g;
  s/&Ograve;/Ò/g;
  s/&Ugrave;/Ù/g;
  s/&agrave;/à/g;
  s/&egrave;/è/g;
  s/&igrave;/ì/g;
  s/&ograve;/ò/g;
  s/&ugrave;/ù/g;
  s/&Ccedil;/Ç/g;
  s/&ccedil;/ç/g;
  s/&aelig;/æ/g;
  s/&oslash;/ø/g;
  s/&aring;/å/g;
  s/&Aelig;/Æ/g;
  s/&Oslash;/Ø/g;
  s/&Aring;/Å/g;
  s/&Acirc;/Â/g;
  s/&Ecirc;/Ê/g;
  s/&Icirc;/Î/g;
  s/&Ocirc;/Ô/g;
  s/&Ucirc;/Û/g;
  s/&acirc;/â/g;
  s/&ecirc;/ê/g;
  s/&icirc;/î/g;
  s/&ocirc;/ô/g;
  s/&ucirc;/û/g;
  s/&Auml;/Ä/g;
  s/&Euml;/Ë/g;
  s/&Iuml;/Ï/g;
  s/&Ouml;/Ö/g;
  s/&Uuml;/Ü/g;
  s/&auml;/ä/g;
  s/&euml;/ë/g;
  s/&iuml;/ï/g;
  s/&ouml;/ö/g;
  s/&uuml;/ü/g;
  s/&amp;/&/g;
  s/&gt;/>/g;
  s/&lt;/</g;
  s/&quot;/"/g;
  s/&middot;/\./g;
  return $_;
   
}

=head2 UTFTexto

Esta função converte códigos UTF para ascii.
ENTRADA: Um texto (string)
SAÍDA: O texto de entrada com os códigos UTF convertidos (string)

=cut


sub UTFTexto ($) 

{

  $_= shift;
  s/Ã/Á/g;
  s/Ã¡/á/g;
  s/Ã/Â/g;
  s/Ã¢/â/g;
  s/Ã\s/à/g;
  s/Ã/À/g;
  s/Ã£/ã/g;
  s/Ã/Ã/g;
  s/Ã§/ç/g;
  s/Ã/Ç/g;
  s/Ã©/é/g;
  s/Ã/É/g;
  s/Ãª/ê/g;
  s/Ã/Ê/g;
  s/Ã/Í/g;
  s/Ã­/í/g;
  s/Ã/Ó/g;
  s/Ã³/ó/g;
  s/Ã´/ô/g;
  s/Ã/Ô/g;   
  s/Ãµ/õ/g;
  s/Ã/Õ/g;
  s/Ãº/Ú/g;
  s/Ã/ú/g;
  s/Ã¼/ü/g;
  s/Ã/Ü/g;

  return $_;
   
}




1;

__END__

=head1 NAME

Esfinge::Web

Esfinge::Web - Módulo que permite criar padrões para procura de respostas a partir de perguntas.

=head1 SYNOPSIS

Este módulo inclui métodos úteis para manipular texto da web.

Exemplo de utilização da package Web

#!/usr/local/bin/perl

use Web;

@Resultado = buscaURL("http://www.linguateca.pt/www_linguateca_pt.html", GET, "", 0);

if ($Resultado [0] eq -1) {

  print "Acesso falhado\n";

}
else {

  print HTMLTexto($Resultado [1]) . "\n";

}



=head1 SEE ALSO

Esfinge::Google
Esfinge::Yahoo

=head1 AUTHOR

Luís Fernando Costa, E<lt>luis.f.kosta@gmail.comE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2008 by Linguateca

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.6 or,
at your option, any later version of Perl 5 you may have available.


=cut
