#!/usr/bin/perl


use Esfinge::ReformulaPergunta qw(RetornaPadroesResposta);
use Esfinge::Registo qw(new Grava);
use Esfinge::Yahoo qw(RetornaPassagensPadrao);
use Esfinge::PadroesExtraccaoRespostas qw(ExtraiRespostas);
use Esfinge::Ngramas qw(CalculaNgramas);
use Esfinge::Filtros;
use Esfinge::REM;

use POSIX qw(strftime);


# Configuraes

@urls_desinteressantes = ("weblogger.terra.com.br", "blogspot.com", "blogs.sapo.pt", "weblog.com.pt", "blogger.com.br", "blog.uol.com.br", "humor", "piadas", "emails");


sub RespostaNova
{

  my $resposta = shift;

  my $resposta_nova = 1;

  for ($i=0;$i!=$#{@respostas_finais} + 1;$i++) {

    if (lc($respostas_finais [$i]  {resposta}) eq lc($resposta)) {

      $resposta_nova = 0;

    }

  }

  return $resposta_nova;

}


sub AcrescentaRespostaLista
{

  my $resposta = shift;
  my $origem_resposta = shift;
  my $textos_suporte = shift;

  my $aumentou_resposta = 0;

  if (RespostaNova($resposta)) {

    for ($i=0;$i!=$#{@respostas_finais} + 1;$i++) {

      my $resposta_final = $respostas_finais [$i]  {resposta};

      $resposta_final =~ s/\(/\\\(/g;

      $resposta_final =~ s/\)/\\\)/g;

      if ($resposta =~ /$resposta_final/i and $respostas_finais [$i]  {origem_resposta} eq "Ngramas") {

        $respostas_finais [$i] {resposta} = $resposta;
	$respostas_finais [$i] {textos_suporte} = $textos_suporte;
	$respostas_finais [$i] {origem_resposta} = $origem_resposta;
	$respostas_finais_lista {resposta} ++;
	$aumentou_resposta = 1;
  
	$ObjectoRegisto->Grava ("ENCONTRADA RESPOSTA PARA A PERGUNTA " . $numero_pergunta . " POR " . $respostas_finais [$i] {origem_resposta} . " E COMPOSICAO [" . $respostas_finais [$i] {resposta} .  "]\n",$calc_time);

      
  
      }
     
    }

    my $indice_respostas = $#{@respostas_finais} + 1;

    if ($indice_respostas < $numero_respostas and !($aumentou_resposta)) {

      $RespostasEncontradas ++;

      $respostas_finais [$indice_respostas] {resposta} = $resposta;
      $respostas_finais [$indice_respostas] {textos_suporte} = $textos_suporte;
      $respostas_finais [$indice_respostas] {origem_resposta} = $origem_resposta;
      $respostas_finais_lista {resposta} ++;

      $ObjectoRegisto->Grava ("ENCONTRADA RESPOSTA PARA A PERGUNTA " . $numero_pergunta ." POR " . $respostas_finais [$indice_respostas] {origem_resposta} . " [" .  $respostas_finais [$i] {resposta} .  "]\n",$calc_time);

 
    }

  }

}




while ($ARGV[0]) {

  next if (!$ARGV[0]);

  if ( $ARGV[0] eq "-p") {
   
    shift; $pergunta= $ARGV[0]; shift;

  }

  if ( $ARGV[0] eq "-nr") {
	
	shift; $numero_respostas =$ARGV[0]; shift;
	
  }

  elsif ( $ARGV[0] eq "-fp") {
	
    shift; $ficheiro_padroes =$ARGV[0]; shift;
	
  }

  elsif ( $ARGV[0] eq "-r") {
      
    shift; $etiqueta_run =$ARGV[0]; shift;
	
  }

  elsif ( $ARGV[0] eq "-n") {
      
    shift; $numero_pergunta =$ARGV[0]; shift;
	
  }

  elsif ($ARGV[0] eq "-web") {
	
    shift; $web= 1;
	
  }

  elsif ( $ARGV[0] eq "-l") {

    shift; $lingua=$ARGV[0]; shift;

  }

  elsif ( $ARGV[0] eq "-altaprecisao") {
	
    shift; $altaprecisao= 1;
	
  }


}

$RespostasEncontradas = 0;
@respostas_finais=();

$ObjectoRegisto = new();
$ObjectoRegisto->{NumPergunta} = $numero_pergunta; 
$ObjectoRegisto->{Experiencia} = $etiqueta_run;

$ObjectoFiltro = new Esfinge::Filtros;
@{$ObjectoFiltro->{PoSInteressantes}} = ("adj", "nc", "card", "a_nc", "np"); 

# Carregamento das respostas indesejveis para a varivel RespostasIndesejaveis do objecto $ObjectoFiltro

open (INDESEJ, "respostas-indesejaveis.txt");
  
while (my $palavra = <INDESEJ>) {

  $palavra =~ s/\n//;
  push  @{$ObjectoFiltro->{RespostasIndesejaveis}}, $palavra;

}


$ObjectoREM = new Esfinge::REM;


# O parmetro -p pode indicar vrias reformulaes da mesma pergunta. 
# Estas so separadas por um ponto e virgula (;)
# Isto  usado por exemplo para o tratamento de anforas.

@perguntas = split /\;/, $pergunta;

$numero_alternativas = scalar(@perguntas);
    
foreach (@perguntas){

  next if (!/\w/);
  $pergunta = $_;

  # Obter padres para procura de textos relevantes

  @PadroesResposta = RetornaPadroesResposta ($pergunta, $ficheiro_padroes); 

  $ObjectoRegisto->Grava("PADRES DE PROCURA DE TEXTOS RELEVANTES:");

  %PadroesResposta = ();

  foreach (@PadroesResposta){

    /(.+?)\/(.+)/;

    $PadroesResposta {$1} = $2;

    $ObjectoRegisto->Grava("$1 - $2");

  }

  # Procurar textos relevantes para responder  pergunta usando a API do Yahoo

  %PassagensWeb = ();

  $ExistemPassagensWeb = 0;

  if ($web) {

    foreach $padrao (keys %PadroesResposta) {

     
      @{$PassagensWeb {$padrao}}  = RetornaPassagensPadrao($padrao, $lingua, 100 , @urls_desinteressantes);
		

        $ObjectoRegisto->Grava ("PASSAGENS YAHOO ($padrao)=\n",$calc_time);
		
        $indice_excertos = 1;
		
        for $i (0 ..  $#{@{$PassagensWeb {$padrao}}}) {
		    
	  $ObjectoRegisto->Grava ("Passagem $indice_excertos= " . $PassagensWeb {$padrao} [$i] {texto} . "\(" . $PassagensWeb {$padrao} [$i] {url} . "\)\n");       
		    
	  $indice_excertos ++;
		    
	  $ExistemPassagensWeb = 1;
		    
        }

	$ObjectoRegisto->Grava ("Passagens recolhidas do Yahoo\n");
     
    }

  }


  if ($altaprecisao) {
  
    $ObjectoRegisto->Grava ("Testando padres de extraco de respostas\n");

    %respostas_exactas = ();

    while ($RespostasEncontradas < $numero_respostas) {

      my $texto;

      foreach $padrao (keys %PassagensWeb) {    
	    	      
        for $i (0 ..  $#{@{$PassagensWeb {$padrao}}}) {

	  $texto = $PassagensWeb {$padrao} [$i] {texto};

	  $i++;
	  $texto=~ s/\n/ /g;

	  %respostas = ExtraiRespostas ($pergunta, $texto, "PadroesExtraccaoRespostas.txt");

	  
	  foreach $resposta (keys %respostas) {

            
	    $respostas_exactas {$resposta} += $respostas {$resposta};

	    $suporte_respostas_exactas {$resposta} = $texto;

            $RespostasEncontradas++;

          }

        }

      }

    }
  
    $ObjectoRegisto->Grava ("Respostas encontradas com padres de extraco de respostas:\n");


    foreach $resposta (sort {$respostas_exactas {$b} <=> $respostas_exactas {$a}} keys %respostas_exactas) {   

      AcrescentaRespostaLista ($resposta, "PadroesExtracaoRespostas", $suporte_respostas_exactas {$resposta});

      $ObjectoRegisto->Grava ("\"$resposta\" com pontuao " . $respostas_exactas {$resposta} . " suportado pela passagem \"" .  $suporte_respostas_exactas {$resposta} . "\"\n");

     print STDOUT "\nEncontrada resposta \"$resposta\" com pontuao " . $respostas_exactas {$resposta} . " suportado pela passagem \"" .  $suporte_respostas_exactas {$resposta} . "\n\n"
    
    }

  }

  # REM

  $ObjectoRegisto->Grava ("CATEGORIAS DE RESPOSTAS:\n");

  @Categorias = $ObjectoREM->categorias_pergunta($pergunta  ,"perguntas-categorias-respostas.txt");

  foreach $categoria (@Categorias)  {

    $ObjectoRegisto->Grava ("$categoria\n");

  }

  if ($RespostasEncontradas < $numero_respostas and $Categorias [0]) {

    %entidades_categoria_total = ();

    foreach $padrao (keys %PassagensWeb) {

      for $i (0 ..  $#{@{$PassagensWeb {$padrao}}}) {

	$texto = $PassagensWeb {$padrao} [$i] {texto};

	$texto =~ s/[\)\(]//g; 

        %entidades_categoria = ();

	%entidades_categoria = $ObjectoREM->Entidades_Categoria($ObjectoREM->submete_texto_siemes($texto), @Categorias);

	foreach $categoria (@Categorias)  {

	  foreach $em (keys %{$entidades_categoria {$categoria}})  {

	    $entidades_categoria_total {$em} +=  $entidades_categoria {$categoria} {$em} *  $padroes {$padrao};

	  }
	}	       	       	 

        EM: foreach $em (sort {$entidades_categoria_total {$b} <=> $entidades_categoria_total {$a}} keys %entidades_categoria_total) {
		
          if ($RespostasEncontradas >= $numero_respostas) {

	    last EM;

	  }
	  else { 		  

	    if ($ObjectoFiltro->FazParteExpressao ($em, $pergunta)) {

              $ObjectoRegisto->Grava ("FILTRO NA PERGUNTA= EM: $em (" . $entidades_categoria_total {$em} . ")\n");
	      next;
	    }

	    if ($ObjectoFiltro->RespostaIndesejavel($em)) {

              $ObjectoRegisto->Grava ("FILTRO INDESEJVEL= EM: $em (" . $entidades_categoria_total {$em} . ")\n");		      
	      next;
	    }

            foreach $padrao  (sort { $padroes{$b} <=> $padroes{$a} } keys %PadroesResposta) {

	      for (my $i=0;$i!=$#{$PassagensWeb {$padrao}} + 1;$i++) {

	        if ($PassagensWeb {$padrao} [$i] {texto} =~ m/$em/) {

		  AcrescentaRespostaLista ($em, "REM", $PassagensWeb {$padrao} [$i] {texto});

		  $ObjectoRegisto->Grava ("\"$em\" com pontuao " . $entidades_categoria_total {$em} . " suportada pela passagem \"" . $PassagensWeb {$padrao} [$i] {texto}  . "\"\n");

		  next EM;

	        }
	      }    
            }
	  }
        }
      }
    }
  }

  while ($RespostasEncontradas < $numero_respostas) {

    %nGramas = ();

    foreach $padrao (keys %PassagensWeb) {

      for $i (0 ..  $#{@{$PassagensWeb {$padrao}}}) {
		
	for $comprimento (1 ..  3) {

	  %nGramas_passagem = ();
		    
	  %nGramas_passagem = CalculaNgramas($PassagensWeb {$padrao} [$i] {texto}, $comprimento, 1);

	  foreach $nGrama (keys %nGramas_passagem) {

	    $nGramas {$nGrama} += $nGramas_passagem {$nGrama} * $comprimento * $PadroesResposta {$padrao};

	  }

	}

      }
	    	    
    }

    NGRAMA: foreach $nGrama (sort {$nGramas {$b} <=> $nGramas {$a}} keys %nGramas) {

      if ($RespostasEncontradas >= $numero_respostas) {

        last NGRAMA;

      }
      else { 
		
	if ($nGrama eq " " or $nGrama eq "" or $nGrama =~ /[\[\]\+\*\)\(\?]/) {
 
	  next;

	}

        if ($ObjectoFiltro->FazParteExpressao ($nGrama, $pergunta)) {

	  $ObjectoRegisto->Grava ("FILTRO NA PERGUNTA= NGRAMA: $nGrama (" . $nGramas {$nGrama} . ")\n");
	   
	  next;

	}

        if ($ObjectoFiltro->RespostaIndesejavel($nGrama)) {

	  $ObjectoRegisto->Grava ("FILTRO INDESEJVEL= NGRAM: $nGrama (" . $nGramas {$nGrama} . ")\n");
		
	  next;

	}

	if (!($ObjectoFiltro->PoSInteressantes($nGrama))) { 

	  $ObjectoRegisto->Grava ("FILTRO PoS= NGRAMA: $nGrama (" . $nGramas {$nGrama} . ")\n");
		   
	  next;

	}
		
        foreach $padrao  (sort { $padroes{$b} <=> $padroes{$a} } keys %PadroesResposta) {

	  for (my $i=0;$i!=$#{$PassagensWeb {$padrao}} + 1;$i++) {

	    if ($PassagensWeb {$padrao} [$i] {texto} =~ m/$nGrama/) {

	      AcrescentaRespostaLista ($nGrama, "Ngramas", $PassagensWeb {$padrao} [$i] {texto});

	      $ObjectoRegisto->Grava ("\"$nGrama\" com pontuao " . $nGramas {$nGrama} . " suportado pela passagem \"" . $PassagensWeb {$padrao} [$i] {texto}  . "\"\n");

	      print STDOUT "\nEncontrada resposta \"$nGrama\" com pontuao " . $nGramas {$nGrama} . " suportada pela passagem \"" . $PassagensWeb {$padrao} [$i] {texto}  . "\"\n\n";

	      next NGRAMA;

	    }
          }    
	}
      }
    }   	  
  }

}





