#Exemplo de utilizao da package Filtros

#!/usr/local/bin/perl

use  Esfinge::Filtros;

# Resposta a analisar.

$Resposta= "Amor  fogo";

# Expresso a analisar

$Expressao= "Amor  fogo que arde sem se ver";

# Ficheiro com respostas indesejveis.

$NomeFicheiro="respostas-indesejaveis.txt";

$ObjectoFiltro = new Esfinge::Filtros;

# Carregamento das categorias gramaticais consideradas interessantes para obter respostas para a varivel RespostasIndesejaveis do objecto $ObjectoFiltro.

@{$ObjectoFiltro->{PoSInteressantes}} = ("adj", "nc", "card", "a_nc", "np"); 


if ($ObjectoFiltro->PoSInteressantes($Resposta)) {

  print "\n\"$Resposta\"  uma resposta interessante\n";

}
else {

  print "\n\"$Resposta\" no  uma resposta interessante\n";

}


# Carregamento das respostas indesejveis para a varivel RespostasIndesejaveis do objecto $ObjectoFiltro
  
open (INDESEJ, "$NomeFicheiro");
  
while (my $palavra = <INDESEJ>) {

  $palavra =~ s/\n//;
  push  @{$ObjectoFiltro->{RespostasIndesejaveis}}, $palavra;

}


if ($ObjectoFiltro->RespostaIndesejavel($Resposta)) {

  print "\n\"$Resposta\"  uma resposta indesejvel\n";

}
else {

  print "\n\"$Resposta\" no  uma resposta indesejvel\n";

}


print "\n Palavras com PoS interessante: " . $ObjectoFiltro->PalavrasPoSInteressante ($Resposta) . "\n";


if ($ObjectoFiltro->FazParteExpressao ($Resposta, $Expressao)) {

    print "\n\"$Resposta\" faz parte da expresso \"$Expressao\"\n";

}
else {

    print "\n\"$Resposta\" no faz parte da expresso \"$Expressao\"\n";

}
