package Esfinge::Ngramas;

use strict;
use warnings;
use Exporter;

our @ISA = qw(Exporter);
our @EXPORT_OK = qw(CalculaNgramas);
our $VERSION = '0.01';

# Dependncias

use Lingua::PT::PLNbase; 


=head1 FUNCTIONS

=head2 CalculaNgramas

Esta funo permite fazer a contagem de ngramas num texto
ENTRADA 1: Um texto. (string)
ENTRADA 2: Comprimento dos ngramas a contar. (inteiro)
ENTRADA 3: Considerar maisculas? 1 no caso afirmativo, 0 caso contrrio.  (string)
SADA: Hash em que as chaves so os ngramas encontrados e os valores so o nmero de vezes que eles ocorrem no texto. (hash)

Funo adaptada a partir de uma funo existente na package Corpus desenvolvida por Luis Sarmento

=cut


sub CalculaNgramas($ $ $)

{ 
  my $Texto = shift;
  my $Comprimento = shift;
  my $Sensivel = shift;
  
  my %nGramas = ();

  # Atomiza o texto usando a funo tokeniza do pacote Lingua::PT::PLNbase

  $Texto =  tokeniza($Texto) if ($Texto);

 # produz um array de palavras
  my @atomos =($Texto? split (/\s/, $Texto) : ());

  
    
  my $ultimoIndex= scalar(@atomos) - $Comprimento+1; ## tira o indice da ultima posicao tendo em conta o comprimento
  for(my $posIndex=0; $posIndex < $ultimoIndex; $posIndex++) {
  ## Faz crescer cada n-grama...
    my $nGrama = $atomos[$posIndex];
    for(my $j=1; $j < $Comprimento; $j++) {$nGrama.= " ".$atomos[$posIndex+$j];}
    ## agora que temos o ngrama
      if ($Sensivel != 1) {$nGrama = lc($nGrama);}
      $nGramas{$nGrama}++;
  } ## for cada posicao
 
  
  ## retorna a hash
  return %nGramas;
}

      

1;


__END__

=head1 NAME

Esfinge::Ngramas

=head1 SYNOPSIS

Este mdulo permite extrair n-gramas de um determinado comprimento a partir de um texto.

#Exemplo de utilizao da package Ngramas

#!/usr/local/bin/perl

use  Esfinge::Ngramas qw(CalculaNgramas);

# Texto do qual se vo determinar os Ngramas.

$Texto = "Amor  fogo que arde sem se ver,  ferida que di, e no se sente;  um contentamento descontente,  dor que desatina sem doer.";

# Comprimento dos Ngramas a determinar.

$Comprimento = 3;

# Considerar maisculas? 1 no caso afirmativo, 0 caso contrrio.

$Sensivel = 1;

%nGramas = CalculaNgramas($Texto, $Comprimento, $Sensivel);

# Imprime os ngramas encontrados seguidos do nmero de vezes que eles ocorrem no texto

foreach $nGrama (keys %nGramas) {

  print "$nGrama :" . $nGramas {$nGrama} . "\n";
  
}


=head1 SEE ALSO

=head1 AUTHOR

Lus Fernando Costa, E<lt>luis.f.kosta@gmail.comE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2008 by Linguateca

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.6 or,
at your option, any later version of Perl 5 you may have available.


=cut
