package Esfinge::ReformulaPergunta;

use strict;
use warnings;
use Exporter;

our @ISA = qw(Exporter);
our @EXPORT_OK = qw(RetornaPadroesResposta);
our $VERSION = '0.02';



=head1 FUNCTIONS

=head2 CarregaPadroes

Sub-rotina interna que l o ficheiro com o nome em $NomeFicheiroPadroes para a hash %ConteudoFicheiroPadroes.
Cada elemento da hash  por sua vez um array para possibilitar a atribuio de vrios padres de resposta a um padro de pergunta.

=cut

sub CarregaPadroes
{

  my $NomeFicheiroPadroes = shift;

  my %ConteudoFicheiroPadroes = ();

  open (PAD, $NomeFicheiroPadroes);
  while (<PAD>) {

    /(.+?)\/(.+)/;

    $ConteudoFicheiroPadroes {$1} [$#{$ConteudoFicheiroPadroes {$1}} +1]=$2;

  }   

  return %ConteudoFicheiroPadroes;

}

=head2 RetornaPadroesResposta

Esta funo transforma uma pergunta em possveis padres de respostas com uma pontuao associada.
ENTRADA 1: Uma pergunta (string)
ENTRADA 2: O nome de um ficheiro contendo triplos da forma (PADRO DE PERGUNTA/PADRO DE RESPOSTA/PONTUAO  (string)

A sintaxe usada para definir os padres  a das expresses regulares em perl.

Exemplo: ([^?]*)?Quem ([^\s?]*) ([^?]*)\??/"$3 $2" "$1"/10

$1 indica o emparelhamento com o primeiro conjunto de parentesis, $2 o emparelhamento com o segundo, etc.
Neste exemplo, para a pergunta "Quem  o presidente da Frana?"  gerado o padro "o presidente da Frana " "" com a pontuao 10.

SADA: Array contendo padres de respostas (com uma pontuao associada) para a pergunta fornecida como argumento.

=cut

sub RetornaPadroesResposta ($ $)
{

  my $Pergunta = shift; 
  my $NomeFicheiroPadroes = shift;

  # Array devolvido por esta funo. Contm padres de respostas (com uma pontuao associada) para a pergunta fornecida como argumento da mesma funo.

  my @PadroesResposta = ();

  # Hash para onde  lido o contedo do ficheiro de mapeamento entre padres de perguntas e padres de respostas.

  my %ConteudoFicheiroPadroes = CarregaPadroes ($NomeFicheiroPadroes);

  $Pergunta =~ s/"/\\"/g;

  foreach my $padrao1 (keys %ConteudoFicheiroPadroes) {

    foreach my $padrao2 (@{$ConteudoFicheiroPadroes {$padrao1}}) {

      $padrao2 =~ /(.+)\/(.+)/;
      my $substituicao=$1;
      my $pontuacao=$2; 

      if ($Pergunta =~ /^$padrao1/i) {  # Coreco 24/5/2006

#	  print "$padrao1\n";

        my $substituicao1 = $1;
        my $substituicao2 = $2;
        my $substituicao3 = $3;
        my $substituicao4 = $4;
        my $substituicao5 = $5;
        my $substituicao6 = $6;
        my $substituicao7 = $7;
        my $resposta = $substituicao;         
	$resposta  =~ s/\$1/$substituicao1/;
	$resposta  =~ s/\$2/$substituicao2/;
        $resposta  =~ s/\$3/$substituicao3/;
        $resposta  =~ s/\$4/$substituicao4/;
        $resposta  =~ s/\$5/$substituicao5/;
        $resposta  =~ s/\$6/$substituicao6/;
	$resposta  =~ s/\$7/$substituicao7/;

	# Apaga aspas dentro de aspas

	if ($resposta =~ /^"/) {

          $resposta =~ s/\\"//g;

	}
	else {

	  $resposta =~ s/\\"/"/g;

        }
   
	$resposta =~ s/,/ /g;

        push @PadroesResposta, "$resposta/$pontuacao\n";
        
      }

    }

  }

  return (@PadroesResposta); 

}


1;

__END__
=head1 NAME

Esfinge::ReformulaPergunta

Esfinge::ReformulaPergunta - Mdulo que permite criar padres para procura de respostas a partir de perguntas.

=head1 SYNOPSIS

Este mdulo permite transformar perguntas em padres que podem ser usados para procurar respostas.

Exemplo de utilizao da package ReformulaPergunta

#!/usr/local/bin/perl

use ReformulaPergunta;

# Uma pergunta (string)

$pergunta="Onde fica Cuba?";

# Nome de ficheiro contendo um mapeamento entre padres de perguntas e padres de respostas usando a sintaxe de expresses regulares do perl. 
# Ficheiro de exemplo: perguntas-respostas-pt.txt

$pr="perguntas-respostas-pt.txt"; 

@PadroesResposta = RetornaPadroesResposta ($pergunta, $pr);

# Imprime os padres obtidos com a respectiva pontuao associada

foreach $padrao (@PadroesResposta) {

    $padrao =~  /(.+?)\/(.+)/;

    print "$1 - $2\n";

}


=head1 SEE ALSO

=head1 AUTHOR

Lus Fernando Costa, E<lt>luis.f.kosta@gmail.comE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2008 by Linguateca

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.6 or,
at your option, any later version of Perl 5 you may have available.


=cut
