package Esfinge::Registo;

use strict;
use warnings;
use Exporter;

use POSIX qw(strftime);

our @ISA = qw(Exporter);
our @EXPORT_OK = qw(new Grava);
our $VERSION = '0.02';



=head1 FUNCTIONS

=head2 new

Define os dados relativos a um ficheiro de registo (Nmero de pergunta, data/hora de nicio do processamento de uma pergunta, nome da experincia)


=cut

sub new
{

  my $this = {};
  $this->{NumPergunta} = "0000"; # Nmero da pergunta a que o registo se refere
  $this->{Inicio} = time(); # Incio do processamento da pergunta
  $this->{Experiencia} = "EXP"; # Nome da experincia a ser registada

  bless $this;
  return $this;
}


=head2 Grava

Escreve o texto recebido como argumento no ficheiro de registo activo.

=cut

sub Grava
{
    
  my $this = shift; 
  my $Registo = shift;

  my $tempo = strftime "[%d%m%y %H:%M:%S]\t", localtime;

  $Registo =  $this->{Experiencia}."-" . 
              $this->{NumPergunta} .
  	      " $tempo " . $Registo;
    
  open (LOG_ESFINGE, ">>log_$this->{Experiencia}.txt");
    
  print LOG_ESFINGE $Registo . "\n";
    
  close LOG_ESFINGE;

}



1;
__END__

=head1 NAME

Esfinge::Registo

=head1 SYNOPSIS

Este mdulo que permite gravar um registo dos resultados intermdios do sistema num ficheiro.


Exemplo de utilizao do mdulo Registo


#!/usr/local/bin/perl

use Esfinge::Registo qw(new Grava);


$ObjectoRegisto = Registo::new();
$ObjectoRegisto->{NumPergunta} = 31; 
$ObjectoRegisto->{Experiencia} = "teste";
$ObjectoRegisto->GravaHistorico("Isto  uma experincia");




=head1 SEE ALSO

=head1 AUTHOR

Lus Fernando Costa, <lt>luis.f.kosta@gmail.com<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2008 by Linguateca

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.6 or,
at your option, any later version of Perl 5 you may have available.


=cut
