package Esfinge::Web;

use strict;
use warnings;
use Exporter;
use HTTP::Request;
use LWP::UserAgent;


our @ISA = qw(Exporter);
our @EXPORT_OK = qw(buscaURL HTMLTexto UTFTexto);
our $VERSION = '0.02';



=head1 FUNCTIONS

=head2 buscaURL

Esta funo permite extrair o contedo de uma pgina Web
ENTRADA 1: Um URL (string)
ENTRADA 2: Mtodo que se pretende utilizar (GET ou POST). (string)
ENTRADA 3: Valores que se pretendam submeter (usado em formulrios). (string)
ENTRADA 4: Indicao de que o acesso  feito a partir de um browser (0 ou 1).  (string)
SADA: Array em que a primeira posio tem 0 no caso de um acesso bem sucedido, -1 no caso contrrio. A segunda posio tem o condedo da pgina web da qual se pretendia extrair o contedo. (array)

Funo adaptada a partir da package CG_METRA desenvolvida por Luis Sarmento

=cut


sub buscaURL($ $ $ $)
{
       
  my $url=shift;
  my $metodo = shift;
  my $conteudo = shift;
  my $camufla = shift;

  my $UserAgent = new LWP::UserAgent;
  $UserAgent->timeout(100);
  my $header = HTTP::Headers->new(Accept=>'text/html; charset=ISO-8859-1');

  my $req = HTTP::Request->new($metodo,$url, $header);

  if ($metodo eq "POST") 
  {
    $req->content_type('multipart/form-data');
                
    if (!($conteudo eq "")) {$req->content($conteudo)};

  }
  $req->content_type('charset=ISO-8859-1');

  if ($camufla == 1) {$UserAgent->agent("Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.0.2) Gecko/20021120 Netscape/7.01");}
        
  my $resp = $UserAgent->request($req);

  my @retorno = ();
  if ($resp->is_success)
  {
    $retorno[0]=0;       
    $retorno[1]=$resp->content;
   }
   else
   {
     $retorno[0]=-1;       
     $retorno[1]= "Acesso Falhado";
   }
   return @retorno;
}


=head2 HTMLTexto

Esta funo converte cdigos HTML para ascii.
ENTRADA: Um texto (string)
SADA: O texto de entrada com os cdigos HTML convertidos (string)

Desenvolvida a partir de uma funo existente na biblioteca bib_gestao_paginas.pl da Linguateca

=cut


sub HTMLTexto ($)
{

  
  $_= shift;
  s/&#193;//g;
  s/&#225;//g;
  s/&#194;//g;
  s/&#226;//g;
  s/&#224;//g;
  s/&#192;//g;
  s/&#227;//g;
  s/&#195;//g;
  s/&#231;//g;
  s/&#199;//g;
  s/&#233;//g;
  s/&#201;//g;
  s/&#234;//g;
  s/&#202;//g;
  s/&#205;//g;
  s/&#237;//g;
  s/&#211;//g;
  s/&#243;//g;
  s/&#244;//g;
  s/&#212;//g;   
  s/&#245;//g;
  s/&#213;//g;
  s/&#218;//g;
  s/&#250;//g;
  s/&#252;//g;
  s/&#220;//g;
  s/&#169;//g;
  s/&#179;//g;
  s/&#178;//g;
  s/&#(\d+);/chr($1)/ge;
  s/&ordm;//g;
  s/&ordf;//g;
  s/&atilde;//g;
  s/&ntilde;//g;
  s/&otilde;//g;
  s/&Atilde;//g;
  s/&Ntilde;//g;
  s/&Otilde;//g;
  s/&Aacute;//g;
  s/&Eacute;//g;
  s/&Iacute;//g;
  s/&Oacute;//g;
  s/&Uacute;//g;
  s/&aacute;//g;
  s/&eacute;//g;
  s/&iacute;//g;
  s/&oacute;//g;
  s/&uacute;//g;
  s/&Agrave;//g;
  s/&Egrave;//g;
  s/&Igrave;//g;
  s/&Ograve;//g;
  s/&Ugrave;//g;
  s/&agrave;//g;
  s/&egrave;//g;
  s/&igrave;//g;
  s/&ograve;//g;
  s/&ugrave;//g;
  s/&Ccedil;//g;
  s/&ccedil;//g;
  s/&aelig;//g;
  s/&oslash;//g;
  s/&aring;//g;
  s/&Aelig;//g;
  s/&Oslash;//g;
  s/&Aring;//g;
  s/&Acirc;//g;
  s/&Ecirc;//g;
  s/&Icirc;//g;
  s/&Ocirc;//g;
  s/&Ucirc;//g;
  s/&acirc;//g;
  s/&ecirc;//g;
  s/&icirc;//g;
  s/&ocirc;//g;
  s/&ucirc;//g;
  s/&Auml;//g;
  s/&Euml;//g;
  s/&Iuml;//g;
  s/&Ouml;//g;
  s/&Uuml;//g;
  s/&auml;//g;
  s/&euml;//g;
  s/&iuml;//g;
  s/&ouml;//g;
  s/&uuml;//g;
  s/&amp;/&/g;
  s/&gt;/>/g;
  s/&lt;/</g;
  s/&quot;/"/g;
  s/&middot;/\./g;
  return $_;

   
}

=head2 UTFTexto

Esta funo converte cdigos UTF para ascii.
ENTRADA: Um texto (string)
SADA: O texto de entrada com os cdigos UTF convertidos (string)

=cut


sub UTFTexto ($) 


{
  
  $_= shift;
  s/Á//g;
  s/á//g;
  s/Â//g;
  s/â//g;
  s/\s//g;
  s/À//g;
  s/ã//g;
  s/Ã//g;
  s/ç//g;
  s/Ç//g;
  s/é//g;
  s/É//g;
  s/ê//g;
  s/Ê//g;
  s/Í//g;
  s/í//g;
  s/Ó//g;
  s/ó//g;
  s/ô//g;
  s/Ô//g;   
  s/õ//g;
  s/Õ//g;
  s/ú//g;
  s/Ú//g;
  s/ü//g;
  s/Ü//g;

  return $_;


   
}




1;

__END__

=head1 NAME

Esfinge::Web

Esfinge::Web - Mdulo que permite extrair e manipular texto da Web.

=head1 SYNOPSIS

Este mdulo inclui mtodos teis para manipular texto da Web.

Exemplo de utilizao da package Web

#!/usr/local/bin/perl

use Web;

@Resultado = buscaURL("http://www.linguateca.pt/www_linguateca_pt.html", GET, "", 0);

if ($Resultado [0] eq -1) {

  print "Acesso falhado\n";

}
else {

  print HTMLTexto($Resultado [1]) . "\n";

}



=head1 SEE ALSO

Esfinge::Google
Esfinge::Yahoo

=head1 AUTHOR

Lus Fernando Costa, E<lt>luis.f.kosta@gmail.comE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2008 by Linguateca

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.6 or,
at your option, any later version of Perl 5 you may have available.


=cut
