package Esfinge::Yahoo;


use strict;
use warnings;
use Exporter;

# Dependncias

use Yahoo::Search AppId => "esfingept";
use XML::Simple;
use Esfinge::Web qw(buscaURL HTMLTexto);
use Unicode::MapUTF8 qw(from_utf8 to_utf8);

our @ISA = qw(Exporter);
our @EXPORT_OK = qw(RetornaPassagensPadrao);
our $VERSION = '0.01';


=head1 FUNCTIONS

=head2 RetornaPassagensPadrao

Esta funo usa a API do Yahoo para procurar ocorrncias de padres num determinado idioma.
ENTRADA 1: Um padro definido com a sintaxe dos motores de busca (exemplo: "Lisboa fica" quer dizer que se procuram ocorncias da palavra "Lisboa" seguidas da palavra "fica") (string)
ENTRADA 2: Um Cdigo de idioma (exemplo: se queremos pginas escritas em portugus, o cdigo  "pt") (string)
ENTRADA 3: O nmero de passagens que se pretende obter (inteiro)
ENTRADA 4: Um array contendo padres que identificam sites que se pretendem ignorar (array)
SADA: Array em que cada posio contm uma hash com duas chaves: texto (onde se pode obter o texto da passagem) e url (onde se obtm o url associado  passagem) 


=cut


sub RetornaPassagensPadrao ($ $ $ @)
{

  my $Padrao = shift; 
  my $Lingua = shift;
  my $NumeroPassagens = shift;
  my @urls_desinteressantes = ();

  foreach $_ (@_) {
      
    push(@urls_desinteressantes, $_);
      
  } 

  # Array devolvido por esta funo. Cada posio contm uma hash com duas chaves: texto (onde se pode obter o texto da passagem) e url (onde se obtm o url associado  passagem)
  
  my @Passagens = ();

  $Padrao = to_utf8 ({-string => $Padrao, -charset => 'ISO-8859-1' });

  $Padrao =~ s/\s/+/g;

  my $PrimeiraPassagem = 0;
  my $NumeroPassagensPedido = 0;
  my $indice_excertos = 0; 
  my $total_resultados = 0;


  do {

    if ($PrimeiraPassagem + 100 > $NumeroPassagens) {

      $NumeroPassagensPedido = $NumeroPassagens - $PrimeiraPassagem;

    }
    else {

      $NumeroPassagensPedido = 100;

    }

    my @PaginaWeb = ();

    $PaginaWeb [1] = "Acesso Falhado";
	  
    while ($PaginaWeb [1] eq "Acesso Falhado") {

      eval{

        @PaginaWeb = buscaURL("http://api.search.yahoo.com/WebSearchService/V1/webSearch?appid=esfingept&query=" . $Padrao . "&results=100&start=" .  $PrimeiraPassagem  . 
                            "&language=" . $Lingua, "GET", "", 1);
      }
    
    } 


    my $XML = XMLin($PaginaWeb[1]);

    my @ConjuntoResultados= ();
    my $RefConjuntoResultados;
    
    $total_resultados = $XML->{totalResultsReturned};

    if ($total_resultados == 0) {return (@Passagens)};

    if ($total_resultados == 1) {

      $ConjuntoResultados [0] = $XML->{Result};
      $RefConjuntoResultados = \@ConjuntoResultados;

    }
    else {

      $RefConjuntoResultados = $XML->{Result};


    }

    my $num_results = 0;

    foreach my $result (@{$RefConjuntoResultados}) {
  
      unless (grep {$result->{Url} =~ m/$_/g} @urls_desinteressantes or $indice_excertos  == $NumeroPassagens) {

        my $Snippet = $result->{Summary};

	$Snippet =~ s/\.\.\.//g;

	$Snippet = from_utf8({ -string => $Snippet, -charset => 'ISO-8859-1' });
        $Snippet = HTMLTexto($Snippet);

	$Passagens [$indice_excertos] {texto} = $Snippet;

	# Registar os urls de origem
       
	$Passagens [$indice_excertos] {url} = $result->{Url};

	$indice_excertos ++;
 
      }
      
    }
 
    $PrimeiraPassagem += 100;

  } until ($indice_excertos  == $NumeroPassagens or $total_resultados < 100);

  return (@Passagens);
  

}

1;

__END__

=head1 NAME

Esfinge::Yahoo

=head1 SYNOPSIS

Este mdulo permite extrair texto da Web usando a API do Yahoo.


Exemplo de utilizao da package Yahoo


use Esfinge::Yahoo qw(RetornaPassagensPadrao);


my $padrao = "criador de Tintin";

my $lingua = "pt";

my $NumeroPassagens = 100;

my @urls_desinteressantes = ("weblogger.terra.com.br", "blogspot.com", "blogs.sapo.
pt", "weblog.com.pt", "blogger.com.br", "blog.uol.com.br", "humor", "piadas", "e
mails");



@PassagensYahoo  = RetornaPassagensPadrao($padrao, $lingua, $NumeroPassagens , @urls_desinteressantes);

$IndicePassagens = 1;		
        
for $i (0 ..  $#{@PassagensYahoo}) {
	         
  print "\nPassagem $IndicePassagens= " . $PassagensYahoo [$i] {texto} . "\
(" . $PassagensYahoo [$i] {url} . "\)\n"; 
	   	    
  $IndicePassagens ++;
		    
		    
}


=head1 SEE ALSO

=head1 AUTHOR

Lus Fernando Costa, E<lt>luis.f.kosta@gmail.comE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2008 by Linguateca

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.6 or,
at your option, any later version of Perl 5 you may have available.


=cut
