<?php 

$title="$collection topic collection administration";
print_header();
pagePrivileges('admin');

if($_GET['init']){
  require_once("_assessor.php");
  initCreateSet($collection);
}
?>


Topic set administration:
<div class=box2>
<TABLE>

<tr><th colspan=2 width=300 align=left>Specific tasks

<tr>
<td valign=top><a href="?collection=<?=$collection?>&init=1">Initialize topic set</a>
<td>This makes sure all required directories are created and with the right permissions. It also checks whether all required database tables for the topic set are created. 

<tr>
<td valign=top><a href="viewCollection.php?collection=<?=$collection?>">Edit</a>
<td>Change title, start and end dates, number of runs, upload files 

<tr>
<td valign=top><a href="index_admin.php?deleteCollection=<?=$collection?>" onclick="return confirm('Are you sure you wish to delete <?=$collection?>')">Delete topic set</a>
<td>This will delete this topic. Are you really sure you want to do this?

<tr><th colspan=2 align=left>Management

<tr>
<td valign=top><a href="readResources.php?collection=<?=$collection?>" onclick="return confirm('Are you sure you wish to read files? you might override new data that has been managed')">Read topics from files</a>
<td>
If you already have the set of topics in several files (one per language), you can place them in the collections set directory (manually or by uploading in the "Topic set" area) and fill the database from them. The files have to be named after the language name in English (Bulgarian.txt, Portuguese.txt, etc.)

Note that each line in the file must be in the following format:<br>
TOPIC NAME: TOPIC QUESTION<br>
The topic name should have no spaces, dots or special characters (such as punctuation, or accented characters). The topic question should be in UTF-8<br>

<tr>
<td valign=top><a href="genResources.php?collection=<?=$collection?>">Generate resource</a>
<td>
After all topics have been created, this generates the topic set files that GikiCLEF participants can download. having only topic id and topic question. (Narratives and answers are only visible to those with access to the management system.) The files are created with the language name in English, and in XML and txt. Finally, a simple table containing the existing topic answers per language is given in the topic area.
<tr>
<td valign=top><a href="topicStats.php?collection=<?=$collection?>"></a>
<td>
A simple table containing topic answers per language given in the topic area.

<tr><th colspan=2 align=left>Assessment

<tr>
<td valign=top><a href="assessor.php?collection=<?=$collection?>&createPool=1">Create document pool</a>
<td>
After participants uploaded their runs, this process parses each run, and generates a list of valid answers and the required files for the assessment. The corresponding Wikipedia files are extracted from the XMLCollection into a pool directory for assessment purposes.
<br><a href="assessor.php?collection=<?=$collection?>&createPool=1&noUnzip=1">Quick pool</a> (No unzip files) 
<tr>
<td valign=top><a href="assessor.php?collection=<?=$collection?>&createAssessment=1">Parse answers</a>
<td>After pool creation, a file with all (syntactically valid) answers produced by the users is created.

<tr>
<td valign=top><a href="assessor.php?collection=<?=$collection?>&autoAssess=1">Automatic pre-assessement</a>
<td>The automatic assessment process is run before manual assessment begins. It does the following checks:
<ul>
<li>is the answer already present as a valid answer in the database as self justified? If yes, automatically classify it as both Correct and Justified
<li>is the answer a redirect? In that case, mark it as Incorrect
<li>is the answer a categories list, a picture or some other invalid type? In that case, mark it as Incorrect
<li>is the answer missing from the collection (both XML and HTML)? In that case, mark it as Incorrect
</ul>
<a href="assessor.php?collection=<?=$collection?>&autoAssess=1&safe_auto=1">Safe Automatic pre-assessement</a> does not clean assess and does not override previoully assessed files
<br><br>

<tr><td><a href="assessorTask.php?collection=<?=$collection?>">Task distribution</a><td> Distribute the answers by the assessor

<tr><th colspan=2 align=left>Evaluation

<tr>
<td valign=top><a href="calculateScores.php?collection=<?=$collection?>">Score computation</a> 
<td>
After manual assessment score is done, this processes all submissions, in order to compute the scores. Note that it can produce warnings, either because of conflicting assessments or due to not yet evaluated answers.<br>
A file will be created per run, containing the detailed scores (per language, per topic and so on), which participants will be able to see in the  <a href="submissionResults.php?collection=<?=$collection?>">result page</a>.
<br>
<a href="calculateScores.php?collection=<?=$collection?>&preview=1">Test the score computation</a> (runs the score computation but does not save the results thus not making it visible to the participants). You can also test individually each run. 
<tr>
<td valign=top>Global results 
<td>Public page with the results and statistics of all participating systems<br>
<a href="calculateGlobal.php?collection=<?=$collection?>&preview=1">Preview</a> (temporary page that only the administrator visualizes)<br>
<a href="calculateGlobal.php?collection=<?=$collection?>">Make Public</a>(Visible to all participants)

<tr><td valign=top><a href="statistics.php?collection=<?=$collection?>">Generate statistics table</a>
<td>
 This generates more data on the total results</h3>

<tr><td valign=top><a href="fix_correct_answers_results.php?collection=<?=$collection?>">Generate documents files</a>
<td><p>This tool generates a file that can be downloaded (saved), containing all answers  (given  by topic managers and by the systems) that are considered correct.<br>
It will generate a file 'COLLECTION_corrects.txt' in the root file of the system.

<tr><th colspan=2 align=left>Post Event tools

<tr><td valign=top><a href="lock_assessments.php?collection=<?=$collection?>">Lock assessments</a>
<td><p>This will lock the assessments. Assessments will still be possible but the new assessmnets will be stores in another table. some interfaces will allow you  to choose wich version to use.<br><b>Note:</b> you may lock the table more than once but you will lose previous data

<tr><td valign=top><a href="assessor.php?collection=<?=$collection?>&createPool=1&postEvent=1">Create partial Pool</a>
<td><p>This will read the test runs directory to generate acquire the documents from the <b>new</b> answers provided. It will only add new documents.

<tr><td valign=top><a href="assessor.php?collection=<?=$collection?>&autoAssess=1&safe_auto=1">Safe automatic pre- assessment</a>
<td><p>This will test for  invalid or not found documents files in the pools collection.

<tr><th colspan=2 align=left><br>See also the <a href=fix.php>list</a> of tools/fixes available.
<br><br> 
</table>
</div>

