--
-- This table is set to store some extra values
-- such as topic created, last permid inserted
CREATE TABLE %TOPIC%_vars (
  name varchar(25) NOT NULL,
  value varchar(255) NOT NULL,
 PRIMARY KEY (name)
);

--
-- question in table , onwer
DROP TABLE IF EXISTS %TOPIC%_question;

CREATE TABLE %TOPIC%_question (
  question_id varchar(25) NOT NULL,
  assessor varchar(255)default '',  
  narrative longtext default "",
PRIMARY KEY (question_id)
);

--
-- question translation in each language
DROP TABLE IF EXISTS  %TOPIC%_questiontext;

CREATE TABLE %TOPIC%_questiontext (
  question_id varchar(25) NOT NULL,
  lang varchar(2),
  question varchar(255) NOT NULL,
  assessor varchar(25) default '',
  PRIMARY KEY (question_id, lang)
);

--
-- Table with assessors given answer
-- answers will be fileld in by assessors
DROP TABLE IF EXISTS  %TOPIC%_answers;

CREATE TABLE `%TOPIC%_answers` (
  `question_id` varchar(25) NOT NULL,
  `lang` varchar(2) NOT NULL,
  `assessor` varchar(25) NOT NULL,
  `answer` varchar(255) NOT NULL default '',
  `comment` longtext,
  `auto_justified` varchar(5) default NULL,
  PRIMARY KEY  USING BTREE (`question_id`,`answer`)
) 

--
-- Table generates a permanent id to the tuple answer, justification
DROP TABLE IF EXISTS  %TOPIC%_permid;

--
-- Topic answer  contains unique tuples a 
DROP TABLE IF EXISTS  %TOPIC%_topicanswers;

CREATE TABLE %TOPIC%_topicanswers (
  permid  varchar(255)  NOT NULL,
  question_id varchar(25)  NOT NULL,
  lang varchar(2)  NOT NULL,
  answer text,
  justification text,
  score INTEGER DEFAULT 0,
  c INTEGER DEFAULT 1,
  PRIMARY KEY (permid, question_id)
);


DROP TABLE IF EXISTS  %TOPIC%_useranswers;

CREATE TABLE %TOPIC%_useranswers (
  permid varchar(255)  NOT NULL,
  user_id varchar(25) NOT NULL,
  run INTEGER NOT NULL,
  lang varchar(2)  NOT NULL,
  extra_field text, 	
PRIMARY KEY (permid, user_id, run)
);

-- Table of assessor evaluation
-- question score is (correct|incorrect|undetermined|null)
-- justification is (Justified|unjustified)
-- assessor can leave a comment
DROP TABLE IF EXISTS  %TOPIC%_assessorvalidation;

CREATE TABLE %TOPIC%_assessorvalidation (
  permid  varchar(255) NOT NULL,
  assessor varchar(25) NOT NULL,
  question_score VARCHAR(25) default 0,
  justification_score VARCHAR(25) default 0,
  comment TEXT, 	
PRIMARY KEY (permid, assessor)
);


-- permid can become a md5(answer+ jsutification) due to the size of answer being bigger than 255chars and max varchar in mysql being 255 (text can not be key)