<?php

function evaluate($file, $original_name='', $topics=array()){
  global $e;
  $e=new Submission($file, $original_name,$topics);
  $e->evalFile();
  return $e->error_count();
}


class Submission{
  protected $self = array();
  protected $files = array();
  protected $answers = 0;
  protected $error_count =0;
  protected $read=false;
  
  public function __construct( $file, $original='', $topics=array()) {
    
    $this->self['file'] = $file;    
    $this->self['evalfile'] = preg_replace("/_src$/","_eval",$this->self['file']);

    $tmp_file=preg_replace('/\/([^\/]+)$/','/.$1',$this->self['evalfile']);
    $this->self['original_name'] = $original ? $original:
      file_get_contents($tmp_file);
    file_put_contents($tmp_file, $this->self['original_name']);
    
    if($topics)
      $this->validTopics( $topics);      
    $this->readSubmission();
  }
  
  
  public function readSubmission(){
    global $utf8_line, $languages;

    $this->read=true;
    
    $this->self['contents']=file_get_contents($this->self['file']);    
    $this->self['encoding']= $this->is_utf8()?true:false;
    $this->self['encoding_ok'] =$this->self['encoding'];
    if(!$this->self['encoding']){
      $this->self['error'].="Wrong encoding at line $utf8_line: File is not UTF-8\n";
      $this->error_count++;
    }

    $line_count=0;
    $this->self['langs'] = array();
    $this->self['answers'] = array();
    $this->self['files'] = array();
    $this->self['answers_tuples'] = array();
    
    $filename=pathinfo($this->self['file'], PATHINFO_FILENAME);    
    preg_match('/^(.*)_(\d+)_(src|eval)$/',$filename, $atr);
    array_shift($atr);
    
    $user=$atr[0];
    $run=$atr[1];
    
    $topics=$this->self['valid_topics'];
    $lines=explode("\n",$this->self['contents']);
    
    foreach (explode("\n",$this->self['contents']) as $line){
      $line_count++;
      $file_regexp='(?:'.implode('|',array_keys($languages)).')\/[^\s]+';
      
      if(!$line){
	continue;
      }
      
      // test  syntax
      if(!preg_match("/^([\w\-]+)\s+($file_regexp)\s+\{((?:$file_regexp)?(?:\s+$file_regexp)*)\s*\}\s*([^\n]*)?/",
		     $line,$resp)){
	$test= split('[\}\{]',$line);
	
	if(preg_match('/^\s*$/',$test[0])){	  
	  $this->self['error'].="Empty line at line $line_count;\n";	  
	  $emptylines++;
	  
	}elseif(!preg_match('/^[\w\-\_]+\s+/',$test[0])){	  
	  $this->self['error'].="Wrong syntax in topic id line $line_count: \t$line\n";	  
	  
	}elseif(!preg_match('/\s($file_regexp)\s*/',$test[0])){
	  $this->self['error'].="Wrong syntax at answer, line $line_count: \t$line\n";
	  
	}elseif(!preg_match('/^[\w\-\_]+\s+($file_regexp)\s*/',$test[0])){
	  $this->self['error'].="Wrong syntax at beginning of line $line_count: \t$line\n";	  
	  
	}elseif($test[1] && !preg_match('/((?:$file_regexp)?(?:\s+$file_regexp)*)\s*/', $test[1])){
	  $this->self['error'].="Wrong syntax in justification at line $line_count: \t$line\n";	  
	  
	}elseif($test[2] && preg_match('/\s*([^\n]*)?/',$test[2])){
	  $this->self['error'].="Wrong syntax at the end of line $line_count: \t$line\n";
	  
	}else
	  $this->self['error'].="Wrong syntax at line $line_count: \t$line\n";
	
	$this->error_count++;
	continue;	
      }
      
      $this->self['out'].="Line:$line_count";	
      
      $resp[0]=substr($resp[2],0,2);
      $lang=$resp[0];
      
      $id=$resp[1];
      
      if($topics && !preg_match("/^($topics)$/", $id)){
	$this->self['error'].="Invalid topic id at line $line_count: \t$line\n";
	$this->error_count++;
	continue;
      }
      
      // test files? too complicated 
	
      
      $response=$resp[2];
      //      if(!preg_match('/\.(html|xml)$/',$response)){
      //	$this->self['error'].="Answer Document extension not specified at line $line_count: \t$line\n";
      //	$this->error_count++;
      //	continue;
      //      }
      
      $answer_lang= substr($response, 0,2);
      $justification=array_filter(preg_split("/(,\s*|\s+)/",$resp[3]));	
      if($justification){
	$just_error=false;
	foreach($justification as $jb){
	  //	  if($jb &&  !preg_match('/\.(html|xml) /',"$jb ")){
	  //	    $this->self['error'].="Justification document(s) '$jb' extension not specified at line $line_count: \t$line\n";
	  //	    $this->error_count++;
	  //	    $just_error=true;
	  //	    continue;
	  //	  }else
	    if($answer_lang != substr($jb,0,2)){
	    $this->self['error'].="Answer & justification languages do not match ($answer_lang , ".substr($jb,0,2).") at line $line_count: \t$line\n";
	    $this->error_count++;
	    $just_error=true;
	    continue;
	  }
	}
	if($just_error) continue;
      }
      
      $answers++;
      
      $comment=$resp[4];	       
      $this->self['out'].= "$line\n\t$id $lang\nResp: $response\nJust: ".join("\t",$justification)."\nComm: $comment \n";	
      
      $this->self['answer_count']++;
      $this->self['answers'][$id][$lang]++;
      if(count($justification)){
	$this->self['justification'][$id]++;
	$this->self['justification_count']++;
      }
      $this->self['langs'][$lang]++;	
      
      $this->self['files'][$response]++;	  
      sort($justification); 
      foreach ($justification as $j){
	$this->self['files'][$j]++;	  
      }		  
      $this->self['answers_tuples']["$id\t$lang\t$response\t".join("\t",$justification)]++;
      $this->self['answers_txt'].= "$user\t$run\t$line\n";		
    }
    
    
    if($this->self['error'])
      return false;    
    return true;    
  }  
  
  public function validTopics( $topics) {    
    $this->self['valid_topics'] = implode("|",$topics);    
    
  }

  public function get($arg){
    return $this->self[$arg];
  }
  
  public function  keys(){
    return array_keys($this->self);
  }
  
  public function error_count(){    	
    return $this->error_count;
  }

  
  public function evalFile(){
    global $languages;

    if (!$this->read)
      $this->readSubmission();
    
    $evalfile=$this->self['evalfile'];

    
    $filedate=date("d-m-y G:i", filemtime($this->self['file']));    
    $filesize='size: ' . filesize($this->self['file']);

    //    $atr= explode("_",pathinfo($this->self['file'], PATHINFO_FILENAME));
    $filename=pathinfo($this->self['file'], PATHINFO_FILENAME);    
    preg_match('/^(.*)_(\d+)_(src|eval)$/',$filename, $atr);
    array_shift($atr);

    $version=date("d-m-y G:i", filemtime("evaluator.php"));
    
    $short_summary=($this->self['encoding']?"UTF-8 OK;":"Not utf-8;")
      ." " . $this->self['answer_count'] ." answers" 
      ." / ".  $this->error_count ." errors";    
    
    $long_summary="
<b>Original filename</b>:".$this->self['original_name']."<br>
<b>Owner</b>: $atr[0]<br>
<b>Run</b>: $atr[1]<br>
<b>File</b>: Uploaded $filedate;  $filesize bytes<br>
<b>Encoding</b>: ".($this->self['encoding'] ? "UTF-8" : "Not UTF-8") ."<br>
<b>Answers</b>: ".$this->self['answer_count']." correctly parsed<br>
<b>Errors</b>: ".$this->error_count." error(s) found <br>
<b>Answer table</b>:<br>
<hr>";
     
    $extended_summary="
Eval Version: $version
Original filename:".$this->self['original_name']."
Owner: $atr[0]
Run: $atr[1]
File: Uploaded $filedate;  $filesize bytes
Encoding: ".($this->self['encoding']?"UTF-8":"Not UTF-8")."
Total Answers: ".$this->self['answer_count']."
Total Error: ".$this->error_count." errors
";

    $lng=array_keys($languages);
    sort($lng);
    $long_summary.="Answers table:<table border=1>
<tr><td>Question ID<td>" .join("<td>",$lng) ."<td>Total<td>Justifications<td>";

    if($this->self['answers']){
      foreach($this->self['answers'] as $ak=> $av){
	$t1=0;
	$long_summary.="\n<tr><td>$ak";
	foreach ($lng as  $l){
	  $t1+=$av[$l];
	  $long_summary.="<td> ".($av[$l]?$av[$l]:0);	
	}
	$long_summary.="<td>$t1<td>".($this->self['justification'][$ak]? $this->self['justification'][$ak]:0);
      }
    }

    $long_summary.="\n<tr><td><b>Total</b>";
    foreach ($lng as  $l)
      $long_summary.="<td>".($this->self['langs'][$l]?$this->self['langs'][$l]:'0');
    $long_summary.="<td>".$this->self['answer_count']."<td>".$this->self['justification_count'];
    $long_summary.="\n<tr><td>Question ID<td>".join("<td>", $lng) ."<td>Total<td>Justifications";
    $long_summary.="</table>";
    $long_summary.="<br>List of errors:<div color=red><pre>".$this->self['error']."</pre></div>";
    
    
    $extended_summary.=$this->self["out"]."\n---------------------------\n";
    $extended_summary.=$this->self["error"]. "\nTotal errors: ". $this->error_count;
    
    $eval_contents=implode("SUMMARY_CONTENT", array($short_summary,$long_summary,$extended_summary));
    file_put_contents($evalfile,$eval_contents);  

  }
  
  public function is_utf8(){
    $str=$this->self['contents'];
    $c=0; $b=0;
    $bits=0;
    $len=strlen($str);
    global $utf8_line;
    $utf8_line= 1;
    
    for($i=0; $i<$len; $i++){
      if($str[$i]=="\n"){$utf8_line++;}
      
      $c=ord($str[$i]);  
      if($c > 128){
	if(($c >= 254)) return false;
	elseif($c >= 252) $bits=6;
	elseif($c >= 248) $bits=5;
	elseif($c >= 240) $bits=4;
	elseif($c >= 224) $bits=3;
	elseif($c >= 192) $bits=2;
	else return false;
	if(($i+$bits) > $len) return false;
	while($bits > 1){
	  $i++;
	$b=ord($str[$i]);
	if($b < 128 || $b > 191) return false;
	$bits--;
	}
      }
    }
    return true;
  }
}

?>