<br>
<?php

function readSubmissions($collection){
  global $upload_dir, $pool_repository, 
    $pool_files, $pool_answers, $pool_text,
    $pool_summary;
  
  $files=array();
  $answers=array();
  $text="";
  
  if (!file_exists($upload_dir.$collection)){
    print "Collection  $upload_dir$collection does not exist";
    return false;
  }
  
  if(!file_exists($pool_repository.$collection)){
    $ok=mkdir("$pool_repository$collection", 0777, true);
    if($ok) print "Created pool $collection\n";
    else print "Failed to create pool $pool_repository$collection\n";    
  } 
  

  require_once('_assessor.php');
  $ts= _questions($collection);  
  $topics=array();
  foreach($ts['en'] as $id => $d) {
    $topics[$id]=1;
  }
    
  #read all files 
  require_once("evaluator.php");
  
  $submissions=0;
  $handler = opendir($upload_dir.$collection);   
  while ($file = readdir($handler)){ 
    if(!preg_match('/_src$/',$file))
      continue;
    $f= $upload_dir.$collection."/$file";
  
    $e = new Submission($f,'', array_keys($topics));
    print "$f<pre style='border:1px solid black'>".$e->get('error')."</pre>";
    $text.=$e->get("answers_txt");

    foreach($e->get("answers_tuples") as $k => $v){
      $answers[$k]+=$v;
    }
    foreach($e->get("files") as $k => $v){
      $files[$k]+=$v;
    }
    $submissions++;
  }

  $c= count(explode("\n",$text));
  
  $_files= array_filter(array_keys($files));
  $_files=preg_replace('/\..*$/',".xml",$_files);

  //save all files
  file_put_contents("$pool_repository$collection/$pool_files",
		    implode("\n",$_files));  
  //save all questions text 
  file_put_contents("$pool_repository$collection/$pool_text",
		    $text);

  //save all questions 
  file_put_contents("$pool_repository$collection/$pool_answers",
		    implode("\n",array_keys($answers)));
  //short summary to prevent calculating all values every time
  file_put_contents("$pool_repository$collection/$pool_summary",
		    count($answers)." distinct answers(out of $c total) found in $submissions submissions, refering ".count($files)." files.<br>");
  
  print "$submissions submissions considered<br>";
  print count($answers)." distinct answers<br>";
  print count($_files)." files marked<br>";
  print "$c total answers (includes repetitions)<br>";
  
  return $_files;
}


function viewFile($file, $collection){
  global $pool_repository;
  
  if (file_exists($$pool_repository.$collection."/".$file)){
    return get_file_contents("$pool_repository$collection"."/".$file);
  }else{
    return "";
  }
}

function pool2assess($collection){
  global $pool_repository, $pool_text;
  print "Acquiring user answers tables<br>";  
  $incr=0;  
  $file_regexp='(?:bg|de|en|es|it|nl|nn|no|pt|ro)\/[^\s]+';


  $s1="delete from IGNORE INTO ${collection}_useranswers";
  mysql_query($s);
  
  foreach (explode("\n",file_get_contents($pool_repository.$collection."/".$pool_text)) as  $line){        
    if(!$line) continue;      
    if(!preg_match("/^([\w_-]+)\s+(\d+)\s+([\w\-]+)\s+($file_regexp)\s+\{((?:$file_regexp)?(?:\s+$file_regexp)*)\s*\}\s*([^\n]*)?/"
		   ,$line,$resp)){
      print "error at line $line_count\n\t'$line'\n";
      continue;
    }

    
    print "$line<br>";
    $line_count++;
    $user=$resp[1];
    $run =$resp[2];
    $question=$resp[3];
    $answer=$resp[4];
    $lang= substr($answer,0,2);
    
    $just_tmp=split(", | ",$resp[5]);
    sort($just_tmp);
    
    $justification= implode(" ", $just_tmp);

    $comment=htmlentities($comment,ENT_COMPAT);

    $str="$question $answer $justification";
    $str=preg_replace("/  /",' ',$str);
    $permid=md5($str);
    
    $source = preg_replace('/.*\.(\w*)$/',"$1", $answer);
    $answer = preg_replace('/\.(\w*)$/',"", $answer);
    
    $s="INSERT INTO ${collection}_collectionanswers 
VALUES('$permid','$question',  '$lang', 
\"$answer\",\"$justification\", 0, 1,\"$source\")
ON DUPLICATE KEY UPDATE c=c+1
";
    
    $s1="INSERT IGNORE INTO ${collection}_useranswers
VALUES('$permid', \"$user\", \"$run\", '$lang', \"$comment\")";
    
    //    print "$s <br>---  $s1<br>";
    if(!mysql_query($s))
      print "<pre>$s<br>". mysql_error()."</pre>"; 
    if(!mysql_query($s1))
      print "<pre>$s1 <br>". mysql_error()."</pre>";
    
    $incr++;  
  }
    print "$incr answers inserted ";
}

function generatePool($files, $collection, $clean=false){  
  global $languages, $collection_repository, $pool_repository;  
  $langs_short = array_keys($languages); 
  $message="";  
  print "<pre>";
  
  if(!file_exists($pool_repository.$collection)){
    $ok=mkdir("$pool_repository$collection", 0777, true);
    if($ok) print "Created pool $collection\n";
    else print "Failed to create pool $pool_repository.$collection\n";    
  }
  
  else if($clean){
    rmdir_recurse($pool_repository.$collection);
    $ok=mkdir($pool_repository.$collection, '777', true);
    if($ok) print "Cleaned pool $collection\n";
    else print "Failed to clean pool $pool_repository$collection\n";        
  }  
  
  $utime=time();    
  foreach($langs_short as $lang){
    if($sub_files =preg_grep("/^\/?$lang\/.*/",$files)){
      $sub_files=preg_replace('/\.html/','',$sub_files);
      $sub_files=preg_replace('/\.xml/','',$sub_files);
      $time= time();
      print "Retrieving ".count($sub_files)." files from $lang... ";
      
      $lang_rep= ereg_replace("DIRLANG", $lang, $collection_repository);
      if(!file_exists("$lang_rep")){
	print "<br>Repository missing? '$lang_rep'<br>";
	continue;
      }
      $handler = opendir($lang_rep); 
      while ($file = readdir($handler)){ 
	if (preg_match('/.zip$/i', $file)){		
	  $cmd ="unzip $lang_rep$file \"". 
	    implode( ".xml\" \"",$sub_files). 
	    ".xml\" -d$pool_repository$collection";
	  $res= exec($cmd);
	  //	  print $cmd."<br>";
	  //file_put_contents('unzip.log',"$cmd\n",FILE_APPEND);	  
	}		
      }      
      closedir($handler);
      //again  patch for the de
      if($lang=='de'){
	$lang_rep= ereg_replace("DIRLANG", $lang, $collection_repository);
	$lang_rep= preg_replace('/current/','v1.1',$lang_rep);
	if(!file_exists( $pool_repository.$collection))
	  mkdir($pool_repository.$collection); 
	$cmd="unzip -o $lang_rep \"$file\" -d$pool_repository$collection";     
	$res= exec($cmd);
	//	file_put_contents('unzip.log',"$cmd\n",FILE_APPEND);	  	
      }
      $time=time()- $time;
      print  $time ." seconds\n";
    }
  }
  print "</pre>";
}


function testPool($collection, $files=array()){
  
  global $pool_files, $pool_repository;
  
  if(count($files)<=0){
    $files=explode("\n", file_get_contents($pool_repository."$collection/$pool_files"));
  }
  
  
  $res=exec("find $pool_repository$collection  -type f|grep xml\|html",$out);
  
  if(count($out)<=0){
    print "File pool was not created<br>";
    return false;
  }

  $out =  preg_replace('/\(/',"\\(",$out);
  $out =  preg_replace('/\)/',"\\)",$out);
  $out=preg_replace('/\.html/','',$out);
  $out=preg_replace('/\.xml/','',$out);
  $expr=implode("|",preg_replace('/^.*\//',"",$out));  

  $not_found= array_filter(preg_grep("/$expr/",$files, PREG_GREP_INVERT)); 
  
  if($not_found){
    print "<b>Missing ".count($not_found)."\\".count($files)." files</b><br> * "
      .implode("<br> * ",$not_found)."<br>";
    return false;    
  }
  print "All files marked(".count($files).") have been decompressed<br>";
  return true;
}


function rmdir_recurse($path)
{
    $path = rtrim($path, '/').'/';
    $handle = opendir($path);
    while(false !== ($file = readdir($handle)))
    {
        if($file != '.' and $file != '..' )
        {
            $fullpath = $path.$file;
            if(is_dir($fullpath))
                rmdir_recurse($fullpath);
            else
                unlink($fullpath);
        }
    }

    closedir($handle);
    rmdir($path);
}



function test(){
  $files=array('en/b/a/c/Backs_to_the_Land_17f5.xml',
	       'en/b/a/c/BachuÃ©.xml', 
	       'en/b/a/c/Baccalaureate_services.xml', 
	       'en/f/l/o/Florence,_Indiana_975c.xml',
	       'en/f/l/o/Florence_Riefle_Bahr_8fc1.xml',
	       "en/f/l/a/Flannery_O_'Connor_bibliography_f897.xml",
	       "pt/j/u/s/Juscelino_kubitscheck.xml",
	       'pt/j/u/s/Justino_Ferreira_Carneiro_0454.xml',
	       'pt/j/u/l/Juliusz_sÅowacki.xml',
	       'pt/j/o/s/Joseph_isaac_schneersohn.xml',
	       );
  pool($files, "testePool");
}


?>