<?php 

$title="GikiCLEF submission of runs";
print_header();

require_once("collections.php");

if ( isset($_POST['submitRun'])){  
  $username= $_SESSION['userName'];
  $run = $_POST['run'];  
  $collection = $_POST['collection'];  
  
  if( !$collection ){
    $error = "Collection not defined!";
  } else if( !$run ){
    $error = "Run not defined!";
  } else if(!$collections[$collection]['status_available']){
    $error = "Collection is not available!";
  } else if(!$collections[$collection]['status_active']){
    $error = "Collection has not been activated!";
  } else if($collections[$collection]['was_active']){
    $error = "Collection activation expired!";
  }else if( $collections[$collection]['status_old']){
    $error = "Collection has expired!";
  }else {
    if(!file_exists($upload_dir."$collection/")){
      mkdir($upload_dir."$collection/");
    }    
    $local_file = $upload_dir."$collection/${username}_${run}_src";
    
    if(move_uploaded_file($_FILES['run_file']['tmp_name'], $local_file)){
      print "<center><font color=green><b>File was successfully uploaded.</b></font><br></center>";
      require_once('evaluator.php');

      require_once('_assessor.php');
      $ts= _questions($collection);

      $topics=array();
      foreach($ts['en'] as $id => $d) {
	$topics[$id]=1;
      }

      $err = evaluate($local_file, $_FILES['run_file']['name'], array_keys($topics));    
      if($err){
	print "<center><font color=red><b>$err errors/warnings were found.</b></font><br>
Please check the details of your submission and correct the errors before trying to submitting your run again.
<b><div align=left>Note:</b> Lines with errors will be ignored.
<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Runs not in UTF-8 (incorrect encoding) will be completely disregarded  </b></div></center>
";    
      }else{
	print "<font color=green><No error appears to have been found.</font>"; 
      }
      //_serLog("Submission at $collection, run $run");
      storeLog('','',$collection,'','Submission',
	       $run);
    }else{
      $error="There was an error while uploading ". $_FILES['run_file']['name'];
    }
  }
}

if($error){
  print "<center><font color=red>$error</font></center>";
}

if(($collection && $collections[$collection]["status_active"] ) ){
?>

<form name=submit method=POST  enctype="multipart/form-data">
<b>Submit run</b>:<br>
<input type=file name=run_file>
<?php

require_once("collections.php");
if(isset($collection)){
  if($collections[$collection]["status_active"]){
    print "<input type=hidden name=collection value=\"".$collection."\">";
  }
}else{
  ?>
<select name=collection onchange="setXRuns(this.value)">
<option value=""> -- Choose collection -- 
   <?php
   $script="";
 foreach ($collections as   $collection){
   if($collection["status_active"]){
     print "<OPTION>". $collection["name"] ;
     $script.="collection[\"".$collection["name"]."\"]=".$collection['runs'].";\n";
   }  
 }
 print "</select>
<script type=\"text/javascript\">
var collection=new Array();
$script

function setXRuns(t){
  var x= collection[t] || 0;
  document.submit.run.options.length=1;
  for(var i=1; i<= x;i++){
    document.submit.run.options[i]= new Option(\"Run \"+ i, i, false, false);
  }
} 
</script>
";
}

?>
		   
<select name="run">
<option  value=''> -- Select Run --</option>
<?php
if(isset($collection)){
  if($collections[$collection]["status_active"]){
    for ($i=1;$i<=$collections[$collection]["runs"];$i++){
      print "<option value=\"$i\"> Run $i";
    }
  }   
}
?>

</select><input type=submit name=submitRun value="Submit Run"></table></form>
<?php
    }
print "<br>";

require_once("submissions.php")
?>