#!/usr/bin/perl

$debug=0;

if ($ARGV[0] eq "-h") { print <<FIM;

DIP_AVALIA_RELACOES
Programa que avalia as relaes relativamente ao ficheiro de relaes do DIP

Chamada: $0 <personagens_sistema_convertidas> <fich_convertido> <fich_dourada> [-d]

                                      DMS, 10 de setembro de 2022

FIM
exit;
} else {
    $fich=$ARGV[0];
    shift;
    $fichrel=$ARGV[0];
    shift;
    $reldour=$ARGV[0];
    shift;
    if ($ARGV[0] eq "-d") {
	$debug=1;
	shift;
    }
}
# l o gnero de cada personagem atribudo pelo sistema
open(FICH,$fich) or die "No consegui abrir $fich!";
while (<FICH>) {
    ($id,$personagem,$sexo,$prof)=($_=~m/[0-9]+,([0-9]+),(.*?),([MF ]*),(.*?)\s*$/);
#    print "id: $id; personagem: $personagem; sexo: $sexo; profisso: $prof\n";
    if ($personagem) {
	$sexo{$id}=$sexo;
    }
}
close(FICH);


# l as relaes
open(REL, $fichrel) or die "No consegui abrir $fichrel";


while (<REL>) {
#    print "Relao: $_\n";
    chop;
    $rel{$_}=1;
    ($obra,$prim,$rel,$seg)=($_=~/([0-9]+),([0-9]+),(.*),([0-9]+)/);
    $rel="\L$rel";
    print "Relao proposta pelo sistema: $prim $rel $seg\n" if ($debug);
    if ($rel=~/(me|pai)/) {
	if ($sexo{$seg}=~/M/) {
	    $rel{"$obra,$seg,filho,$prim"}=1;
	} else {
	    $rel{"$obra,$seg,filha,$prim"}=1;
	}
    } elsif ($rel=~/^filh/) {
	if ($sexo{$seg}=~/F/) {
	    $rel{"$obra,$seg,me,$prim"}=1;
	} else {
	    $rel{"$obra,$seg,pai,$prim"}=1;
	}
    } elsif ($rel=~/irm/) {
	if ($sexo{$seg}=~/M/) {
	    $rel{"$obra,$seg,irmo,$prim"}=1;
	} else {
	    $rel{"$obra,$seg,irm,$prim"}=1;
	}
    } elsif ($rel=~/^av/) {
	if ($sexo{$seg}=~/M/) {
	    $rel{"$obra,$seg,neto,$prim"}=1;
	} else {
	    $rel{"$obra,$seg,neta,$prim"}=1;
	}
    } elsif ($rel=~/^net/) {
	if ($sexo{$seg}=~/F/) {
	    $rel{"$obra,$seg,av,$prim"}=1;
	} else {
	    $rel{"$obra,$seg,av,$prim"}=1;
	}
    } elsif ($rel=~/^prim/) {
	if ($sexo{$seg}=~/F/) {
	    $rel{"$obra,$seg,prima,$prim"}=1;
	} else {
	    $rel{"$obra,$seg,primo,$prim"}=1;
	}
    } elsif ($rel=~/mulher/) {
	$rel{"$obra,$seg,marido,$prim"}=1;
    } elsif ($rel=~/marido/) {
	$rel{"$obra,$seg,mulher,$prim"}=1;
    } elsif ($rel=~/sogr/) {
	if ($sexo{$seg}=~/F/) {
	    $rel{"$obra,$seg,nora,$prim"}=1;
	} else {
	    $rel{"$obra,$seg,genro,$prim"}=1;
	}
    } elsif ($rel=~/^ti/) {
	if ($sexo{$seg}=~/M/) {
	    $rel{"$obra,$seg,sobrinho,$prim"}=1;
	} else {
	    $rel{"$obra,$seg,sobrinha,$prim"}=1;
	}
    } elsif ($rel=~/sobrinh/) {
	if ($sexo{$seg}=~/M/) {
	    $rel{"$obra,$seg,tio,$prim"}=1;
	} else {
	    $rel{"$obra,$seg,tia,$prim"}=1;
	}
    } elsif ($rel=~/nora/) {
	if ($sexo{$seg}=~/F/) {
	    $rel{"$obra,$seg,sogra,$prim"}=1;
	} else {
	    $rel{"$obra,$seg,sogro,$prim"}=1;
	}
    } elsif ($rel=~/genro/) {
	if ($sexo{$seg}=~/F/) {
	    $rel{"$obra,$seg,sogra,$prim"}=1;
	} else {
	    $rel{"$obra,$seg,sogro,$prim"}=1;
	}
    } elsif ($rel=~/cunhad/) {
	if ($sexo{$seg}=~/F/) {
	    $rel{"$obra,$seg,cunhada,$prim"}=1;
	} else {
	    $rel{"$obra,$seg,cunhado,$prim"}=1;
	}
    } elsif ($rel=~/adrinh/) {
	if ($sexo{$seg}=~/F/) {
	    $rel{"$obra,$seg,afilhada,$prim"}=1;
	} else {
	    $rel{"$obra,$seg,afilhado,$prim"}=1;
	}
    } elsif ($rel=~/afilhad/) {
	if ($sexo{$seg}=~/F/) {
	    $rel{"$obra,$seg,madrinha,$prim"}=1;
	} else {
	    $rel{"$obra,$seg,padrinho,$prim"}=1;
	}
    }
}
close(REL);
print "Relaes propostas pelo sistema:\n" if ($debug);
@relssist=keys %rel;
foreach $i (sort keys %rel) {
    print $i, "\n" if ($debug);
}


$numsist=$#relssist+1;
print "Nmero de relaes propostas pelo sistema: $numsist\n" if ($debug);

# l as relaes
open(REL, $reldour) or die "No consegui abrir $reldour";


while (<REL>) {
#    print "Relao dourada: $_\n";
    chop;
    $dourada{$_}=1;
    ($obra,$prim,$rel,$seg)=($_=~/([0-9]+),([0-9]+),(.*),([0-9]+)/);
    print "Relao na coleo dourada: $prim $rel $seg\n" if ($debug);
    if ($rel=~/(me|pai)/) {
	if ($sexo{$seg}=~/M/) {
	    $dourada{"$obra,$seg,filho,$prim"}=1;
	} else {
	    $dourada{"$obra,$seg,filha,$prim"}=1;
	}
    } elsif ($rel=~/^filh/) {
	if ($sexo{$seg}=~/F/) {
	    $dourada{"$obra,$seg,me,$prim"}=1;
	} else {
	    $dourada{"$obra,$seg,pai,$prim"}=1;
	}
    } elsif ($rel=~/irm/) {
	if ($sexo{$seg}=~/M/) {
	    $dourada{"$obra,$seg,irmo,$prim"}=1;
	} else {
	    $dourada{"$obra,$seg,irm,$prim"}=1;
	}
    } elsif ($rel=~/^av/) {
	if ($sexo{$seg}=~/M/) {
	    $dourada{"$obra,$seg,neto,$prim"}=1;
	} else {
	    $dourada{"$obra,$seg,neta,$prim"}=1;
	}
    } elsif ($rel=~/^net/) {
	if ($sexo{$seg}=~/F/) {
	    $dourada{"$obra,$seg,av,$prim"}=1;
	} else {
	    $dourada{"$obra,$seg,av,$prim"}=1;
	}
    } elsif ($rel=~/^prim/) {
	if ($sexo{$seg}=~/F/) {
	    $dourada{"$obra,$seg,prima,$prim"}=1;
	} else {
	    $dourada{"$obra,$seg,primo,$prim"}=1;
	}
    } elsif ($rel=~/mulher/) {
	$dourada{"$obra,$seg,marido,$prim"}=1;
    } elsif ($rel=~/marido/) {
	$dourada{"$obra,$seg,mulher,$prim"}=1;
    } elsif ($rel=~/sogr/) {
	if ($sexo{$seg}=~/F/) {
	    $dourada{"$obra,$seg,nora,$prim"}=1;
	} else {
	    $dourada{"$obra,$seg,genro,$prim"}=1;
	}
    } elsif ($rel=~/^ti/) {
	if ($sexo{$seg}=~/M/) {
	    $dourada{"$obra,$seg,sobrinho,$prim"}=1;
	} else {
	    $dourada{"$obra,$seg,sobrinha,$prim"}=1;
	}
    } elsif ($rel=~/sobrinh/) {
	if ($sexo{$seg}=~/M/) {
	    $dourada{"$obra,$seg,tio,$prim"}=1;
	} else {
	    $dourada{"$obra,$seg,tia,$prim"}=1;
	}
    } elsif ($rel=~/nora/) {
	if ($sexo{$seg}=~/F/) {
	    $dourada{"$obra,$seg,sogra,$prim"}=1;
	} else {
	    $dourada{"$obra,$seg,sogro,$prim"}=1;
	}
    } elsif ($rel=~/genro/) {
	if ($sexo{$seg}=~/F/) {
	    $dourada{"$obra,$seg,sogra,$prim"}=1;
	} else {
	    $dourada{"$obra,$seg,sogro,$prim"}=1;
	}
    } elsif ($rel=~/cunhad/) {
	if ($sexo{$seg}=~/F/) {
	    $dourada{"$obra,$seg,cunhada,$prim"}=1;
	} else {
	    $dourada{"$obra,$seg,cunhado,$prim"}=1;
	}
    } elsif ($rel=~/adrinh/) {
	if ($sexo{$seg}=~/F/) {
	    $dourada{"$obra,$seg,afilhada,$prim"}=1;
	} else {
	    $dourada{"$obra,$seg,afilhado,$prim"}=1;
	}
    } elsif ($rel=~/afilhad/) {
	if ($sexo{$seg}=~/F/) {
	    $dourada{"$obra,$seg,madrinha,$prim"}=1;
	} else {
	    $dourada{"$obra,$seg,padrinho,$prim"}=1;
	}
    }
 }
close(REL);
print "Relaes na coleo dourada:\n" if ($debug);
foreach $i (sort keys %dourada) {
    print $i, "\n" if ($debug);
}

@relsdour=keys %dourada;
$numdourada=$#relsdour+1;

open (PARAVERIFICAR, ">>paraverificar.txt") or die "No consegui abrir o ficheiro paraverificar.txt\n";

print "Nmero de relaes propostas pelo sistema: $numsist\n" if ($debug);

$certas=0;
$espurias=0;
$emfalta=0;
foreach $rela (sort keys %rel) {
    print "...$rela\t" if ($debug);
    if (exists($dourada{$rela})) {
	$certas++;
	print "certa\n" if ($debug);
    } else {
	$espurias++;
	print "espria\n" if ($debug);
	print PARAVERIFICAR $rela, "\n";
    }
}

print "Certas: $certas\nEspurias: $espurias\n";

foreach $rela (sort keys %dourada) {
    print "......$rela\t" if ($debug);
    if (exists($rel{$rela})) {
	print "certa\n" if ($debug);
    } else {
	$emfalta++;
	print "em falta\n" if ($debug);
    }
}
print "Em falta: $emfalta\n";
if ($certas > 0) {
$prec=$certas/($certas+$espurias);
$abrang=$certas/($certas+$emfalta);
print "Preciso: $prec; Abrangncia: $abrang\n";
$f1=2*$prec*$abrang/($prec+$abrang);
} else {$f1=0;}
print "Medida de avaliao de relaes: F1: $f1\n";
close(PARAVERIFICAR);
