#!/usr/bin/perl 


$debug=0;
if ($ARGV[0] eq "-h") { print <<FIM;

DIP_AVALIACAO
Programa que calcula as medidas de avaliao para o DIP, por obra, usando 
o resultado e a CD j passadas pelo programa dip_preliminar.pl, que trata das
personagens com nomes repetidos


Chamada: $0  <ficheiro> <dourado>

                                      DMS, 28 de maio de 2022

FIM
exit;
} else {
    $fich=$ARGV[0];
    shift;
    $dourado=$ARGV[0];
    shift;
    if ($ARGV[0] eq "-d") {
	$debug=1;
	shift;
    }
}

# avaliao da identificao
open(FICH,$fich) or die "No consegui abrir $fich!";
while (<FICH>) {
    ($id,$personagem,$sexo,$prof)=($_=~m/[0-9]+,([0-9]+),(.*?),([MF ]*),(.*?)\s*$/);

    if ($personagem) {
	$personagem{$id}=$personagem;
	$sexo{$id}=$sexo;
	$profissao{$id}=$prof;
	@nomes=split /\|/, $personagem;
	foreach $nome (@nomes) {
# coloca os nomes no vetor associativo %nomesimplificado, 
# e com a especificao completa em %nome
	    $nomesemsubl=$nome;
	    $nomesemsubl=~s/_.*//;
	    $nome{$nome}++;
	    $nomesimplificado{$nomesemsubl}++;
	    $ambos{$nome}++;
	    $ambossimplificado{$nomesemsubl}++;
	    $genero{$nome}=$sexo;
#	    $genero{$nomesemsubl}=$sexo;
	    $profissao{$nome}=$prof if ($prof);
	}
    }
}
close(FICH);


print "No ficheiro:\n";
$conta=0;
foreach $n (sort keys %nomesimplificado) {
    print "$n, " if ($debug);
    $conta++;
}
print "\n" if ($debug);
$contacomp=0;
foreach $n (sort keys %nome) {
    print "$n, " if ($debug);
    $contacomp++;
}
print "\n" if ($debug);
print "$conta casos de nomes e $contacomp casos de nomes completos\n";


open(FICH,$dourado) or die "No consegui abrir $dourado!";
while (<FICH>) {
    ($idc,$personagemc,$sexoc,$profc)=($_=~m/[0-9]+,([0-9]+),(.*?),([MF]*),(.*?)\s*$/);
    if ($personagemc) {
	$personagemcerta{$idc}=$personagemc;
	$sexocerto{$idc}=$sexoc;
	$profissaocerta{$idc}=$profc;
	@nomesc=split /\|/, $personagemc;
	foreach $nome (@nomesc) {
	    print "L da CD: $nome\n" if ($debug);
# da mesma forma, usa %nomec e %nomeccompleto para indicar o que est na CD

	    $nomesemsubl=$nome;
	    $nomesemsubl=~s/_.*//;
	    $nomec{$nome}++;
	    $nomecsimplificado{$nomesemsubl}++;
	    $ambos{$nome}++;
	    $ambossimplificado{$nomesemsubl}++;
	    $generoc{$nome}=$sexoc;
#	    $generoc{$nomesemsubl}=$sexoc;
	    $profissaoc{$nomesemsubl}=$profc if ($profc);
	    print "Profisso na CD: $profissaoc{$nomesemsubl}\n" if ($debug);
	}
    }
}
close(FICH);

print "Na coleo dourada:\n";
$conta=0;
foreach $n (sort keys %nomecsimplificado) {
    print "$n, " if ($debug);
    $conta++;
}
print "\n" if ($debug);
$contacomp=0;
foreach $n (sort keys %nomec) {
    print "$n, " if ($debug);
    $contacomp++;
}
print "\n" if ($debug);
print "$conta casos de nomes e $contacomp de nomes completos\n";

$numambossimplificado=(keys %ambossimplificado);
print "$numambossimplificado casos de identificadores nicos\n" if ($debug);

open (PARAVERIFICAR, ">>paraverificar.txt") or die "No consegui abrir o ficheiro paraverificar.txt\n";

# comparao dos casos para a avaliao da identificao
# usa-se o %nomesimplificado e %nomecsimplificado e %ambossimplificado
$certos=0;
$espurios=0;
$faltam=0;
$total=0;
foreach $n (sort keys %ambossimplificado) {
    print "designao $n ($total): " if ($debug);
    if (exists($nomesimplificado{$n}) and exists($nomecsimplificado{$n})) { #and ($nomesimplificado{$n} eq $nomecsimplificado{$n})) {
	print "Existem ambos\n" if ($debug);
	$certos++;
	$total++;
#	$certos+=$nomecsimplificado{$n};
#	$total+=$nomecsimplificado{$n};
#    } elsif (exists($nome{$n}) and exists($nomec{$n})) {
#	print "Existem ambos 2\n" if ($debug);
#	if ($nome{$n} > $nomec{$n}) {
#	    $certos+=$nomec{$n};
#	} else {
#	    $certos+=$nome{$n};
#	}
#	$total+=$nomec{$n};
    } elsif (exists($nomesimplificado{$n})) {
	print "Esprio\n" if ($debug);
	$espurios++;
	print PARAVERIFICAR "Nome de personagem? ", $n,"\n";
    } else {
	$faltam++;
	print "Em falta\n" if ($debug);
#	$total+=$nomecsimplificado{$n};
	$total++;
    }
}
print "Total: $total; certos: $certos; esprios: $espurios; faltam: $faltam\n";
if ($total > 0 and $certos > 0) {
    $preci=$certos/($certos+$espurios);
    $abrangi=$certos/$total;

    $ai=2*$preci*$abrangi/($preci+$abrangi);
} else {$ai=0;}
print "Medida AI: $ai\n";

# avaliao das formas de chamar uma mesma personagem, relaes de identidade
# aqui usa-se o %nomescompleto e %nomesccompleto

# primeiro calcula todas as relaes de identidade da coleo dourada que 
# se refiram a pares de nomes que tenham sido identificados pelo sistema
foreach $p (sort keys %personagemcerta) {
    print "%%Personagem $p...\n" if ($debug);
    if ($personagemcerta{$p}=~/\|/) { # se tem mais de uma maneira de se indicar
	@nomes=split /\|/, $personagemcerta{$p};
	$ultimo=$nomes[$#nomes]; # extraio o ltimo elemento
#	$ultimo=~s/_.*//;
	if ($debug) { print "ltimo: ", $ultimo, "\n";}
	pop(@nomes);
	while (@nomes) { # comparo com os outros membros
	    foreach $nome (@nomes) {
#		$nome=~s/_.*//;
# s vale a pena se ambos os nomes tiverem sido identificados pelo sistema...
		if (exists($nome{$nome}) and exists($nome{$ultimo})) {
		    if (($ultimo cmp $nome) == 1 ) { # comparando strings para ficarem sempre ordenadas
			$omesmocerto{$nome."-".$ultimo}=1;
		    } else {
			$omesmocerto{$ultimo."-".$nome}=1;
		    }
		}
	    }
	    $ultimo=$nomes[$#nomes]; # obtenho um novo termo de comparao
#	    $ultimo=~s/_.*//;
	    pop(@nomes);
	    if ($debug) { print "ltimo: ", $ultimo, "\n";}
	}
    } else { # s tem um nome
#	if ($debug) {print "$personagemcerta{$p} s tem uma designao\n";}
# s vale a pena colocar se o nome existe na sada do sistema

	if (exists($nome{$personagemcerta{$p}})) {
	    $omesmocerto{$personagemcerta{$p}."-ZERO"}=1;
	}
    }
}
# Tendo-os colocado em %omesmocerto, imprime-os e conta-os
print "Considerados os mesmos na coleo dourada: \n" if ($debug);

$conta_dour=0;
foreach $par (sort keys %omesmocerto) {
    print $par,"\n" if ($debug);
    $conta_dour++;
}
print "nmero de relaes de identidade na CD: $conta_dour\n";


# tratar das relaes propostas pelo sistema:

foreach $p (sort keys %personagem) {
    print "Personagem $personagem{$p}\n" if ($debug);
    if ($personagem{$p}=~/\|/) { # se tem mais de uma maneira de se indicar
	@nomes=split /\|/, $personagem{$p};
	$ultimo=$nomes[$#nomes];
	pop(@nomes);
	while (not exists ($nomec{$ultimo}) and @nomes) { #  preciso confirmar que essa forma de chamar a personagem existe, seno no conta para esta medida
	    $ultimo=$nomes[$#nomes];
	    pop(@nomes);
	}
	while (@nomes) {
	    foreach $nome (@nomes) {
		if (exists($nomec{$nome})) {
		    if (($ultimo cmp $nome) == 1) { # comparando strings
			$omesmo{$nome."-".$ultimo}=1;
		    } else {
			$omesmo{$ultimo."-".$nome}=1;
		    }
		}
	    } 
	    $ultimo=$nomes[$#nomes];
	    pop(@nomes);
	    while (not exists ($nomec{$ultimo}) and @nomes) {  
		$ultimo=$nomes[$#nomes];
		pop(@nomes);
	    
	    }
	}
    } else { #tem s um nome
# e esse nome existe na CD
	if (exists($nomec{$personagem{$p}})) {
	    $omesmo{$personagem{$p}."-ZERO"}=1;
	}
    
    }
}
# Tendo-os colocado em %omesmo, imprime-os e conta-os
print "Considerados os mesmos pelo sistema: \n" if ($debug);
$conta=0;
foreach $par (sort keys %omesmo) {
    print $par,"\n" if ($debug);
    $conta++;
}
print "nmero de relaes de identidade propostas pelo sistema: $conta\n";


$numrels=$conta;
$relscertas=0;
$relsespurias=0;

# Avaliao
foreach $rel (sort keys %omesmo) {
	if (exists $omesmocerto{$rel}) {
	print "Relao de identidade certa: ", $rel, "\n" if ($debug);
	$relscertas++;
    } else {
	print "Relao de identidade espria: ", $rel, "\n" if ($debug);
	$relsespurias++;
	print PARAVERIFICAR "Rel. de identidade? $rel\n";
	}
}

print "$relscertas relaes certas e $relsespurias esprias\n";
# medida ACI
print "Relaes de identidade: certas: $relscertas; esprias: $relsespurias; todas: $numrels\n";

if ($numrels and $relscertas) { # se o sistema produziu algumas relaes certas
    $precri=$relscertas/($relscertas+$relsespurias);
    $abranri=$relscertas/$conta_dour;
    $aci=2*$precri*$abranri/($precri+$abranri);
    print "Preciso: $precri; Abrangncia: $abranri; ";
} else { # se no existem nem relaes na CD nem pelo sistema
    $aci=0;
}
print "Medida ACI: $aci\n";

# Avaliao do gnero (AG)
# Associar a cada forma de identificar um gnero certo, a partir do que est na coleo dourada

$generrado=0;
$gencerto=0;
$numpersonagens=0;
foreach $p (sort keys %personagem) {
	@nomes=split /\|/, $personagem{$p};
	foreach $nome (@nomes) {
	    $genero.="$generoc{$nome}";
	    $ultimonome=$nome;
	}
	print "genero de $personagem{$p}: $genero\n" if ($debug);
	if ($genero=~m/F/ and $genero=~/M/) { 
	    print "Genero errado divergente\n" if ($debug);
	    $generrado++;
	} elsif (not $genero) { # no conta nada se no houver gnero na CD
	    $numpersonagens--;
	} elsif ($genero!~/$genero{$ultimonome}/) { #aqui no  divergente
	    print "Genero errado: $genero na CD e $genero{$ultimonome} do sistema para $ultimonome\n" if ($debug);
	    $generrado++;
	} elsif ($genero and not($genero{$ultimonome})) {
	    print "Genero errado: $genero na CD e $ultimonome no tem gnero na CD\n" if ($debug);
	    $generrado++;

	} else {
	    print "Genero certo ($genero{$ultimonome})\n" if ($debug);
	    $gencerto++;

	}
	$genero="";
	$numpersonagens++;
}

if ($numpersonagens) {
    $AG=($gencerto-$generrado)/$numpersonagens;
} else {
    $AG=0;
}
print "Medida AG: $AG em $numpersonagens personagens com gnero: $gencerto certas e $generrado erradas\n";

# Avaliao da profisso/ocupao/estatuto social
# medida APOES
$numcasos=0;
$profscd=0;
foreach $p (sort keys %personagem) {
	@nomes=split /\|/, $personagem{$p};
	foreach $nome (@nomes) {
	    print "Nome da personagem: $nome\n" if ($debug);
	    print "Profisso na CD: $profissaoc{$nome}\n" if ($debug);
	    print "Profisso na resposta: $profissao{$nome}\n" if ($debug);
	    if (exists($profissaoc{$nome}) and exists($profissao{$nome})) {
		@profsc=split /\|/, $profissaoc{$nome};
		foreach $profiss (@profsc) {
		    print "Na CD: $profscd $nome$profiss\n" if ($debug);
		    $todasprof{"$nome$profiss"}++;
		    $profscd++;
		}
		@profs=split /\|/, $profissao{$nome};
		foreach $profiss (@profs) {
		    print "Na resposta do sistema: $nome$profiss\n" if ($debug);
		    $todasprof{"$nome$profiss"}++;
		}
	    } elsif (exists($profissao{$nome}) and exists($nomec{$nome}) ) {
		@profs=split /\|/, $profissao{$nome};
		foreach $profiss (@profs) {
		    print "Na resposta do sistema apenas: $nome$profiss\n" if ($debug);
		    print PARAVERIFICAR "Prof/ocup/estatto social de $nome? $profiss\n"; 
		    $todasprof{"$nome$profiss"}++;
		}
	    } elsif (exists($profissaoc{$nome}) and exists($nome{$nome}) ) {
		@profsc=split /\|/, $profissaoc{$nome};
		foreach $profiss (@profsc) {
		    print "Na CD: $profscd $nome$profiss\n" if ($debug);
		    $todasprof{"$nome$profiss"}++;
		    $profscd++;
		}
	    }
	}
}

$profcertas=0;
$proferradas=0;
foreach $caso (sort keys %todasprof) {
    print "Caso $caso $numcasos\n" if ($debug);
    $numcasos++;
    if ($todasprof{$caso} eq 2) {
	print "$caso com profisso certa: $profcertas\n" if ($debug);
	$profcertas++;
    } else {
	print "$caso com profisso errada $proferradas\n" if ($debug);
	$proferradas++;
    }
}
if ($numcasos and $profscd and $profcertas) {
    $prec=$profcertas/$numcasos;
    $abran=$profcertas/$profscd;
    $APOES=2*$prec*$abran/($prec+$abran);
} else {
    $APOES=0;
}
print "Medida APOES: $APOES, com $profcertas certas e $proferradas erradas em $numcasos\n";
close(PARAVERIFICAR);


