import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;


public class AlgumasSubstituicoes {

	public static void main(String args[]){
		
		if(args.length < 1){
			System.out.println("Falta o nome do ficheiro como argumento!");
			System.exit(0);
		}
		
		try {
			BufferedReader br = new BufferedReader(new FileReader(args[0]));
			
			String linha = null;
			while((linha = br.readLine()) != null){
				
				linha = substituicoes(linha);
				System.out.println(linha);
			}
			
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	private static String substituicoes(String s){
		
		String antes = "CATEG=\"ABSTRACCAO\" TIPO=\"PLANO\"";
		String depois = "CATEG=\"OBRA\" TIPO=\"PLANO\"";
		String str = s.replaceAll(antes, depois);
		
		antes = "CATEG=\"ABSTRACCAO\" TIPO=\"ESCOLA\"";
		depois = "CATEG=\"ABSTRACCAO\" TIPO=\"DISCIPLINA\"";
		str = str.replaceAll(antes, depois);
		
		antes = "CATEG=\"ABSTRACCAO\" TIPO=\"OBRA\"";
		depois = "CATEG=\"ABSTRACCAO\" TIPO=\"DISCIPLINA\"";
		str = str.replaceAll(antes, depois);
		
/*		antes = "CATEG=\"LOCAL\" TIPO=\"CORREIO\"";
		depois = "CATEG=\"LOCAL\" TIPO=\"ADMINISTRATIVO\"";
		str = str.replaceAll(antes, depois);*/
		
		antes = "CATEG=\"LOCAL\" TIPO=\"ALARGADO\"";
		depois = "CATEG=\"LOCAL\" TIPO=\"ADMINISTRATIVO\"";
		str = str.replaceAll(antes, depois);
		
		antes = "CATEG=\"VARIADO\"";
		depois = "CATEG=\"OUTRO\"";
		str = str.replaceAll(antes, depois);
		
		return str;
	}
}
