import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

import javax.swing.JFrame;
import javax.swing.JTree;


public class AtributosEM implements Tags{

	private static AtributosEM instancia;

	private TreeMap<String, TreeMap<String, ArrayList<String>>> categorias;
	private TreeMap<String, ArrayList<String>> tempoRefs;
	private TreeMap<String, ArrayList<String>> tempoSentidos;
	private ArrayList<String> tiposRef;

	private String catActual;
	private String tipoActual;
	private String subActual;

	public static final String CONFIG_FILE = "harem3.conf";
	public static final String COMENTARIO = "#";
	private final String CAT = "C";
	private final String TIPO = "T";
	private final String SUB = "S";
	private final String REF = "R";
	private final String TEMPO_REF = "X";
	private final String SENTIDO = "Y";
	private final String SEP = ":";

	public static AtributosEM getInstance()
	{
		if (instancia == null)
		{					
			instancia = new AtributosEM();
		}

		return instancia;
	}

	private AtributosEM(){

		//categorias = new HashMap<String, String[]>();
		categorias = new TreeMap<String, TreeMap<String, ArrayList<String>>>();
		tiposRef = new ArrayList<String>();
		tempoRefs = new TreeMap<String, ArrayList<String>>();
		tempoSentidos = new TreeMap<String, ArrayList<String>>();

		catActual = null;
		tipoActual = null;
		subActual = null;
	}

	public boolean carrega(){
		return carrega(CONFIG_FILE);
	}

	//TODO: retornar inteiros de acordo com o tipo de ERRO?
	public boolean carrega(String config){

		try {
			BufferedReader br = new BufferedReader(new FileReader(config));

			/*BufferedReader br =
				new BufferedReader(new InputStreamReader(getClass().getResourceAsStream("/"+config)));*/ 

			String linha = null;
			while((linha = br.readLine()) != null){
				if(linha.equals(""))
					break;
				if(linha.startsWith(COMENTARIO))
					continue;

				parse(linha);
			}

		} catch (FileNotFoundException e) {
			System.out.println("Ficheiro de configuracao nao encontrado!");
			return false;
			//System.exit(-1);
		} catch (IOException e) {
			System.out.println("Excepcao na leitura da configuracao!");
			return false;
			//System.exit(-1);
		} catch (FormatoInvalidoException e) {
			System.out.println("O ficheiro com as categorias nao tem o formato correcto!\n"/* +
			"CATEGORIA:TIPO1,TIPO2..."*/);
			return false;
			//System.exit(-1);
		}

		return true;
	}

	private void parse(String linha) throws FormatoInvalidoException{

		String[] lados =  linha.split(SEP);

		if(lados.length < 2)
			throw new FormatoInvalidoException();

		if(lados[0].equals(CAT)){

			TreeMap<String, ArrayList<String>> tipos = new TreeMap<String, ArrayList<String>>();

			//para haver o tipo vazio
			//tipos.put("", null);
			categorias.put(lados[1], tipos);
			catActual = lados[1];

		} else if(linha.startsWith(TIPO)){

			if(catActual == null)
				throw new FormatoInvalidoException();

			TreeMap<String, ArrayList<String>> cat = categorias.get(catActual);
			ArrayList<String> subs = new ArrayList<String>();

			//para haver o subtipo vazio
			//subs.add("");
			cat.put(lados[1].trim(), subs);
			tipoActual = lados[1].trim();

		} else if(linha.startsWith(SUB)) {

			if(tipoActual == null)
				throw new FormatoInvalidoException();

			ArrayList<String> tipo = categorias.get(catActual).get(tipoActual);
			tipo.add(lados[1].trim());
			subActual = lados[1];

		} else if(linha.startsWith(REF)) {
			tiposRef.add(lados[1].trim());

		} else if(linha.startsWith(TEMPO_REF)) {

			String chave = chave(catActual, tipoActual, subActual);

			ArrayList<String> lista = tempoRefs.get(chave);
			if(lista == null) {
				tempoRefs.put(chave, new ArrayList<String>());
				lista = tempoRefs.get(chave);
			}
			lista.add(lados[1].trim());

		} else if(linha.startsWith(SENTIDO)) {

			String chave = chave(catActual, tipoActual, subActual);

			ArrayList<String> lista = tempoSentidos.get(chave);
			if(lista == null) {
				tempoSentidos.put(chave, new ArrayList<String>());
				lista = tempoSentidos.get(chave);
			}
			lista.add(lados[1].trim());

		} else throw new FormatoInvalidoException();
	}

	private String chave(String catActual, String tipoActual, String subActual) throws FormatoInvalidoException{

		if(catActual == null)
			throw new FormatoInvalidoException();

		String chave = catActual;
		chave += (tipoActual != null ? SEP+tipoActual : "");
		chave += (subActual != null ? SEP+subActual : "");

		return chave;
	}

	/*	private void parseOld(String linha) throws FormatoInvalidoException{

		String[] partes = linha.split(":");

		if(partes.length != 2)
			throw new FormatoInvalidoException();

		String[] tipos = partes[1].split(","); 
		//ordenar
		Arrays.sort(tipos);

		if(partes.length < 1)
			throw new FormatoInvalidoException();

		for(String s : tipos){
			TreeMap<String, ArrayList<String>> tipo = new TreeMap<String, ArrayList<String>>();
			tipo.put(s.trim(), null);
			categorias.put(partes[0].trim(), tipo);
		}
	}*/

	public TreeMap<String, TreeMap<String, ArrayList<String>>> getCategorias() {
		return categorias;
	}

	public Object[] getTiposRef(){
		return tiposRef.toArray();
	}

	public Object[] getNomesCategorias(){

		return categorias.keySet().toArray();

		/*ArrayList<String> nomes = new ArrayList<String>();

		Iterator<String> it = categorias.keySet().iterator();
		while(it.hasNext())
			nomes.add(it.next());

		return (String[])nomes.toArray();*/
	}

	public Object[] getTipos(String cat){
		TreeMap<String, ArrayList<String>> tipos = categorias.get(cat);
		return tipos.keySet().toArray();

		/*ArrayList<String> nomes = new ArrayList<String>();

		Iterator<String> it = tipos.keySet().iterator();
		while(it.hasNext())
			nomes.add(it.next());

		return (String[])nomes.toArray();*/
	}

	public Object[] getSubtipos(String cat, String tipo){
		TreeMap<String, ArrayList<String>> tipos = categorias.get(cat);
		ArrayList<String> nomes = tipos.get(tipo);

		return nomes.toArray();
	}

	public Object[] getTempoRefs(String cat, String tipo, String sub){

		String chave = null;
		try {
			chave = chave(cat, tipo, sub);
		} catch (FormatoInvalidoException e) {
			return null;
		}

		ArrayList<String> refs = tempoRefs.get(chave);		
		return (refs == null ? null : refs.toArray());
	}

	public Object[] getTempoSentidos(String cat, String tipo, String sub){

		String chave = null;
		try {
			chave = chave(cat, tipo, sub);
		} catch (FormatoInvalidoException e) {
			return null;
		}

		ArrayList<String> sents = tempoSentidos.get(chave);		
		return (sents == null ? null : sents.toArray());
	}

	public String openTagEM(String tag, String id)
	{
		return openTag(ENTITY_TAG + " " 
				+ Tags.ID_EQ + asQuoted(id) + " "
				+ Tags.CAT_EQ + tag);
	}

	public String openTag(String tag)
	{
		return "<" + tag + ">";
	}

	public String closeTagEM()
	{
		//return "</" + tag + ">";
		return closeTag(ENTITY_TAG);
	}

	public String closeTag(String tag)
	{
		//return "</" + tag + ">";
		return "</" + tag + ">";
	}

	public String asQuoted(String type)
	{
		return "\"" + type + "\"";
	}

	public String deQuote(String type)
	{
		return type.replaceAll("\"", "");
	}

	public String getIdEqTag()
	{
		return ID+EQ;
	}

	public String getTypeEqTag()
	{
		return TYPE+EQ;
	}

	public String getSubtypeEqTag()
	{
		return SUBTYPE+EQ;
	}

	public String getCatEqTag()
	{
		return CAT+EQ;
	}

	public String getAltDiv()
	{
		return " "+PIPE+" ";
	}

	public void categoriasToLatexTable(){

		System.out.print("\\textbf{Categorias}&\\textbf{Tipos}&\\textbf{Subtipos}");
		System.out.println("\n\\tabularnewline\\hline\\hline");
		
		for(String s : categorias.keySet()){
			System.out.print(s);

			TreeMap<String, ArrayList<String>> tipos = categorias.get(s);
			if(tipos.isEmpty()){
				System.out.print("&&");
				System.out.println("\n\\tabularnewline\\hline");
			
			} else {

				for(String t : tipos.keySet()){

					System.out.print("&");
					System.out.print(t);
					System.out.print("&");

					ArrayList<String> subtipos = tipos.get(t);
					if(subtipos.isEmpty()){
						System.out.println("\n\\tabularnewline\\hline");
						
					} else {
						
						System.out.print(subtipos.get(0));
						System.out.println("\n\\tabularnewline\\hline");
						List<String> subtipos2 = subtipos.subList(1, subtipos.size());
						for(String u : subtipos2){
							System.out.print("&&");
							System.out.print(u);
							System.out.println("\n\\tabularnewline\\hline");
						}
					}
				}
			}
		}

	}

	public void showTree(){
		
		//TODO: nao faz nada de jeito :)
		JFrame frame = new JFrame();
		Object[] test2 = {"dois1", "dois2"};
		Object[] test = {"um", test2, "tres", "quatro", "cinco"};
		
		Object[] cats = new Object[categorias.size()];
		
		int i = 0;
		for(TreeMap<String, ArrayList<String>> subtree : categorias.values())
			cats[i++] = subtree;
				
		
		JTree tree = new JTree(cats);
		tree.setVisible(true);
		
		frame.add(tree);
		frame.setVisible(true);
		frame.pack();
	}
	
	//para imprimir a rvore com as categorias, tipos e subtipos
	public static void main(String args[]){

		AtributosEM atributos = new AtributosEM();
		atributos.carrega();
		//System.out.println(atributos.getCategorias());
		//atributos.categoriasToLatexTable();
		//atributos.showTree();
	}
}

class FormatoInvalidoException extends Exception{

	public FormatoInvalidoException(){
		super("Ficheiro de configuracao apresenta um formato invalido!");
	}
}
