import java.awt.Rectangle;

import javax.swing.JLabel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;

public class CaretListenerLabel extends JLabel
	implements CaretListener {

		private int dot = 0;
		private int mark = 0;

		private JTextPane txt;
		
		public CaretListenerLabel(String label, JTextPane pane) {
			super(label);
			txt = pane;
		}

		//Might not be invoked from the event dispatch thread.
		public void caretUpdate(CaretEvent e) {
			dot = e.getDot();
			mark = e.getMark();
			//displaySelectionInfo(e.getDot(), e.getMark());
			displaySelectionInfo(dot, mark);
		}

		public boolean hasSelection(){
			return (dot != mark);
		}

		public int getBegin(){
			return (dot < mark ? dot : mark);
		}

		public int getEnd(){
			return (dot > mark ? dot : mark);
		}

		//This method can be invoked from any thread.  It 
		//invokes the setText and modelToView methods, which 
		//must run on the event dispatch thread. We use
		//invokeLater to schedule the code for execution
		//on the event dispatch thread.
		protected void displaySelectionInfo(final int dot,
				final int mark) {
			SwingUtilities.invokeLater(new Runnable() {
				public void run() {
					if (dot == mark) {  // no selection
						try {
							Rectangle caretCoords = txt.modelToView(dot);
							//Convert it to view coordinates.
							setText("posicao: " + dot
									+ ", local = [" + caretCoords.x + ", "
									+ caretCoords.y + "]");
						} catch (BadLocationException ble) {
							setText("posicao: " + dot);
						}
					} else if (dot < mark) {
						setText("seleccao: " + dot + ", " + mark);
					} else {
						setText("seleccao: " + mark + ", " + dot);
					}
				}
			});
		}
	}
