import java.io.*;
import java.util.*;


public class Categorias implements Tags{

	private static Categorias instancia;

	private TreeMap<String, TreeMap<String, ArrayList<String>>> categorias;
	private ArrayList<String> tiposRef;
	private String config;

	private String catActual;
	private String tipoActual;
	
	public static final String CONFIG_FILE = "harem3.conf";
	public static final String COMENTARIO = "#";
	private final String CAT = "C";
	private final String TIPO = "T";
	private final String SUB = "S";
	private final String REF = "R";
	private final String SEP = ":";

	public static Categorias getInstance()
	{
		if (instancia == null)
		{					
			instancia = new Categorias();
		}

		return instancia;
	}

	private Categorias(){

		config = CONFIG_FILE;
		//categorias = new HashMap<String, String[]>();
		categorias = new TreeMap<String, TreeMap<String, ArrayList<String>>>();
		tiposRef = new ArrayList<String>();
		
		catActual = null;
		tipoActual = null;
	}

	//TODO: retornar inteiros de acordo com o tipo de ERRO
	public boolean carrega(){

		try {
			BufferedReader br = new BufferedReader(new FileReader(config));

			/*BufferedReader br =
				new BufferedReader(new InputStreamReader(getClass().getResourceAsStream("/"+config)));*/ 

			String linha = null;
			while((linha = br.readLine()) != null){
				if(linha.equals(""))
					break;
				if(linha.startsWith(COMENTARIO))
					continue;

				parse(linha);
			}

		} catch (FileNotFoundException e) {
			System.out.println("Ficheiro de configuracao nao encontrado!");
			return false;
			//System.exit(-1);
		} catch (IOException e) {
			System.out.println("Excepcao na leitura da configuracao!");
			return false;
			//System.exit(-1);
		} catch (FormatoInvalidoException e) {
			System.out.println("O ficheiro com as categorias nao tem o formato correcto!\n"/* +
			"CATEGORIA:TIPO1,TIPO2..."*/);
			return false;
			//System.exit(-1);
		}

		return true;
	}

	private void parse(String linha) throws FormatoInvalidoException{

		String[] lados =  linha.split(SEP);

		if(lados.length < 2)
			throw new FormatoInvalidoException();

		if(lados[0].equals(CAT)){

			TreeMap<String, ArrayList<String>> tipos = new TreeMap<String, ArrayList<String>>();
			
			//para haver o tipo vazio
			//tipos.put("", null);
			categorias.put(lados[1], tipos);
			catActual = lados[1];

		} else if(linha.startsWith(TIPO)){

			if(catActual == null)
				throw new FormatoInvalidoException();

			TreeMap<String, ArrayList<String>> cat = categorias.get(catActual);
			ArrayList<String> subs = new ArrayList<String>();
			
			//para haver o subtipo vazio
			//subs.add("");
			cat.put(lados[1].trim(), subs);
			tipoActual = lados[1].trim();

		} else if(linha.startsWith(SUB)) {

			if(tipoActual == null)
				throw new FormatoInvalidoException();

			ArrayList<String> tipo = categorias.get(catActual).get(tipoActual);
			tipo.add(lados[1].trim());
		
		} else if(linha.startsWith(REF)) {
			tiposRef.add(lados[1].trim());

		} else throw new FormatoInvalidoException();
	}

	private void parseOld(String linha) throws FormatoInvalidoException{

		String[] partes = linha.split(":");

		if(partes.length != 2)
			throw new FormatoInvalidoException();

		String[] tipos = partes[1].split(","); 
		//ordenar
		Arrays.sort(tipos);

		if(partes.length < 1)
			throw new FormatoInvalidoException();

		for(String s : tipos){
			TreeMap<String, ArrayList<String>> tipo = new TreeMap<String, ArrayList<String>>();
			tipo.put(s.trim(), null);
			categorias.put(partes[0].trim(), tipo);
		}
	}

	public TreeMap<String, TreeMap<String, ArrayList<String>>> getCategorias() {
		return categorias;
	}

	public Object[] getTiposRef(){
		return tiposRef.toArray();
	}
	
	public Object[] getNomesCategorias(){

		return categorias.keySet().toArray();
		
		/*ArrayList<String> nomes = new ArrayList<String>();

		Iterator<String> it = categorias.keySet().iterator();
		while(it.hasNext())
			nomes.add(it.next());

		return (String[])nomes.toArray();*/
	}

	public Object[] getTipos(String cat){
		TreeMap<String, ArrayList<String>> tipos = categorias.get(cat);
		return tipos.keySet().toArray();
		
		/*ArrayList<String> nomes = new ArrayList<String>();

		Iterator<String> it = tipos.keySet().iterator();
		while(it.hasNext())
			nomes.add(it.next());

		return (String[])nomes.toArray();*/
	}

	public Object[] getSubtipos(String cat, String tipo){
		TreeMap<String, ArrayList<String>> tipos = categorias.get(cat);
		ArrayList<String> nomes = tipos.get(tipo);

		return nomes.toArray();
	}
	
	public String openTagEM(String tag, String id)
	{
		return openTag(ENTITY_TAG + " " 
				+ Tags.ID_EQ + asQuoted(id) + " "
				+ Tags.CAT_EQ + tag);
	}

	public String openTag(String tag)
	{
		return "<" + tag + ">";
	}

	public String closeTagEM()
	{
		//return "</" + tag + ">";
		return closeTag(ENTITY_TAG);
	}

	public String closeTag(String tag)
	{
		//return "</" + tag + ">";
		return "</" + tag + ">";
	}

	public String asQuoted(String type)
	{
		return "\"" + type + "\"";
	}

	public String deQuote(String type)
	{
		return type.replaceAll("\"", "");
	}

	public String getIdEqTag()
	{
		return ID+EQ;
	}

	public String getTypeEqTag()
	{
		return TYPE+EQ;
	}

	public String getSubtypeEqTag()
	{
		return SUBTYPE+EQ;
	}

	public String getCatEqTag()
	{
		return CAT+EQ;
	}

	public String getAltDiv()
	{
		return " "+PIPE+" ";
	}
}

class FormatoInvalidoException extends Exception{

	public FormatoInvalidoException(){
		super("Ficheiro de configuracao apresenta um formato invalido!");
	}
}
