import java.awt.Container;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

import javax.swing.*;
import javax.swing.event.*;

public class EtApplet extends JApplet implements Mediator{

	private File currFile;
	//private int currFontSize;
	
	private Menu menu;
	private Painel painel;

	public EtApplet(){
		super();
				
		//currFontSize = DEFAULT_FONT_SIZE;
		currFile = null;
		
		painel = new Painel(this, DEFAULT_FONT_SIZE);
		menu = new Menu(this);
		
		setContentPane(painel);
		setJMenuBar(menu);
		
		//Display the window.
		//setSize(new Dimension(FRAME_WIDTH, FRAME_HEIGHT));
		
		setVisible(true);
	}
	
	public Container getContainer(){
		return this;
	}
	
	public File getCurrFile(){
		return currFile;
	}
	
	public void setCurrFile(File file){
		currFile = file;
	}
	
	public void resetId(){
		painel.resetIds();
	}
	
	public JTextPane getTxtPane(){
		return painel.getTxtPane();
	}
	
	public void setText(String s){
		painel.setText(s, null);
	}
	
	public JScrollPane getScroller(){
		return painel.getScroller();
	}
	
	public Action[] getActions(){
		return painel.getTxtPane().getActions();
	}
	
	public void setFeedback(String str){
		painel.setFeedback(str);
	}
	
	public void incFontSize(){
		painel.incCurrFontSize();
	}
	
	public void decFontSize(){
		painel.decCurrFontSize();
	}
	
	public void tagEM(){
		painel.tagEM();
	}
	
	public void tagAlt(){
		painel.tagAlt();
	}
	
	public void tagVaga(){
		painel.tagVaga();
	}
	
	public void tagErro(){
		painel.atErro();
	}
	
	public void repeteTag(){
		painel.repeteTag();
	}
	
	public void removeTag(){
		painel.removeTag();
	}

	public void alteraTag(){
		painel.alteraTag();
	}
	
	public void verificaTags(){
		painel.verificaTags();
	}
	
	public void help(){
		info("Ajuda", HELP_STR);
	}

	public void about(){
		info("Acerca", "Ferramenta de apoio a etiquetacao\nde textos para o HAREM");
	}
	
	public void info(String title, String msg){
		JOptionPane.showMessageDialog(getContentPane(),	title, msg,	JOptionPane.INFORMATION_MESSAGE);
	}
	
	public void error(String title, String msg){
		JOptionPane.showMessageDialog(getContentPane(),	title, msg,	JOptionPane.ERROR_MESSAGE);
		painel.setFeedback(title);
	}
	
	public void termina(){
		painel.setFeedback("A applet so' termina fechando o browser!");
	}
	
	public void undoableEdit(UndoableEditEvent e){
		menu.undoableEdit(e);
	}

	public void setCurrFile(File file, ArrayList<String> ids) {
		// TODO Auto-generated method stub
		
	}

	public void setDocs(Object[] docids) {
		// TODO Auto-generated method stub
		
	}

	public int confirm(String title, String msg) {
		// TODO Auto-generated method stub
		return 0;
	}

	public void escondeTags(boolean b) {
		// TODO Auto-generated method stub
		
	}

	public void showCurrDoc() {
		// TODO Auto-generated method stub
		
	}

	public void subtipo() {
		// TODO Auto-generated method stub
		
	}

	public void tipo() {
		// TODO Auto-generated method stub
		
	}

	public void discardEdits() {
		// TODO Auto-generated method stub
		
	}

	public void setText(String s, String docid, ArrayList<String> ids) {
		// TODO Auto-generated method stub
		
	}

	public void tagComment() {
		// TODO Auto-generated method stub
		
	}

	public void novaAlt() {
		// TODO Auto-generated method stub
		
	}

	public void tempo() {
		// TODO Auto-generated method stub
		
	}

	public void tornarVaga() {
		// TODO Auto-generated method stub
		
	}

	public void undo() {
		// TODO Auto-generated method stub
		
	}

	public String getEMIdFromLong(long l) {
		// TODO Auto-generated method stub
		return null;
	}

	public void corel(ArrayList<String> list) {
		// TODO Auto-generated method stub
	}

	public void valDelta() {
		// TODO Auto-generated method stub
		
	}

	public void valNorm(String signo, String ano, String mes, String dia, String hora, String minuto) {
		// TODO Auto-generated method stub
		
	}

	public void omitir() {
		// TODO Auto-generated method stub
		
	}
}
