import java.io.File;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;

import java.util.*;

public class EtFrame extends JFrame implements Mediator{

	private File currFile;
	//private int currFontSize;

	private Menu menu;
	private Painel painel;

	public EtFrame(){
		super(TITULO);

		//currFontSize = DEFAULT_FONT_SIZE;
		currFile = null;

		painel = new Painel(this, DEFAULT_FONT_SIZE);
		menu = new Menu(this);

		setContentPane(painel);
		setJMenuBar(menu);

		//java.awt.Dimension ss=java.awt.Toolkit.getDefaultToolkit().getScreenSize();
		//setExtendedState(Frame.MAXIMIZED_BOTH);
		//setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
		addWindowListener(new Terminar(this, painel.getTxtPane()));

		menu.openAction();

		pack();
		//center();
		setVisible(true);		
	}

	private void center() {
		GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
		Point center = ge.getCenterPoint();
		Rectangle bounds = ge.getMaximumWindowBounds();
		int w = Math.max(bounds.width/2, Math.min(getWidth(), bounds.width));
		int h = Math.max(bounds.height/2, Math.min(getHeight(), bounds.height));
		int x = center.x - w/2, y = center.y - h/2;
		setBounds(x, y, w, h);
		if (w == bounds.width && h == bounds.height)
			setExtendedState(Frame.MAXIMIZED_BOTH);
		validate();
	}

	public Container getContainer(){
		return this;
	}

	public File getCurrFile(){
		return currFile;
	}

/*	public void setCurrFile(File file){
		setCurrFile(file, null);
	}*/

/*	public void setCurrFile(File file, ArrayList<String> ids){
		currFile = file;
		if(ids != null)
			painel.setIds(ids);
	}*/

	public void setCurrFile(File file){
		currFile = file;
	}
	
	/*public void setCurrXMLDoc(Document doc){
		currXMLDoc = doc;
	}*/

	/*public void setDocs(Object[] docids){
		painel.setDocs(docids);
	}*/

	public void resetId(){
		painel.resetIds();
	}

	public JTextPane getTxtPane(){
		return painel.getTxtPane();
	}

	public void setText(String s){
		painel.setText(s, null);
	}

	public void setText(String s, String docid, ArrayList<String> ids){
		painel.setText(s, docid);
		painel.getTxtPane().setEditable(true);
		painel.setIds(ids);
	}

	public JScrollPane getScroller(){
		return painel.getScroller();
	}

	/*public ActionListener getActionListener(){
		return menu.getActionListener();
	}*/

	public Action[] getActions(){
		return painel.getTxtPane().getActions();
	}

	public void setFeedback(String str){
		painel.setFeedback(str);
	}

	public void incFontSize(){
		painel.incCurrFontSize();
	}

	public void decFontSize(){
		painel.decCurrFontSize();
	}
	
	public void tagEM(){
		painel.tagEM();
	}

	public void tagAlt(){
		painel.tagAlt();
	}

	public void tagVaga(){
		painel.tagVaga();
	}

	public void tornarVaga(){
		painel.tornarVaga();
	}
	
	public void novaAlt(){
		painel.novaAlt();
	}
	
	public void tagComment(){
		painel.atComment();
	}
	
	public void omitir(){
		painel.omitir();
	}
	
	public void tagErro(){
		painel.atErro();
	}

	public void repeteTag(){
		painel.repeteTag();
	}

	public void removeTag(){
		painel.removeTag();
	}

	public void alteraTag(){
		painel.alteraTag();
	}

	/*public void corel(ArrayList<String> ids){
		painel.corel(ids);
	}*/
	
	public void corel(ArrayList<String> ids){
		painel.corel(ids);
	}
	
	public String getEMIdFromLong(long l){
		return menu.getIdFromLong(l);
	}
	
	public void escondeTags(boolean b){
		painel.escondeTags(b);
	}
	
	public void showCurrDoc(){
		menu.showCurrDoc();
	}
	
	public void verificaTags(){
		painel.verificaTags();
	}

	public void help(){
		info("Ajuda", HELP_STR);
	}

	public void about(){
		info("Acerca", ABOUT_STR);
	}

	public void info(String title, String msg){
		JOptionPane.showMessageDialog(getContentPane(),	msg, title, JOptionPane.INFORMATION_MESSAGE);
	}

	public void error(String title, String msg){
		JOptionPane.showMessageDialog(getContentPane(),	msg, title, JOptionPane.ERROR_MESSAGE);
		painel.setFeedback(title);
	}

	public void termina(){
		this.dispose();
	}

	public void undo(){
		menu.undo();
	}
	
	public void undoableEdit(UndoableEditEvent e){
		menu.undoableEdit(e);
	}

	public int confirm(String title, String msg){
		return JOptionPane.showConfirmDialog(
				this,
				msg,
				title,
				JOptionPane.YES_NO_OPTION);
	}

	public void subtipo() {
		painel.atSubtipo();
	}

	public void tipo() {
		painel.atTipo();
	}

	public void tempo(){
		painel.tempo();
	}
	
	public void discardEdits() {
		menu.getUndoManager().discardAllEdits();	
	}

	public void valDelta() {
		painel.valDelta();
	}

	public void valNorm(String signo, String ano, String mes, String dia,
			String hora, String minuto) {
		
		painel.valNorm(signo, ano, mes, dia, hora, minuto);
	}
}

class Terminar extends WindowAdapter{

	private EtFrame frame;
	private JTextPane txt;

	public Terminar(EtFrame f, JTextPane text){
		frame = f;
		txt = text;
	}

	public void windowClosing(WindowEvent winEvt) {

		if(!txt.getText().equals("")){
			if(confirm() == JOptionPane.YES_OPTION){
				terminar();
			}
		} else terminar();
	}

	private void terminar(){
		frame.dispose();
		System.exit(0);
	}

	private int confirm(){

		return frame.confirm("Terminar",
				"Tem a certeza que pretende terminar a aplicacao?\n" +
				"As alteracoes nao guardadas serao perdidas!");

	}
}