import java.io.File;
import java.util.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

public interface Mediator {

	public final String TITULO = "Etiquet(H)AREM";
	public final String VERSAO = "3.3";
	public final int DEFAULT_FONT_SIZE = 14;
	public final int MARGIN = 5;

	public final String HELP_STR =
		"Para etiquetar uma EM, selecciona-la com o rato\n" +
		"e utilizar o menu Etiqueta ou as teclas de atalho:\n" +
		"- CTRL+E para inserir etiqueta de EM;\n" +
		"- CTRL+Q para inserir alternativa;\n" +
		"- CTRL+G para etiqueta de EM vaga;\n" +
		"- CTRL+R para repetir a ultima etiqueta;\n" +
		"- CTRL+D para remover a etiqueta seleccionada;\n" +
		"- CTRL+K para alterar a etiqueta seleccionada;\n" +
		"\nPara inserir atributos individuais de cada EM anotada, selecciona-la\n" +
		"com o rato e utilizar o menu Outros ou as teclas de atalho:\n" +
		"- CTRL+O para uma relacao entre EMs;\n" +
		"- CTRL+B para atributos temporais;\n" +
		"- CTRL+I para o tipo;\n" +
		"- CTRL+U para o subtipo;\n" +
		"\nOutras opcoes encontram-se no menu Outros ou as teclas de atalho:\n" +
		"- CTRL+F para localizar um fragmento de texto;\n" +
		"- CTRL+T para esconder ou mostrar as etiquetas;\n" +
		"- CTRL++/CTRL+- para aumentar/diminuir o tamanho da letra;\n" +
		"- CTRL+W para validar o XML.";

	public String ABOUT_STR =
		"Ferramenta de apoio a etiquetacao\n" +
		"de textos para o HAREM\n" +
		"--\n" +
		"v."+VERSAO;
	
	public Container getContainer();

	public File getCurrFile();

	public void setCurrFile(File file);
	//public void setCurrFile(File file, ArrayList<String> ids);

	//public void setDocs(Object[] docids);

	public void resetId();

	public JTextPane getTxtPane();

	public void setText(String s);
	public void setText(String s, String docid, ArrayList<String> ids);

	public JScrollPane getScroller();

	public void repaint();

	public Action[] getActions();
	//public ActionListener getActionListener();

	public void setFeedback(String str);

	public void incFontSize();

	public void decFontSize();

	public void tagEM();

	public void omitir();
	
	public void tagAlt();

	public void tagVaga();

	public void tornarVaga();
	
	public void novaAlt();
	
	public void tagComment();
	
	public void tagErro();

	public void repeteTag();

	public void alteraTag();

	public void removeTag();

	public void tipo();

	public void subtipo();
	
	public void tempo();
	
	public void valNorm(String signo, String ano, String mes, String dia,
			String hora, String minuto);
	
	public void valDelta();

	//public void corel(ArrayList<String> ids);
	public void corel(ArrayList<String> ids);

	public String getEMIdFromLong(long l);
	
	public void escondeTags(boolean b);

	public void showCurrDoc();

	public void discardEdits();

	public void verificaTags();

	public void help();

	public void about();

	public void info(String title, String msg);

	public void error(String title, String msg);

	public int confirm(String title, String msg);

	public void termina();

	public void undo();
	
	public void undoableEdit(UndoableEditEvent e);
}
