import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;

import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.DefaultEditorKit;
import javax.swing.undo.UndoManager;

import org.jdom.Content;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.filter.ElementFilter;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class Menu extends JMenuBar implements ActionListener{

	private final String CHARSET = "ISO-8859-1";
	
	private Mediator mediator;

	private JFileChooser fc;
	private JMenu font, tags, atributos;
	private JMenuItem clean, open, save, saveas, close, tag, alt, vaga,
	maisvaga, novaalt, tempo, coment, omitir, erro, corel, tipo, subtipo,
	repetir, alterar, remover, find, bigger, smaller,
	ver, stags, ctags, about, help, vals;

	private JComboBox docList;

	protected UndoAction undoAction;
	protected RedoAction redoAction;
	protected UndoManager undo;
	protected HashMap<Object, Action> actions;

	private SAXBuilder builder, validator;
	private XMLOutputter out;

	private Document currXMLDoc;
	private String currDocId;
	private TreeMap<String, Element> docs; 

	public Menu(Mediator med){

		super();
		//setLayout(new GridLayout());

		mediator = med;
		undo = new UndoManager();
		createActionTable();
		createMenu();

		currXMLDoc = null;
		builder = new SAXBuilder(false);
		validator = new SAXBuilder(true);

		Format format = Format.getRawFormat().setEncoding(CHARSET);
		out = new XMLOutputter(format);
	}

	private void createMenu(){
		fc = new JFileChooser(".");
		fc.addChoosableFileFilter(new FileNameExtensionFilter("Ficheiros XML", "xml", "XML"));
		//fc.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);

		add(createFileMenu());
		add(createEditMenu());
		add(createInsertMenu());
		add(createAttrsMenu());
		add(createChangeMenu());
		add(createHelpMenu());

		add(new JLabel("| "));
		add(new JLabel("Documentos: "));
		docList = new JComboBox();
		add(docList);
		docList.addActionListener(this);
	}

	private JMenu createFileMenu(){

		JMenu menu = new JMenu("Ficheiro");
		menu.setMnemonic(KeyEvent.VK_F);
		/*menu.getAccessibleContext().setAccessibleDescription(
		"The only menu in this program that has menu items");*/

		/*clean = new JMenuItem("Novo");
		clean.setMnemonic(KeyEvent.VK_N);
		clean.addActionListener(this);
		menu.add(clean);*/

		open = new JMenuItem("Abrir...");
		open.setMnemonic(KeyEvent.VK_A);
		open.addActionListener(this);
		menu.add(open);

		save = new JMenuItem("Guardar...");
		save.setMnemonic(KeyEvent.VK_G);
		save.setAccelerator(KeyStroke.getKeyStroke(
				KeyEvent.VK_S, ActionEvent.CTRL_MASK));
		save.addActionListener(this);
		menu.add(save);

		saveas = new JMenuItem("Guardar como...");
		saveas.setMnemonic(KeyEvent.VK_C);
		saveas.addActionListener(this);
		menu.add(saveas);

		menu.add(new JSeparator());		
		close = new JMenuItem("Terminar");
		close.setAccelerator(KeyStroke.getKeyStroke(
				KeyEvent.VK_F4, ActionEvent.ALT_MASK));
		close.addActionListener(this);
		menu.add(close);

		return menu;
	}

	protected JMenu createEditMenu() {
		JMenu menu = new JMenu("Editar");

		undoAction = new UndoAction(undo, mediator);
		JMenuItem undoItem = new JMenuItem(undoAction);
		//CTRL+Z
		undoItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_Z,
				ActionEvent.CTRL_MASK));
		menu.add(undoItem);

		redoAction = new RedoAction(undo, mediator);
		JMenuItem redoItem = new JMenuItem(redoAction);
		//CTRL+Y
		redoItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_Y,
				ActionEvent.CTRL_MASK));
		menu.add(redoItem);

		undoAction.setRedoAction(redoAction);
		redoAction.setUndoAction(undoAction);

		menu.addSeparator();

		//These actions come from the default editor kit.
		//Get the ones we want and stick them in the menu.
		menu.add(getActionByName(DefaultEditorKit.cutAction));
		menu.add(getActionByName(DefaultEditorKit.copyAction));
		menu.add(getActionByName(DefaultEditorKit.pasteAction));

		menu.addSeparator();

		menu.add(getActionByName(DefaultEditorKit.selectAllAction));
		
		return menu;
	}

	private JMenu createInsertMenu(){
		tags = new JMenu("Etiqueta");

		tag = new JMenuItem("EM");
		tag.addActionListener(this);
		tag.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_E,
				ActionEvent.CTRL_MASK));
		//tag.setEnabled(false);
		tags.add(tag);

		vaga = new JMenuItem("EM Vaga");
		vaga.addActionListener(this);
		vaga.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_G,
				ActionEvent.CTRL_MASK));
		//tag.setEnabled(false);
		tags.add(vaga);

		alt = new JMenuItem("Alternativas");
		alt.addActionListener(this);
		alt.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_Q,
				ActionEvent.CTRL_MASK));
		//tag.setEnabled(false);
		tags.add(alt);
		
		tags.addSeparator();

		repetir = new JMenuItem("Repetir");
		repetir.addActionListener(this);
		repetir.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_R,
				ActionEvent.CTRL_MASK));
		tags.add(repetir);

		remover = new JMenuItem("Remover");
		remover.addActionListener(this);
		remover.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_D,
				ActionEvent.CTRL_MASK));
		tags.add(remover);

		alterar = new JMenuItem("Alterar");
		alterar.addActionListener(this);
		alterar.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_K,
				ActionEvent.CTRL_MASK));
		tags.add(alterar);

		tags.addSeparator();
		
		maisvaga = new JMenuItem("Aumentar vagueza");
		maisvaga.addActionListener(this);
		tags.add(maisvaga);
		
		novaalt = new JMenuItem("Nova alternativa");
		novaalt.addActionListener(this);
		tags.add(novaalt);
			
		omitir = new JMenuItem("Omitir");
		omitir.addActionListener(this);
		tags.add(omitir);
		
		return tags;
	}

	private JMenu createAttrsMenu(){

		atributos = new JMenu("Atributos");

		corel = new JMenuItem("Correlacao");
		corel.addActionListener(this);
		corel.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_O,
				ActionEvent.CTRL_MASK));
		corel.setEnabled(true);
		atributos.add(corel);

		tipo = new JMenuItem("Tipo");
		tipo.addActionListener(this);
		tipo.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_I,
				ActionEvent.CTRL_MASK));
		tipo.setEnabled(true);
		atributos.add(tipo);

		subtipo = new JMenuItem("Subtipo");
		subtipo.addActionListener(this);
		subtipo.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_U,
				ActionEvent.CTRL_MASK));
		subtipo.setEnabled(true);
		atributos.add(subtipo);

		tempo = new JMenuItem("Tempo");
		tempo.addActionListener(this);
		tempo.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_B,
				ActionEvent.CTRL_MASK));
		tempo.setEnabled(true);
		atributos.add(tempo);
		
		vals = new JMenuItem("VAL_NORM");
		vals.addActionListener(this);
		vals.setEnabled(true);
		atributos.add(vals);
		
		atributos.addSeparator();
		
		coment = new JMenuItem("Comentario");
		coment.addActionListener(this);
		/*coment.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_P,
				ActionEvent.CTRL_MASK));*/
		coment.setEnabled(true);
		atributos.add(coment);
		
		erro = new JMenuItem("Meta erro");
		erro.addActionListener(this);
		/*erro.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_P,
				ActionEvent.CTRL_MASK));*/
		atributos.add(erro);

		return atributos;
	}

	private JMenu createChangeMenu(){
		JMenu menu = new JMenu("Outros");
		
		find = new JMenuItem("Localizar...");
		find.addActionListener(this);
		find.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F,
				ActionEvent.CTRL_MASK));
		find.setEnabled(true);
		menu.add(find);
		
		menu.addSeparator();
		
		stags = new JMenuItem("Esconde etiquetas");
		stags.addActionListener(this);
		stags.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_T,
				ActionEvent.CTRL_MASK));
		stags.setEnabled(true);
		menu.add(stags);

		ctags = new JMenuItem("Mostra etiquetas");
		ctags.addActionListener(this);
		ctags.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_T,
				ActionEvent.CTRL_MASK));
		ctags.setEnabled(false);
		menu.add(ctags);

		menu.addSeparator();

		ver = new JMenuItem("Validar XML");
		ver.addActionListener(this);
		ver.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_W,
				ActionEvent.CTRL_MASK));
		ver.setEnabled(true);
		menu.add(ver);

		menu.addSeparator();

		font = new JMenu("Tamanho da letra");
		menu.add(font);

		bigger = new JMenuItem("Maior");
		bigger.addActionListener(this);
		bigger.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_PLUS,
				ActionEvent.CTRL_MASK));
		font.add(bigger);
		smaller = new JMenuItem("Menor");
		smaller.addActionListener(this);
		smaller.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_MINUS,
				ActionEvent.CTRL_MASK));
		font.add(smaller);

		return menu;
	}

	private JMenu createHelpMenu(){

		JMenu menu = new JMenu("Ajuda");

		help = new JMenuItem("Como etiquetar?");
		help.addActionListener(this);
		menu.add(help);

		menu.addSeparator();

		about = new JMenuItem("Acerca");
		about.addActionListener(this);
		menu.add(about);

		return menu;
	}

	//The following two methods allow us to find an
	//action provided by the editor kit by its name.
	protected void createActionTable() {
		actions = new HashMap<Object, Action>();
		//Action[] actionsArray = mediator.getTxtPane().getActions();
		Action[] actionsArray = mediator.getActions();
		for (int i = 0; i < actionsArray.length; i++) {
			Action a = actionsArray[i];
			actions.put(a.getValue(Action.NAME), a);
		}
	}

	private Action getActionByName(String name) {
		return actions.get(name);
	}

	public void actionPerformed(ActionEvent e) {

		if (e.getSource() == open) {
			openAction();
			//mediator.getTxtPane().setCaretPosition(mediator.getTxtPane().getDocument().getLength());
			//tag.setEnabled(true);

		} else if (e.getSource() == saveas) {
			saveAsAction();

		} else if (e.getSource() == save) {
			saveAction();

		} else if (e.getSource() == clean) {
			cleanAction();

		} else if (e.getSource() == close) {
			closeAction();

		} else if (e.getSource() == ver) {
			//mediator.verificaTags();
			validaXML();

		} else if (e.getSource() == stags) {
			tagsOn(false);

		} else if (e.getSource() == ctags) {
			tagsOn(true);

		} else if (e.getSource() == bigger) {
			mediator.incFontSize();

		} else if (e.getSource() == smaller) {
			mediator.decFontSize();

		} else if (e.getSource() == find) {
			FindDialog dialog = new FindDialog((Searchable)mediator.getTxtPane());
			dialog.setVisible(true);
			
		} else if (e.getSource() == vals) {			
			ValNormDialog dialog = new ValNormDialog(mediator);
			dialog.setVisible(true);
			
		} else if (e.getSource() == tag) {
			mediator.tagEM();

		} else if (e.getSource() == alt) {
			mediator.tagAlt();

		} else if (e.getSource() == vaga) {
			mediator.tagVaga();

		} else if (e.getSource() == maisvaga) {
			mediator.tornarVaga();
		
		} else if (e.getSource() == novaalt) {
			mediator.novaAlt();
			
		} else if (e.getSource() == coment) {
			mediator.tagComment();

		} else if (e.getSource() == omitir) {
			mediator.omitir();
			
		} else if (e.getSource() == erro) {
			mediator.tagErro();

		} else if (e.getSource() == repetir) {
			mediator.repeteTag();

		} else if (e.getSource() == alterar) {
			mediator.alteraTag();

		} else if (e.getSource() == remover) {
			mediator.removeTag();			

			/*		} else if (e.getSource() == ref) {
			ref(false);	*/		

		} else if (e.getSource() == tipo) {
			mediator.tipo();

		} else if (e.getSource() == subtipo) {
			mediator.subtipo();

		} else if (e.getSource() == tempo) {
			mediator.tempo();
			
		} else if (e.getSource() == corel) {
			mediator.corel(getIds());

		} else if (e.getSource() == help) {
			mediator.help();

		} else if (e.getSource() == about) {
			mediator.about();

		} else if (e.getSource() == docList) {

			//System.out.println("actionPerformed! "+e);
			setDocFromText();
			currDocId = (String)docList.getSelectedItem();
			showCurrDoc();

		} else {

			/*String s = "Action event detected."
				+ newline
				+ "    Event source: " + source.getText()
				+ " (an instance of " + getClassName(source) + ")";
			actions.setText(s);
			log.setCaretPosition(log.getDocument().getLength());*/
		}
	}

	private void tagsOn(boolean b){

		if(!b)
			setDocFromText();

		mediator.escondeTags(!b);

		stags.setEnabled(b);
		ctags.setEnabled(!b);
		save.setEnabled(b);
		saveas.setEnabled(b);
		tags.setEnabled(b);
		atributos.setEnabled(b);
		ver.setEnabled(b);
	}

	public void openAction(){

		if(guardar() == JOptionPane.YES_OPTION)
			saveAction();

		int returnVal = fc.showOpenDialog(this);

		if (returnVal == JFileChooser.APPROVE_OPTION) {
			openFile(fc.getSelectedFile());

		} else {
			mediator.setFeedback("Comando abrir cancelado pelo utilizador.");
		}	
	}

	private int guardar(){
		if(currDocId != null)
			return mediator.confirm("Guardar", "Pretende guardar o ficheiro aberto?");
		return -1;
	}

	private void saveAsAction(){
		int returnVal = fc.showSaveDialog(this);
		if (returnVal == JFileChooser.APPROVE_OPTION) {
			saveAsFile(fc.getSelectedFile());
		} else {
			mediator.setFeedback("Comando guardar cancelado pelo utilizador.");
		}
	}

	private void saveAction(){

		if(mediator.getCurrFile() != null	){
			saveAsFile(mediator.getCurrFile());
		} else {
			int returnVal = fc.showSaveDialog(this);
			if (returnVal == JFileChooser.APPROVE_OPTION) {
				saveAsFile(fc.getSelectedFile());
			} else {
				mediator.setFeedback("Comando guardar cancelado pelo utilizador.");
			}
		}
	}

	private void closeAction(){
		/*int returnVal = JOptionPane.showConfirmDialog(
				mediator.getContainer(), "Terminar a aplicacao?", "Terminar", JOptionPane.YES_NO_OPTION);*/

		int returnVal = mediator.confirm("Terminar", "Terminar a aplicacao?");

		if(returnVal == JOptionPane.YES_OPTION) {
			mediator.termina();
		}
	}

	private void cleanAction(){

		int returnVal = JOptionPane.showConfirmDialog(
				mediator.getContainer(),
				"Limpar todo conteudo e perder alteracoes nao guardadas?",
				"Novo", JOptionPane.YES_NO_OPTION);

		if(returnVal == JOptionPane.YES_OPTION) {
			mediator.setText("");
			mediator.setFeedback("Novo documento.");
			mediator.setCurrFile(null);
		}
	}

	private void openFile(File file){

		String fn = file.getName().toLowerCase();
		if(!fn.endsWith(".xml")){
			mediator.error("Erro", "So e' possivel abrir ficheiros XML!");
			return;
		}

		try {

			SAXBuilder builder = new SAXBuilder(false);
			currXMLDoc = builder.build(file);

			docs = new TreeMap<String, Element>();
			docList.removeAllItems();
			Iterator it = currXMLDoc.getDescendants(new ElementFilter(Tags.DOC_TAG));
			while(it.hasNext()){
				Element el = (Element)it.next();				
				String docid = el.getAttributeValue(Tags.DOC_ID_TAG);

				if(docid == null || docid.length() == 0)
					mediator.error("Erro de sintaxe", "Ha' DOCs sem o atributo DOCID!");

				docs.put(docid, el);
				docList.addItem(docid);
			}

			/*			if((currDocId = selectDOC(docs)) != null){
				showCurrDoc();
			} else return;*/

			mediator.setCurrFile(file);
			mediator.setFeedback("Aberto "+ mediator.getCurrFile().getName());

		} catch (JDOMException e) {
			System.out.println(e);
			erroXML(e);
			//System.exit(0);
			//mediator.error("Erro", "Nao se trata de um ficheiro XML valido!");

			//openNonXMLFile(file);
			//return false;
		} catch (IOException e) {
			System.out.println(e);
			System.exit(0);
		}

		//return true;
	}

	public void showCurrDoc(){

		//System.out.println("showCurrDoc "+currDocId);

		if(currDocId == null || !docs.containsKey(currDocId))
			return;

		try{
			ByteArrayOutputStream os = new ByteArrayOutputStream();
			out.output(docs.get(currDocId), os);
			//out.outputElementContent(docs.get(currDocId), os);

			/*byte[] b = os.toByteArray();
			for(int i = 0; i < b.length; i++){
				char c = (char)b[i];
				if(c == '\n')
					System.out.println("LINHA");
				else if(c == '\r')
					System.out.println("CR");
				else
					System.out.print(c+" ");
			}*/
			
			String output = os.toString(CHARSET);
			mediator.setText(output.replaceAll("\r", ""), currDocId, getCurrDocIds());
			//mediator.getTxtPane().setCaretPosition(0);
		} catch (IOException e){
			System.err.println("IOException!");
		}
	}

	/*private void openNonXMLFile(File file){

		currXMLDoc = null;

		int size = (int) file.length();
		int chars_read = 0;
		char c;

		FileReader fr;
		try {

			fr = new FileReader(file);
			char[] data = new char[size];		

			while (fr.ready()) {

				c = (char)fr.read();
				if (c == '\r')
					continue;

				data[chars_read] = c;
				chars_read++;

				// Increment the count for each character read,
				// and accumulate them in the data buffer.
				//chars_read += fr.read(data, chars_read, size - chars_read);
			}

			fr.close();

			String s = new String(data, 0, chars_read);
			mediator.setText(s);
			//mediator.getTxtPane().setCaretPosition(0);
			//mediator.getScroller().getVerticalScrollBar().setValue(0);
			//mediator.getTxtPane().moveCaretPosition(0);
			//mediator.getTxtPane().grabFocus();

			mediator.setCurrFile(file);
			mediator.setFeedback("Aberto "+ mediator.getCurrFile().getName());


		} catch (FileNotFoundException e1) {
			System.err.print("Ficheiro nao encontrado! "+file);
			//e1.printStackTrace();
		} catch (IOException e1) {
			System.err.print("Excepcao a ler o ficheiro! "+file);
		}
	}*/

	private String selectDOC(TreeMap<String, Element> docs){

		//final String sep = "=";

		/*Object[] possibilities = new Object[docs.size()];
		Iterator<String> it = docs.keySet().iterator();
		for(int i = 0; i < docs.size() && it.hasNext(); i++){
			possibilities[i] = it.next();
		}

		String ret = (String)JOptionPane.showInputDialog((Component)mediator,
				"Escolha o documento pelo seu DOCID:",
				"Seleccao de documento", JOptionPane.PLAIN_MESSAGE, null, possibilities, "");

		return (ret != null ? ret : null);*/

		return docs.firstKey();
	}

	private boolean saveFile(File file) {
		// Handle the case where we don't have a file name yet.
		if (mediator.getCurrFile() == null) {
			return saveAsFile(file);
		}

		try {

			PrintWriter writer = new PrintWriter (new BufferedWriter (new FileWriter (file)));

			//se nao fosse um ficheiro XML
			if(currXMLDoc == null){
				writer.print (mediator.getTxtPane().getText());
				writer.flush ();
				writer.close ();

			} else {

				setDocFromText();
				out.output(currXMLDoc, writer);
				//out.output(currXMLDoc.getDocType(), System.out);
				//out.outputElementContent(docs.get(currDocId), writer);
			}

			mediator.setFeedback("Guardado "+ mediator.getCurrFile().getName());
			saveas.setEnabled(true);
			return true;

		} catch (IOException e) {
			System.out.println(e);
		}

		return false;
	}

//	Save current file, asking user for new destination name.
//	Report to statusBar.
	private boolean saveAsFile(File file) {

		//actions.setText("Saving "+ mediator.getCurrFile()Name+"...");
		mediator.setCurrFile(file);
		//mediator.getCurrFile()Name = file.getAbsolutePath();
		//repaints menu after item is selected
		mediator.getTxtPane().repaint();
		return saveFile(file);
	}

	/*private void ref(boolean corref){
		mediator.ref(corref, getIds());
	}*/

	/**
	 * Recolhe todos os ids do DOC actual
	 * @return
	 */
	private ArrayList<String> getIds(){

		//ArrayList<String> ids = new ArrayList<String>();
		ArrayList<String> ids = new ArrayList<String>();
		//para contemplar entidades acabadas de etiquetar
		setDocFromText();

		Element doc = docs.get(currDocId);
		Iterator it = doc.getDescendants(new ElementFilter(Tags.ENTITY_TAG));
		while(it.hasNext()){
			Element el = (Element)it.next();

			String id = el.getAttributeValue(Tags.ID);
			String texto = el.getText();
			ids.add(id+Tags.OUTRO_SEP+texto);
			//System.out.println(id+" - "+texto);
		}
		return ids;
	}

	private void setDocFromText(){
		setDocFromText(builder);
	}

	private void setDocFromText(SAXBuilder b){

		if(currDocId == null || !docs.containsKey(currDocId))
			return;

		//docs.get(currDocId).setText(mediator.getTxtPane().getText());
		//System.out.println(currXMLDoc.getDocType());		

		//colar no inicio e no fim as tags do <DOC>
		//String[] tags = xmlOpenClose(docs.get(currDocId));
		//String text = tags[0]+mediator.getTxtPane().getText()+tags[1];

		//remover os '\r', que estao a chatear :)
		//String text = mediator.getTxtPane().getText().replaceAll("\r", "");

		try{

			//System.out.println(mediator.getTxtPane().getText());

			StringReader sr = new StringReader (mediator.getTxtPane().getText());
			//StringReader sr = new StringReader(text);
			Document novo = b.build((Reader)sr);
			//docs.remove(currDocId);
			//docs.put(currDocId, novo.getRootElement());

			Content el = novo.detachRootElement();

			//children  uma lista de <DOC>
			java.util.List children = currXMLDoc.getRootElement().getChildren();
			int index = children.indexOf(docs.get(currDocId));
			children.set(index, el);

			docs.put(currDocId, (Element)children.get(index));

			//children  uma lista de <DOC>
			//java.util.List children = currXMLDoc.getRootElement().getChildren();
			//int index = children.indexOf(docs.get(currDocId));

			//System.out.println("index="+index+"; currid="+currDocId+"; children="+children);
			//System.out.println("el="+el);

			/*for(Object e : children){
				if(e instanceof Element)
					System.out.print(((Element)e).hashCode()+" ");
				else System.out.println(e);
			}

			System.out.println();
			Iterator it = docs.keySet().iterator();
			while(it.hasNext())
				System.out.print(docs.get(it.next()).hashCode()+" ");*/

			//substituir o filho e actualizar o mapa de documentos
			//children.set(index, el);
			//docs.put(currDocId, (Element)children.get(index));

			//docs.put(currDocId, el.getParentElement());
			//System.out.println("docs="+docs+"; index="+index);

		} catch (JDOMException e) {
			erroXML(e);

		} catch (IOException e) {
			System.out.println(e);
		}
	}

	/**
	 * Obtem os IDs do Documento HAREM aberto
	 * @return
	 */
	private ArrayList<String> getCurrDocIds(){

		ArrayList<String> ret = new ArrayList<String>();
		Element doc = docs.get(currDocId);
		Iterator<Element> it = doc.getDescendants(new ElementFilter(Tags.ENTITY_TAG));

		while(it.hasNext()){
			Element tmp = it.next();

			String id = null;
			if((id = tmp.getAttributeValue(Tags.ID)) != null){
				//id = id.replaceAll(currDocId+Tags.ID_SEP, "");
				ret.add(id);
			}
			else			
				System.out.println(tmp.getText()+" nao tem atributo ID!");	
		}

		//System.out.println(ret);
		return ret;
	}

	public String getIdFromLong(long l){
		return currDocId+Tags.ID_SEP+l;
	}
	
	/*private String[] xmlOpenClose(Element xml){

		String[] ret = new String[2];

		java.util.List<Attribute> atribs = xml.getAttributes(); 
		ret[0] = "<" + xml.getQualifiedName();

		for(Attribute a : atribs)
			ret[0] += " "+a.getQualifiedName()+"=\""+a.getValue()+"\"";

		ret[0] += ">";
		ret[1] = "</" + xml.getQualifiedName() +">";

		return ret;
	}*/

	private void validaXML(){

		//builder.setValidation(true);

		//TODO: Arranjar melhor forma de validar o isto...

		//1 - tornar o texto mostrado como o Elemento DOC actual
		setDocFromText();

		//2 - transformar o DOC actual em Document 
		Element act = docs.get(currDocId);
		Element clone = (Element)act.clone();
		Document d = new Document(clone);

		//3 - atribuir-lhe a mesma DTD, mas com raz em DOC
		DocType dt = null;
		if(currXMLDoc.getDocType() != null){
			dt = (DocType)currXMLDoc.getDocType().clone();
			dt.setElementName("DOC");
		}
		if(dt != null)
			d.setDocType(dt);

		try{
			//4 - escrever o Document resultante numa String
			ByteArrayOutputStream os = new ByteArrayOutputStream(); 
			out.output(d, os);
			//System.out.println(os.toString());

			//5 - construir um Document a partir da String
			StringReader sr = new StringReader(os.toString());
			validator.build((Reader)sr);
			//System.out.println(d.getDocType());
			//mediator.setText(os.toString(), currDocId);
		} catch (JDOMException e){
			erroXML(e);
		} catch (IOException e){
			System.err.println();
		}

		mediator.info("Validacao", "Validacao concluida!");
		//builder.setValidation(false);
	}

	private void erroXML(JDOMException e){
		String[] partes = e.toString().split(": ");
		String erro = "Erro XML:\n";

		for(int i = 1; i < partes.length; i++)
			erro += partes[i] +"\n";
		//mediator.error("Erro", "Erro no XML:\n"+partes[1]+": "+partes[2]);
		mediator.error("Erro", erro);
		System.out.println(e);
	}

	public void undo(){
		undo.undo();
	}
	
	public void undoableEdit(UndoableEditEvent e){
		undo.addEdit(e.getEdit());
		undoAction.updateUndoState();
		redoAction.updateRedoState();
	}

	public UndoManager getUndoManager(){
		return undo;
	}
}
