import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

import javax.swing.event.*;
import javax.swing.text.*;

import java.util.*;

public class Painel extends JPanel implements MouseListener{

	private static final int MARGIN = 5;

	private static final String DEFAULT_DOCID = "0000";
	private final char ASPAS = '\"';
	private final char EQ = '=';
	private final char[] INVALIDOS = {ASPAS, '<', '>', '&'};
	
	private final Color DEFAULT_TAG_COLOR = Color.blue;
	private final Color DEFAULT_DOC_COLOR = Color.magenta;
	private final Color DEFAULT_ALT_COLOR = Color.red;
	private final Color DEFAULT_INNER_COLOR = Color.black;
	private final Color DEFAULT_TEXT_COLOR = Color.black;
	private final Color DEFAULT_OMITTED_TAG_COLOR = Color.darkGray;
	private final Color DEFAULT_OMITTED_TEXT_COLOR = Color.lightGray;
	private final Color DEFAULT_P_COLOR = Color.magenta;

	//private final int REF_ERROR = -1111;

	private Mediator mediator;
	private AtributosEM atributos;

	//private JTextPane txtPane;
	private Texto painelTexto;
	//private AbstractDocument doc;

	private JPanel status;
	private JLabel feedback;
	private CaretListenerLabel caret;

	private JScrollPane scrollPane;

	private int currFontSize;
	private boolean sTags;
	private String[] ultimaTag;

	private long currId;
	private ArrayList<String> ids;
	private String docId;

	public Painel(Mediator med, int fontSize){
		super();

		mediator = med;
		currFontSize = fontSize;
		sTags = false;

		atributos = AtributosEM.getInstance();

		if(!atributos.carrega()){
			mediator.error("harem.conf",
					"Problemas com o ficheiro harem.conf:\n" +
			"Confira se o ficheiro existe e se est correctamente construido.");
			System.exit(0);
		}

		setLayout(new BorderLayout());
		setOpaque(true);

		createPainel();
		resetIds();
	}

	private void createPainel(){

		//Create a scrolled text area.
		//txtPane = new JTextPane();
		painelTexto = new Texto(mediator);
		//txtPane.setContentType("text/html");
		painelTexto.setCaretPosition(0);
		painelTexto.setMargin(new Insets(MARGIN,MARGIN,MARGIN,MARGIN));
		//txtPane.setEditable(true);
		painelTexto.setFont(new Font("A", Font.PLAIN, currFontSize));
		painelTexto.setEditable(false);

		/*StyledDocument styledDoc = painelTexto.getStyledDocument();
		if (styledDoc instanceof AbstractDocument) {
			doc = (AbstractDocument)styledDoc;
			//txtPane.setDocumentFilter(new DocumentSizeFilter(MAX_CHARACTERS));
		} else {
			System.err.println("Text pane's document isn't an AbstractDocument!");
			System.exit(-1);
		}*/

		scrollPane = new JScrollPane(painelTexto);

		feedback = new JLabel("Etiquet(H)AREM");
		caret = new CaretListenerLabel("...", painelTexto);
		painelTexto.addCaretListener(caret);
		painelTexto.addMouseListener((MouseListener) this);

		status = new JPanel(new GridLayout(1,2));
		status.add(feedback);
		status.add(caret);

		add(scrollPane, BorderLayout.CENTER);
		add(status, BorderLayout.SOUTH);	
	}

	public int getCurrFontSize(){
		return currFontSize;
	}

	public void incCurrFontSize(){
		painelTexto.setFont(new Font("B", Font.PLAIN, ++currFontSize));
	}

	public void decCurrFontSize(){
		painelTexto.setFont(new Font("S", Font.PLAIN, --currFontSize));
	}

	public void setText(String s, String id){

		//txtPane.setText(s);
		setColoredText(s);
		//para nao ser possivel fazer undo as strings inseridas
		mediator.discardEdits();
		painelTexto.setCaretPosition(0);

		docId = (id != null ? id : DEFAULT_DOCID);
	}

	private String getNextId(){

		String novoId = null;
		do{
			//currId++;
			novoId = mediator.getEMIdFromLong(++currId);
		} while(ids.contains(novoId));

		ids.add(novoId);
		//return docId+Tags.ID_SEP+currId;
		return novoId;
	}

	public void setFeedback(String str) {
		feedback.setText(str);
	}

	public void resetIds(){
		currId = 0;
		docId = DEFAULT_DOCID;
		ids = new ArrayList<String>();
	}

	public void setIds(ArrayList<String> l){
		ids = l;
	}

	public JTextPane getTxtPane() {
		return painelTexto;
	}

	public JScrollPane getScroller(){
		return scrollPane;
	}

	public boolean tagEM(){

		if(seleccionadaEM() || seleccionadaALT()){
			mediator.error("Erro", "Seleccionou uma EM!");
			return false;
		}
		
		String[] t = selectTag();
		if(!estaCompleta(t))
			return false;

		String[] be = tagBeginEnd(t);
		if(insertTagEM(be[0], be[1]))
			ultimaTag = t; //para se voltar a construir ter um novo ID

		return true;
	}

	private String[] tagBeginEnd(String[] t){

		//String text = txtPane.getSelectedText();
		String tag = /*categorias.getCatEqTag()+*/atributos.asQuoted(t[0]);
		if(!t[1].equals(""))
			tag += " "+atributos.getTypeEqTag()+atributos.asQuoted(t[1]);
		if(!t[2].equals(""))
			tag += " "+atributos.getSubtypeEqTag()+atributos.asQuoted(t[2]);

		String tag_begin = atributos.openTagEM(tag, getNextId());
		String tag_end = atributos.closeTagEM();

		String[] ret = {tag_begin, tag_end};
		return ret;
	}

	private boolean insertTagEM(String tbegin, String tend){

		if(!seleccao())
			return false;

		int begin = caret.getBegin(); 
		int end = caret.getEnd();

		painelTexto.insereString(begin, tbegin, getTagAttributes(DEFAULT_TAG_COLOR));
		painelTexto.insereString(end+tbegin.length(), tend, getTagAttributes(DEFAULT_TAG_COLOR));

		return true;
	}

	private boolean seleccao(){
		if(!caret.hasSelection()){
			feedback.setText("Nada seleccionado");
			mediator.error("Erro", "Nada seleccionado");

			return false;
		}	
		return true;
	}

	private SimpleAttributeSet getTagAttributes(Color color){
		return getTagAttributes(color, false, false);
	}

	private SimpleAttributeSet getTagAttributes(Color color, boolean bold, boolean italic){
		SimpleAttributeSet tag_attribs = new SimpleAttributeSet();
		StyleConstants.setForeground(tag_attribs, color);
		StyleConstants.setBold(tag_attribs, bold);
		StyleConstants.setItalic(tag_attribs, italic);
		return tag_attribs;
	}

	private String[] selectTag(){
		return selectTag(0);
	}

	private String[] selectTag(int n){

		if(!seleccao())
			return null;

		String[] ret = new String[3];
		inicializa(ret);		

		String cat_ent = "Categoria da Entidade";
		cat_ent += (n < 1) ? ":" : " "+n+":"; 

		//categorias
		ret[0] = selectCat(cat_ent);

		//tipos
		if(ret[0] != null && !ret[0].equals("")){
			ret[1] = selectTipo(ret[0]);
		} else return null;

		//subtipos
		if(ret[1] != null && !ret[1].equals("")){
			ret[2] = selectSubtipo(ret[0], ret[1]);

			if(ret[2] == null)
				ret[2] = "";

		} else if(ret[1].equals("")) {
			ret[2] = "";

		} else return null;

		//System.out.println(ret[0]+" "+ret[1]+" "+ret[2]);
		return ret;
	}

	private String selectCat(String cat_ent){
		Object[] cats = atributos.getNomesCategorias();
		if(cats.length > 0){
			return (String)JOptionPane.showInputDialog(
					this,
					cat_ent,
					"Categoria",
					JOptionPane.PLAIN_MESSAGE,
					null,
					cats,
			"");

		} else if(cats.length == 1){
			mediator.info("Categoria", (String)cats[0]);
			return (String) cats[0];

		} else {
			mediator.error("Erro", "Nao ha categorias a atribuir!");
			return null;
		}
	}

	private String selectTipo(String cat){
		Object[] types = atributos.getTipos(cat);
		if(types == null || types.length < 1)
			return null;

		String ret = (String)JOptionPane.showInputDialog(
				this,
				"Tipo:",
				"Tipo",
				JOptionPane.PLAIN_MESSAGE,
				null,
				types,
		"");

		return (ret == null ? "" : ret);
	}

	private String selectSubtipo(String cat, String tipo){
		Object[] subs = atributos.getSubtipos(cat, tipo);
		if(subs == null || subs.length < 1){
			//mediator.info("Subtipos", "Nao existem subtipos definido para o tipo da EM.");
			return null;
		}

		String ret = (String)JOptionPane.showInputDialog(
				this,
				"Subtipo:",
				"Subtipo",
				JOptionPane.PLAIN_MESSAGE,
				null,
				subs,
		"");

		return (ret == null ? "" : ret);
	}

	/**
	 * Verifica se as tags estao completas
	 * @param t
	 * @return
	 */
	private boolean estaCompleta(String[] t){

		//System.out.println(t[0]+" "+t[1]+" "+t[2]);
		if(t == null || t[0] == "" || t[0] == null || t[1] == null || t[2] == null){
			feedback.setText("Sem propriedades");
			return false;
		}

		return true;
	}

	public void tagAlt(){
		if(!seleccao())
			return;

		Object[] possibilities = {2, 3, 4, 5, 6};
		Integer alts = (Integer)JOptionPane.showInputDialog(
				this,
				"Numero de alternativas:",
				"Etiqueta ALT",
				JOptionPane.PLAIN_MESSAGE,
				null,
				possibilities,
				2);

		if(alts == null)
			return;

		String texto = painelTexto.getSelectedText();
		if(alts > 1){
			String replace = atributos.openTag(Tags.ALT_TAG);

			for(int i = alts; i > 1; i--)
				replace += texto + " "+Tags.PIPE+" ";

			replace += texto;
			replace += atributos.closeTag(Tags.ALT_TAG);
			painelTexto.replaceSelection(replace);
		}
	}

	/*	public void tagAlt(){

		//System.out.println(tag[0] + " " + tag[1]);

		//TODO: suportar mais do que duas alternativas! - complicado...

		if(!seleccao())
			return;

		String[] t = selectTag(true);

		if(!estaCompleta(t))
			return;

		int begin = caret.getBegin();
		int end = caret.getEnd();

		String selected = txtPane.getSelectedText();
		if(selected.indexOf(categorias.openTag(Tags.ALT_TAG)) < 0
				|| selected.indexOf(categorias.closeTag(Tags.ALT_TAG)) < 0)

		String alt_begin = atributos.openTag(Tags.ALT_TAG);
		String alt_sep = atributos.getAltDiv();
		String alt_end = atributos.closeTag(Tags.ALT_TAG);

		String tag = atributos.asQuoted(t[0]) + " " + atributos.getTypeEqTag()+atributos.asQuoted(t[1]);
		String tag_begin = atributos.openTagEM(tag, getNextId());
		String tag_end = atributos.closeTagEM();
		String text = semTags(painelTexto.getSelectedText());

		//txtPane.replaceSelection(tag_inicio + text + tag_fim);
		//int pos = txtPane.getCaretPosition();

		int pos = begin;
		painelTexto.insereString(pos, alt_begin, getTagAttributes(DEFAULT_ALT_COLOR));

		pos = end+alt_begin.length();
		painelTexto.insereString(pos, alt_sep, getTagAttributes(DEFAULT_ALT_COLOR));
		pos += alt_sep.length();
		painelTexto.insereString(pos, tag_begin, getTagAttributes(DEFAULT_TAG_COLOR));
		pos += tag_begin.length();
		painelTexto.insereString(pos, text, null);
		pos += text.length();
		painelTexto.insereString(pos, tag_end, getTagAttributes(DEFAULT_TAG_COLOR));
		pos += tag_end.length();
		painelTexto.insereString(pos, alt_end, getTagAttributes(DEFAULT_ALT_COLOR));

	}*/

	public void tagVaga(){

		if(!seleccao())
			return;

		int n = dialogNumCategoriasVagueza();

		if(n < 2)
			return;

		//inicializar
		String[] t = new String[3];
		inicializa(t);
		/*for(int i = 0; i < t.length; i++)
			t[i] = "";*/

		//preencher
		for(int i = 0; i < n; i++){
			//dialogSeparadorCategoriaVaga(i+1);
			String[] t1 = selectTag(i+1);

			if(!estaCompleta(t1))
				return;

			for(int j = 0; j < t1.length; j++)
				t[j] += t1[j];

			if(i != n-1){
				for(int j = 0; j < t.length; j++)
					t[j] += Tags.PIPE;
			}
		}

		if(!estaCompleta(t))
			return;

		ultimaTag = t;
		String[] be = tagBeginEnd(t);
		insertTagEM(be[0], be[1]);
	}

	private int dialogNumCategoriasVagueza(){

		Object[] possibilities = {2, 3, 4, 5, 6};
		Object ret = JOptionPane.showInputDialog(
				this,
				"Numero de categorias ",
				"Etiqueta de vagueza",
				JOptionPane.PLAIN_MESSAGE,
				null,
				possibilities,
				2);

		return (ret != null ? (Integer)ret : -1);
	}

	public void repeteTag(){
		if(ultimaTag != null){

			String[] be = tagBeginEnd(ultimaTag);
			insertTagEM(be[0], be[1]);

		} else
			mediator.error("Erro", "Nao existe tag para repetir!");
	}

	public void removeTag(){

		int start = painelTexto.getSelectionStart();
		String texto = painelTexto.getSelectedText();
		String sTags = semTags(texto);
		painelTexto.replaceSelection(sTags);
		painelTexto.select(start, start+sTags.length());
	}

	public void alteraTag(){

		if(!seleccionadaEM()){
			mediator.error("Erro", "Seleccao incorrecta!\nSeleccione uma EM e etiqueta");
			return;
		}

		removeTag();
		//quando se faz aqui cancel, ele apaga, por isso dois undos...
		if(!tagEM()){
			mediator.undo();
			mediator.undo();
		}
	}

	public void omitir(){
		
		String tag_open = atributos.openTag(Tags.OMITTED_TAG);
		String tag_close = atributos.closeTag(Tags.OMITTED_TAG);
		insertTagEM(tag_open, tag_close);
	}
	
	/**
	 * Se a seleccao  uma EM
	 * @return
	 */
	private boolean seleccionadaEM(){
		String selected = painelTexto.getSelectedText();

		if(selected == null || selected.equals(""))
			return false;

		return selected.startsWith("<"+Tags.ENTITY_TAG)
		&& selected.endsWith("</"+Tags.ENTITY_TAG+">");
	}

	public void atTipo(){

		if(getEndOfAttributeIndex(Tags.TYPE) > 0){
			mediator.error("Erro", "A EM ja' contem tipo!");
		} else {
			int index = getEndOfTagIndex();
			if(index < 0)
				return;

			String cat = getAttributeValue(Tags.CAT);
			if(cat == null){
				mediator.error("Erro", "A EM nao tem categoria!");
				return;
			}

			String tipo = selectTipo(cat);
			if(tipo == "")
				return;

			String insert = " "+Tags.TYPE_EQ+atributos.asQuoted(tipo);
			painelTexto.insereString(index, insert, getTagAttributes(DEFAULT_TAG_COLOR));
		}
	}

	public void atSubtipo(){

		if(getEndOfAttributeIndex(Tags.SUBTYPE) > 0){
			mediator.error("Erro", "A EM ja' contem subtipo!");
		} else {
			int index = getEndOfTagIndex();
			if(index < 0)
				return;

			String cat = getAttributeValue(Tags.CAT);
			if(cat == null){
				mediator.error("Erro", "A EM nao tem categoria!");
				return;
			}

			String tipo = getAttributeValue(Tags.TYPE);
			if(tipo == null){
				mediator.error("Erro", "A EM nao tem tipo!");
				return;
			}

			if(tipo == "")
				return;

			String subtipo = selectSubtipo(cat, tipo);
			if(subtipo == null || subtipo == "")
				return;

			String insert = " "+Tags.SUBTYPE_EQ+atributos.asQuoted(subtipo);
			painelTexto.insereString(index, insert, getTagAttributes(DEFAULT_TAG_COLOR));
		}
	}

	public void tempo(){

		if(!seleccionadaEM()){
			mediator.error("Erro", "Seleccao incorrecta!\nSeleccione uma EM e etiqueta");
			return;
		}

		if(getAttributeValue(Tags.TEMPO_REF) != null
				|| getAttributeValue(Tags.SENTIDO) != null){
			mediator.error("Erro", "Os atributos temporais ja' estao definidos para a EM!");
			return;
		}

		//TEMPO_REF
		Object[] refs = atributos.getTempoRefs(
				getAttributeValue(Tags.CAT),
				getAttributeValue(Tags.TYPE),
				getAttributeValue(Tags.SUBTYPE));

		String ref = null;
		String sentido = null;
		if(refs != null){
			ref = (String)JOptionPane.showInputDialog(
					this,
					"Tempo",
					"Referencia temporal",
					JOptionPane.PLAIN_MESSAGE,
					null,
					refs,
			"");
		} else {
			mediator.error("Tempo", "A EM nao tem valores definidos para "+Tags.TEMPO_REF+"!");
		}

		//SENTIDO
		Object[] sentidos = atributos.getTempoSentidos(
				getAttributeValue(Tags.CAT),
				getAttributeValue(Tags.TYPE),
				getAttributeValue(Tags.SUBTYPE));

		if(refs != null){
			sentido = (String)JOptionPane.showInputDialog(
					this,
					"Sentido",
					"Sentido temporal",
					JOptionPane.PLAIN_MESSAGE,
					null,
					sentidos,
			"");
		} else {
			mediator.error("Tempo", "A EM nao tem valores definidos para "+Tags.SENTIDO+"!");
		}

		String ats_tempo = "";
		if(ref != null && !ref.equals(""))
			ats_tempo += " " + Tags.TEMPO_REF_EQ + atributos.asQuoted(ref);
		if(sentido != null && !sentido.equals(""))
			ats_tempo += " " + Tags.SENTIDO_EQ + atributos.asQuoted(sentido);

		int index = getEndOfTagIndex();
		if(!ats_tempo.equals(""))
			painelTexto.insereString(index, ats_tempo, getTagAttributes(DEFAULT_TAG_COLOR));
	}

	public void valNorm(String signo, String ano, String mes, String dia,
			String hora, String minuto){
		
		String vn = " "+Tags.VAL_NORM_EQ;
		vn += atributos.asQuoted(signo + ano + mes + dia + "T" + hora + minuto);
		painelTexto.insereString(caret.getBegin(), vn, getTagAttributes(DEFAULT_TAG_COLOR));
	}

	public void valDelta(){
		
	}
	
	public void tornarVaga(){

		if(!seleccionadaEM()){
			mediator.error("Erro", "Seleccao incorrecta!\nSeleccione uma EM e etiqueta");
			return;
		}

		String[] tag = selectTag();

		if(!estaCompleta(tag))
			return;

		int index = getEndOfAttributeIndex(Tags.CAT);		
		painelTexto.insereString(index, Tags.PIPE+tag[0], getTagAttributes(DEFAULT_TAG_COLOR));

		insereAtributosVagos(Tags.TYPE, tag[1]);
		insereAtributosVagos(Tags.SUBTYPE, tag[2]);
		/*if(tag[1] != null && tag[1] != ""){
			index = getEndOfAttributeIndex(Tags.TYPE);

			if(index > caret.getBegin())
				painelTexto.insereString(index, Tags.PIPE+tag[1], getTagAttributes(DEFAULT_TAG_COLOR));
		}

		if(tag[2] != null && tag[2] != ""){
			index = getEndOfAttributeIndex(Tags.SUBTYPE);

			if(index > caret.getBegin())
				painelTexto.insereString(index, Tags.PIPE+tag[2], getTagAttributes(DEFAULT_TAG_COLOR));
		}*/
	}

	public void novaAlt(){

		if(!seleccionadaALT()){
			mediator.error("Erro", "Nao foi seleccionado um bloco ALT completo!");
			return;
		}

		String seleccionada = painelTexto.getSelectedText();
		String texto = semTags(seleccionada);
		String[] alts = texto.split(Tags.PIPE_REGEX);

		int index = seleccionada.lastIndexOf(atributos.closeTag(Tags.ALT_TAG));
		index += caret.getBegin();

		String aInserir = Tags.PIPE+" "+alts[0].trim();
		painelTexto.insereString(index, aInserir, getTagAttributes(DEFAULT_TEXT_COLOR));
	}

	private boolean seleccionadaALT(){
		String selected = painelTexto.getSelectedText();

		if(selected == null || selected.equals(""))
			return false;

		return selected.startsWith("<"+Tags.ALT_TAG)
		&& selected.endsWith("</"+Tags.ALT_TAG+">");
	}

	private void insereAtributosVagos(String tag, String valor){

		int index = getEndOfAttributeIndex(tag);
		if(valor != null && valor != ""){

			if(index > caret.getBegin())
				painelTexto.insereString(index, Tags.PIPE+valor, getTagAttributes(DEFAULT_TAG_COLOR));
			else {
				String aInserir = " "+tag + "=" + atributos.asQuoted(Tags.PIPE+valor);
				index = getEndOfTagIndex();
				painelTexto.insereString(index, aInserir, getTagAttributes(DEFAULT_TAG_COLOR));
			}

		} else if(index > caret.getBegin()) {		
			painelTexto.insereString(index, Tags.PIPE, getTagAttributes(DEFAULT_TAG_COLOR));
		}
	}

	private String getAttributeValue(String at){

		if(!seleccao())
			return null;

		String selected = painelTexto.getSelectedText();
		selected = selected.replaceAll(">", " ");
		String[] ats = selected.split(" ");
		for(String s : ats){
			String[] atv = s.split(""+EQ);
			if(atv.length > 1){			
				if(atv[0].equals(at))
					return atributos.deQuote(atv[1]);
			}
		}
		return null;
	}

	public void atComment(){

		/*int index;
		boolean jaTem = false;

		if(getAttributeValue(Tags.COMMENT) != null){
			index = getEndOfAttributeIndex(Tags.COMMENT);
			jaTem = true;
			
		} else {

			index = getEndOfTagIndex();
			if(index < 0)
				return;
		}*/
		
		String str = JOptionPane.showInputDialog(this,
				"Insira o comentario", "Comentario", JOptionPane.PLAIN_MESSAGE);

		if(str != null && !equals("")){

			str = str.replaceAll(ASPAS+"", "'");
			str = removeCaracteresInvalidos(str);			
			
			String tag = " "+Tags.COMMENT_EQ + atributos.asQuoted(str);
			/*if(!jaTem)
				tag += Tags.COMMENT_EQ + atributos.asQuoted(str);
			else tag += str;*/
			
			painelTexto.insereString(caret.getBegin(), tag, getTagAttributes(DEFAULT_TAG_COLOR));
		}
	}

	public void atErro(){

		/*int index = getEndOfTagIndex();
		if(index < 0)
			return;*/
		
		painelTexto.insereString(caret.getBegin(), Tags.ERROR_TAG, getTagAttributes(DEFAULT_TAG_COLOR));
	}

	public void corel(ArrayList<String> list){

		Integer[] indexes = new Integer[2];
		indexes[0] = -1; //index do atributo COREF
		indexes[1] = -1; //index do atributo TIPOREF

		boolean nTemCoref = true;
		indexes[0] = getEndOfAttributeIndex(Tags.COREF);
		if(indexes[0] < 0){

			if((indexes[0] = getEndOfTagIndex()) < 0)
				return;

		} else nTemCoref = false;

		String ref = selectIdRef(list);
		if(ref == null)
			return;

		String id = ref.split(Tags.OUTRO_SEP)[0];		
		String tiporef = selectTipoRef();
		indexes[1] = getEndOfAttributeIndex(Tags.TIPO_REF);
		String[] values = refAttrib(id, tiporef, nTemCoref, indexes[1] < 0);

		if(indexes[1] < 0)
			indexes[1] = getEndOfTagIndex()/* + values[0].length()*/;

		//somar/subtrair  posicao de TIPOREF o tamanho da REF/COREF
		int sentido = (indexes[0] <= indexes[1] ? 1 : 0);
		//System.out.println(sentido);
		indexes[1] += (sentido * values[0].length());

		insertRef(indexes, values);
	}

	private void insertRef(Integer[] indexes, String[] values){	
		painelTexto.insereString(indexes[0], values[0], getTagAttributes(DEFAULT_TAG_COLOR));
		painelTexto.insereString(indexes[1], values[1], getTagAttributes(DEFAULT_TAG_COLOR));
	}

	private String selectIdRef(ArrayList<String> list){
		Object[] possibilities = list.toArray();
		return (String)JOptionPane.showInputDialog(this, "Escolha a EM", "Correlacao",
				JOptionPane.PLAIN_MESSAGE, null, possibilities, "");
	}

	private String selectTipoRef(){
		Object[] possibilities = atributos.getTiposRef();
		return (String)JOptionPane.showInputDialog(this, "Escolha o tipo:", "Tipo de relacao",
				JOptionPane.PLAIN_MESSAGE, null, possibilities, "");
	}

	private String[] refAttrib(String id, String tiporef, 
			boolean nTemCoref, boolean nTemTipoRef){

		String[] tag = new String[2];

		tag[0] = " ";
		tag[0] += (nTemCoref ? Tags.COREF_EQ+atributos.asQuoted(id) : id);

		if(tiporef != null && nTemTipoRef)
			tag[1] = " "+Tags.TIPO_REF_EQ+atributos.asQuoted(tiporef);
		else if(tiporef != null)
			tag[1] = " "+tiporef;
		else
			tag[1] = "";

		return tag;
	}

	private int getEndOfTagIndex(){

		if(!seleccao())
			return -1;

		String selected = painelTexto.getSelectedText();
		int index = selected.indexOf(">");

		if(index < 1){
			mediator.error("Erro", "Seleccao incorrecta!");
			return - 1;
		}

		if(!selected.contains("<"+Tags.ENTITY_TAG)){
			mediator.error("Erro", "Nao seleccionou uma EM!");
			return -1;
		}

		index += caret.getBegin();
		return index;
	}

	private int getEndOfAttributeIndex(String at){
		if(!seleccao())
			return -1;

		String selected = painelTexto.getSelectedText();
		int index = selected.indexOf(at);
		if(index < 0)
			return -1;

		index += at.length();
		if(selected.charAt(index++) == EQ && selected.charAt(index++) == ASPAS)
			for( ; index < selected.length() && selected.charAt(index) != ASPAS ; index++);
		else {
			mediator.error("Erro", "Atributo "+at+" mal marcado!");
			return -1;
		}

		index += caret.getBegin();
		return index;
	}

	public void escondeTags(boolean b){

		if(b){
			String st = semTags(painelTexto.getText());
			//txtPane.setText("");

			limpaTexto();
			painelTexto.insereString(0, st, getTagAttributes(DEFAULT_TEXT_COLOR));			
			//txtPane.setText(semTags(txtPane.getText()));
			painelTexto.setCaretPosition(0);
		} else {
			mediator.showCurrDoc();
		}
		painelTexto.setEditable(!b);
		sTags = b;
	}

	private String semTags(String s){
		return s.replaceAll("\\<.*?\\>", "");
	}

	public void verificaTags(){
		Parser p = new Parser(painelTexto.getText());
		if(!p.verifica()){

			int cn = p.getIndex() - numCR(p.getIndex());

			painelTexto.setCaretPosition(cn);

			mediator.error("Verificacao de etiquetas",
					"Existem etiquetas por fechar, ou etiquetas de fecho que no foram abertas!\n" +
					"Posicao "+cn);

			return;
		}

		if(p.verificaAlts())
			mediator.info("Verificao de etiquetas",
			"Nao existem etiquetas por fechar, nem de fecho sem terem sido abertas.");
		else
			mediator.error("Verificao de etiquetas",
			"Existem etiquetas <ALT> a mais ou a menos");
	}

	private String removeCaracteresInvalidos(String str){
		
		String ret = str;
		for(char c : INVALIDOS)
			ret = ret.replaceAll(c+"", "");
		
		return ret;
	}
	
	private int numCR(int ate){
		String sub = painelTexto.getText().substring(0, ate);
		return sub.replaceAll("[^\r]","").length();
	}

	private void inicializa(String[] array){
		for(int i = 0; i < array.length; i++)
			array[i] = "";
	}

	private ArrayList<String> getSeparatedText(String text){
		//String s = txtPane.getText();

		ArrayList<String> fragmentos = new ArrayList<String>();
		String tmp = new String();
		for(int i = 0; i < text.length(); i++){

			if(text.charAt(i) == '<'){

				if(tmp.length() > 0)
					fragmentos.add(tmp);

				tmp = new String();
				tmp += '<';

			} else if(text.charAt(i) == '>'){

				tmp += '>';
				fragmentos.add(tmp);
				tmp = new String();

			} else {
				tmp += text.charAt(i);
			}
		}

		//System.out.println(fragmentos);
		return fragmentos;
	}

	private void setColoredText(String texto){
		ArrayList<String> fragmentos = getSeparatedText(texto);		
		limpaTexto();

		//System.out.println("Ola\n"+fragmentos);
		boolean inside = false;
		boolean omitted = false;
		for(int i = 0, index = 0; i < fragmentos.size(); i++){

			String str = fragmentos.get(i);
			SimpleAttributeSet ats = null;
			if(str.startsWith("<"+Tags.DOC_TAG)
					|| str.startsWith("</"+Tags.DOC_TAG)){
				ats = getTagAttributes(DEFAULT_DOC_COLOR, true, true);
				inside = false;

			} else if(str.startsWith("<"+Tags.ALT_TAG)
					|| str.startsWith("</"+Tags.ALT_TAG)){
				ats = getTagAttributes(DEFAULT_ALT_COLOR);
				inside = false;

			} else if(str.startsWith("</"+Tags.ENTITY_TAG)){
				ats = getTagAttributes(DEFAULT_TAG_COLOR, false, false);
				inside = false;

			} else if(str.startsWith("<"+Tags.ENTITY_TAG)){
				ats = getTagAttributes(DEFAULT_TAG_COLOR, false, false);
				inside = true;
			
			} else if(str.startsWith("<"+Tags.OMITTED_TAG)){
				ats = getTagAttributes(DEFAULT_OMITTED_TAG_COLOR, false, false);
				omitted = true;
			
			} else if(str.startsWith("</"+Tags.OMITTED_TAG)){
				ats = getTagAttributes(DEFAULT_OMITTED_TAG_COLOR, false, false);
				omitted = false;
				
			} else if(str.toUpperCase().startsWith("<P>")
					|| str.toUpperCase().startsWith("</P>")){
				ats = getTagAttributes(DEFAULT_P_COLOR, false, false);

			} else if(inside){
				ats = getTagAttributes(DEFAULT_INNER_COLOR, false, true);
			
			} else if(omitted){
				ats = getTagAttributes(DEFAULT_OMITTED_TEXT_COLOR, false, true);
			}

			painelTexto.insereString(index, str, ats);
			index += str.length();
		}
	}

	private void limpaTexto(){
		painelTexto.removeTudo();
	}

	public void mouseClicked(MouseEvent me) {
		if(SwingUtilities.isRightMouseButton(me)){
			//int clicks = me.getClickCount();
			tagEM();
		}
	}

	public void mouseEntered(MouseEvent arg0) {
		// TODO Auto-generated method stub
	}

	public void mouseExited(MouseEvent arg0) {
		// TODO Auto-generated method stub
	}

	public void mousePressed(MouseEvent arg0) {
		// TODO Auto-generated method stub
	}

	public void mouseReleased(MouseEvent arg0) {
		// TODO Auto-generated method stub
	}
}
