public class Parser {

	private String texto;
	private int index;
	
	private final String REP_OPEN_ALT = ":::::";
	private final String REP_CLOSE_ALT = "::::::";
	
	public Parser(String t){
		
		//tirar os ALT para ser mais simples...
		//texto = t.replaceAll("<ALT>", REP_OPEN_ALT);
		//texto = texto.replaceAll("</ALT>", REP_CLOSE_ALT);
		
		texto = t;
		repAlts();
		index = 0;
	}

	public boolean verifica(){

		return start();
	}

	private boolean start(){

		int state = 0;
		String toClose = "";
		int inicio = -1;
		for(; index < texto.length(); index++){
			char c = texto.charAt(index);

			//System.out.println("state = "+state+", char = "+c);
			
			if(state == 0){
				if(c == '<')
					state = 1;
				else if(c == '>' || c == '/'){
					erro(state);
					return false;
				}
				
				continue;
			}

			if(state == 1){
				if(c == ' ')
					state = 2;
				else if(c == '<' || c == '/'){
					erro(state);
					return false;
				}
				else if(c == '>' && toClose == ""){
					erro(state);
					return false;
				}
				else if(c == '>')
					state = 3;
				else
					toClose += c;
				
				continue;
			}	

			if(state == 2){
								
				if(c == '>')
					state = 3;
				else if(c == '<' || c == '/'){
					erro(state);
					return false;
				}
				
				continue;
			}

			if(state == 3){
				
				if(c == '<')
					state = 4;
				else if(c == '>' || c == '/'){
					erro(state);
					return false;
				}
				
				continue;
			}

			if(state == 4){
				if(c == '/')
					state = 5;
				else{
					erro(state);
					return false;
				}
				
				continue;
			}

			if(state == 5){
				if(inicio == -1){
					inicio = index;
				}
				
				//System.out.println(toClose.length()+" "+(index-inicio));
				
				if(toClose.length() <=  index-inicio){
					erro(state);
					return false;
				} else if(toClose.charAt(index-inicio) != c){
					erro(state);
					return false;
				} else if((index - inicio) == toClose.length()-1){
					
					toClose = "";
					inicio = -1;
					state = 6;
				}
				
				continue;
			}

			if(state == 6){
				if(c == '>')
					state = 7;
				else{
					erro(state);
					return false;
				}
				
				continue;
			}

			if(state == 7){
				if(c == '<')
					state = 1;
				else if(c == '>' || c == '/'){
					erro(state);
					return false;
				}
				else
					state = 0;
				
				continue;
			}
		}
		
		return (state == 7 || state == 0);
	}

	private void erro(int state){

		//System.out.println("ERRO! state="+ state + ", char = "+texto.charAt(index)+", char index="+ index);
	}

	public int getIndex(){
		return index;
	}
	
	public char getActChar(){
		return texto.charAt(index);
	}
	
	public boolean verificaAlts(){
		
		//altsBack();
		
		String[] tokens = texto.split(" ");
		boolean aberto = false;
		
		for(String t : tokens){
			
			//System.out.println("--> "+t + " ; "+ REP_OPEN_ALT);
			
			if(t.equals(REP_OPEN_ALT)){
				
				System.out.println("ABERTO!");
				
				if(aberto)
					return false;
				else aberto = true;
			}

			if(t.equals(REP_CLOSE_ALT)){
				if(!aberto)
					return false;
				else aberto = false;
			}
		}
		
		return !aberto;
	}
	
	private void repAlts(){
		texto = texto.replaceAll("<ALT>", REP_OPEN_ALT);
		texto = texto.replaceAll("</ALT>", REP_CLOSE_ALT);
	}
	
	private void altsBack(){
		texto = texto.replaceAll(REP_CLOSE_ALT, "</ALT>");
		texto = texto.replaceAll(REP_OPEN_ALT, "<ALT>");
	}
	
	public static void main(String args[]){

		String sgml = "<PESSOA TIPO=\"INDIVIDUAL\" MORF=\"F,S\">D.Teresa</PESSOA>: - \"Ant�o\" n�o haver�amos de querer conversar com estes tr�s meninos t�o azadinhos e com a senhora professora. " +
		"<ALT></ALT><PESSOA TIPO=\"INDIVIDUAL\" MORF=\"F,S\">M�nica</PESSOA>: - Lembra-se como festejava o <TEMPO TIPO=\"CICLICO\" MORF=\"M,S\">Natal</TEMPO> antigamente?";

		/*Parser p = new Parser(sgml);
		System.out.println(p.verifica());
		System.out.println(p.verificaAlts());*/
	}
}

class ErroTagsException extends Exception{

	public ErroTagsException(){
		super("Erro tags!");
	}
}