import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.undo.*;

class RedoAction extends AbstractAction {

	private UndoManager undo;
	private Mediator mediator;
	private UndoAction undoAction;
	
	public RedoAction(UndoManager manager, Mediator med) {
		super("Repetir");
		undo = manager;
		mediator = med;
		setEnabled(false);
	}

	public void actionPerformed(ActionEvent e) {
		try {
			undo.redo();
		} catch (CannotRedoException ex) {
			//mediator.error("Erro", "Nao e' possivel repetir!");
			mediator.setFeedback("Nao e' possivel repetir!");
			System.out.println("Nao e' possivel repetir: " + ex);
			//ex.printStackTrace();
		}
		updateRedoState();
		
		if(undoAction != null)
			undoAction.updateUndoState();
	}

	protected void updateRedoState() {
		if (undo.canRedo()) {
			setEnabled(true);
			putValue(Action.NAME, undo.getRedoPresentationName());
		} else {
			setEnabled(false);
			putValue(Action.NAME, "Repetir");
		}
	}
	
	public void setUndoAction(UndoAction u){
		undoAction = u;
	}
}

