import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.JTextPane;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledDocument;


public class Texto extends JTextPane implements Searchable{

	private Mediator mediator;
	private Matcher matcher;
	private AbstractDocument doc;
	
	public Texto(Mediator m){
		super();
		
		mediator = m;
		setContentType("text/plain; charset=ISO-8859-1");
		
		StyledDocument styledDoc = getStyledDocument();
		if (styledDoc instanceof AbstractDocument) {
			doc = (AbstractDocument)styledDoc;
			//txtPane.setDocumentFilter(new DocumentSizeFilter(MAX_CHARACTERS));
		} else {
			System.err.println("Text pane's document isn't an AbstractDocument!");
			System.exit(-1);
		}
		
		doc.addUndoableEditListener(new MyUndoableEditListener());
	}

	public void insereString(int index, String aInserir, SimpleAttributeSet atribs){
		try{
			doc.insertString(index, aInserir, atribs);
		} catch (BadLocationException ble){
			System.err.println("Nao foi possivel inserir o texto. Inicio="+index);
		}
	}
	
	public void substitui(int indexI, int indexF, String texto, SimpleAttributeSet atribs){
		
		try {
			doc.replace(indexI, indexF, texto, atribs);
		} catch (BadLocationException e) {
			System.err.println("Nao foi possivel substituir o texto." +
					"Inicio="+indexI+"; Fim="+indexF);
		}
	}
	
	public void substituiSeleccao(String texto){
		
		replaceSelection(texto);
	}
	
	public void removeString(int indexI, int indexF){
		try{
			doc.remove(indexI, indexF);			
		} catch (BadLocationException ble){
			System.err.println("Nao foi possivel remover o texto." +
					"Inicio="+indexI+"; Fim="+indexF);
		}
	}
	
	public void removeTudo(){
		removeString(0, doc.getLength());
	}
	
	public int search(String searchString) {
		return search(searchString, -1);
	}

	public int search(String searchString, int columnIndex) {
		//Pattern pattern = null;
		if (searchString != null) {
			return search(Pattern.compile(searchString, 0), columnIndex);
		}
		return -1;
	}

	public int search(Pattern pattern) {
		return search(pattern, -1);
	}

	public int search(Pattern pattern, int startIndex) {
		return search(pattern, startIndex, false);
	}	
	
	/**
	 * @return end position of matching string or -1
	 */
	public int search(Pattern pattern, int startIndex, boolean backwards) {

		if (pattern == null) {
			return -1;
		}

		int start = startIndex + 1;
		int end = -1;

		Segment segment = new Segment();
		try {
			//AbstractDocument doc = getDocument();
			StyledDocument doc = this.getStyledDocument();
			doc.getText(start, doc.getLength() - start, segment);
		} catch (Exception ex) {
			ex.printStackTrace();
		}

		matcher = pattern.matcher(segment.toString());
		if (matcher.find()) {
			start = matcher.start() + startIndex;
			end = matcher.end() + startIndex;
			select(start + 1, end + 1);
		} else {
			return -1;
		}
		return end;
	}
	
//	This one listens for edits that can be undone.
	protected class MyUndoableEditListener
	implements UndoableEditListener {
		public void undoableEditHappened(UndoableEditEvent e) {
			//Remember the edit and update the menus.
			mediator.undoableEdit(e);
		}
	}
}
