import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.undo.*;

class UndoAction extends AbstractAction {

	private UndoManager undo;
	private Mediator mediator;
	private RedoAction redoAction;

	public UndoAction(UndoManager manager, Mediator med) {
		super("Anular");
		undo = manager;
		mediator = med;
		setEnabled(false);
	}

	public void actionPerformed(ActionEvent e) {
		try {
			undo.undo();
		} catch (CannotUndoException ex) {
			//mediator.error("Erro", "Nao e' possivel anular!");
			mediator.setFeedback("Nao e' possivel anular!");
			System.out.println("Nao e' possivel anular: " + ex);
			//ex.printStackTrace();
		}
		updateUndoState();
		
		if(redoAction != null)
			redoAction.updateRedoState();
	}

	protected void updateUndoState() {
				
		if (undo.canUndo()) {
			setEnabled(true);
			putValue(Action.NAME, undo.getUndoPresentationName());
		} else {
			setEnabled(false);
			putValue(Action.NAME, "Anular");
		}
	}
	
	public void setRedoAction(RedoAction r){
		redoAction = r;
	}
}