import java.awt.BorderLayout;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class ValNormDialog extends JDialog {

	private final String SIGNO_MAIS = "+";
	private final String SIGNO_MENOS = "-";
	private final String TRACINHO = "-";
	private final int ANO_MAX = 9999;
	private final int MAX = 99;
	
	private Mediator mediator;

	protected JComboBox signo;
	protected JTextField ano;
	protected JTextField mes;
	protected JTextField dia;
	protected JTextField hora;
	protected JTextField minuto;
	
	public ValNormDialog(Mediator frame) {
		/*super((Frame)SwingUtilities.getWindowAncestor((Component)searchable),
				"Localizar");*/

		super((JFrame)frame, "VAL_NORM");
		
		mediator = frame;
		
		GraphicsConfiguration gc =
			GraphicsEnvironment.getLocalGraphicsEnvironment().
			getDefaultScreenDevice().getDefaultConfiguration();
		Rectangle bounds = gc.getBounds();
		int x = bounds.x+bounds.width/3;
		int y = bounds.y+bounds.height/3;

		setLocation(x, y);

		initUI();
		pack();
	}

	private void initUI() {
		getContentPane().add(createFieldPanel(), BorderLayout.CENTER);
		getContentPane().add(createButtonPanel(), BorderLayout.SOUTH);
	}

	/**
	 * TODO: Strings should be removed from the UI
	 */
	private JComponent createFieldPanel() {

		// Create components
		signo = new JComboBox();
		signo.addItem(SIGNO_MAIS);
		signo.addItem(SIGNO_MENOS);
		
		ano = new JTextField(4);
		ano.setName("Ano");
		mes = new JTextField(2);
		mes.setName("Mes");
		dia = new JTextField(2);
		dia.setName("Dia");
		hora = new JTextField(2);
		hora.setName("Hora");
		minuto = new JTextField(2);
		minuto.setName("Minuto");
		
		JPanel painel = new JPanel(new GridLayout(6,2));
		painel.add(new JLabel("Signo: "));
		painel.add(signo);
		painel.add(new JLabel("Ano: "));
		painel.add(ano);
		painel.add(new JLabel("Mes: "));
		painel.add(mes);
		painel.add(new JLabel("Dia: "));
		painel.add(dia);
		painel.add(new JLabel("Hora: "));
		painel.add(hora);
		painel.add(new JLabel("Minuto: "));
		painel.add(minuto);
		
		return painel;
	}

	private JPanel createButtonPanel() {
		JPanel panel = new JPanel();

		Action findAction = new ValNormAction();
		Action closeAction = new CloseAction();

		JButton findButton;
		panel.add(findButton = new JButton(findAction));
		panel.add(new JButton(closeAction));

		// Bind the ESC key to CloseAction and ENTER to FindAction
		String CANCEL_ACTION_KEY = "CANCEL_ACTION_KEY";
		String ENTER_ACTION_KEY = "ENTER_ACTION_KEY";

		KeyStroke enterKey = KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0, false);
		KeyStroke escapeKey = KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0, false);

		InputMap inputMap = getRootPane().getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
		inputMap.put(enterKey, ENTER_ACTION_KEY);
		inputMap.put(escapeKey, CANCEL_ACTION_KEY);

		getRootPane().setDefaultButton(findButton);

		ActionMap actionMap = getRootPane().getActionMap();
		actionMap.put(ENTER_ACTION_KEY, findAction);
		actionMap.put(CANCEL_ACTION_KEY, closeAction);

		return panel;
	}

	public void buildAttribute() {
		
		//Uma Calendar para isto? - acho que nao pode ser por causa de Epoch...
		
		String sig = (String)signo.getSelectedItem();
		
		JTextField[] campos = {ano, mes, dia, hora, minuto};
		String[] valores = new String[campos.length];
		boolean anoOutOfBounds = false;
		
		for(int i = 0; i < campos.length; i++){
			
			String valor = "";
			boolean tracinhos = false;
			int digitos = campos[i].getColumns();
			
			if((campos[i].getText() != null && !campos[i].getText().equals(""))){
				
				valor = campos[i].getText().trim();
				
			} else {
				
				valor = tracinhos(digitos);
				tracinhos = true;
				
			}
			
			//validar
			if(!tracinhos && !valida(valor, digitos, campos[i].getName()))
				return;
			
			//ano > 9999 ou ano < -9999
			if(i == 0 && !tracinhos){
				int a = Integer.parseInt(valor);
				if(a > ANO_MAX || a < -ANO_MAX ){
					anoOutOfBounds = true;
					break;
				}		
			}
			
			//1 -> 01
			if(!tracinhos){
				for(int j = valor.length(); j < digitos; j++)
					valor = "0".concat(valor);
			}
			
			valores[i] = valor;
		}		
		
		if(anoOutOfBounds){
			valores[0] = ANO_MAX+"";
			for(int i = 1; i < valores.length; i++)
				valores[i] = MAX+"";
		}
		
		mediator.valNorm(sig, valores[0], valores[1], valores[2], valores[3], valores[4]);
	}
	
	private boolean valida(String valor, int digitos, String campo){
		
		try{
			Integer.parseInt(valor);
		} catch (NumberFormatException e) {
			mediator.error("Campo "+campo, "Conteudo do campo nao e' um inteiro!");
			return false;
		}
		
		//no caso do ano pode exceder -> 9999
		if(valor.length() > digitos && !campo.equals(ano.getName())){
			mediator.error("Campo "+campo,
					"Conteudo do campo tem mais de "+digitos+" digitos!");
			return false;
		}
			
		return true;
	}
	
	private String tracinhos(int n){
		String ret = new String();
		for(int i = 0; i < n; i++)
			ret = ret.concat(TRACINHO);
		return ret;
	}
	
	/**
	 * Action callback for Close action.
	 */
	public void doClose() {
		ValNormDialog.this.dispose();
	}

	/**
	 * Public method for testing.
	 */
	private class ValNormAction extends AbstractAction {

		public ValNormAction() {
			super("Ok");
		}

		public void actionPerformed(ActionEvent evt) {
			buildAttribute();
		}
	}

	private class CloseAction extends AbstractAction {
		public CloseAction() {
			super("Cancelar");
		}

		public void actionPerformed(ActionEvent evt) {
			doClose();
		}
	}

	private abstract class CheckAction extends AbstractAction {

		public CheckAction(String name) {
			super(name);
		}

		public void actionPerformed(ActionEvent evt) {

		}
	}

}