#!/usr/bin/perl

#AltinaMor - Escolhe as EM mais vantajosas nos identificadores de alternativas
#            Necessita do resultado do Vizir
#Rui Vilela - Linguateca 2005-2006

#Uso : [perl] altinaMor [-debug] -i FICHEIRO_RESULTADO_VIZIR [-o FICHEIRO_RESULTADOS]


use locale;
use strict;
#use Data::Dumper;
use Getopt::Long;

sub decidir{
    my ($a)=@_;
    my $s='';

    #Contabilizar Medida F
    my $MF=0; my %PF=();

    foreach my $alt (keys %{$a}){
        my $r=$a->{$alt};
	my $n=0;
	
	$r->{Pn}=0; $r->{An}=0; $r->{Fn}=0;
	$r->{Pg}=0; $r->{Ag}=0; $r->{Fg}=0;
	$r->{Pc}=0; $r->{Ac}=0; $r->{Fc}=0;
	$r->{gcorr}=1; $r->{ncorr}=1;  $r->{ccorr}=1;
	$r->{nc}=1; $r->{ncd}=1; 

	foreach my $par (keys %{$r}){
	    next unless ($par=~/[1-9]+/);

	    $r->{ncd} ++ if ($r->{$par}=~/\(Combinada: /);
	    $r->{gcorr} += $1 if ($r->{$par}=~/\(Gnero: \w+ ([\d\.]+)\)/);
	    $r->{ncorr} += $1 if ($r->{$par}=~/\(Nmero: \w+ ([\d\.]+)\)/);
	    $r->{ccorr} += $1 if ($r->{$par}=~/\(Combinada: \w+ ([\d\.]+)\)/);
	    $r->{nc} ++ unless ($r->{$par}=~/\[null\]/);
	    $n++

	}
    
	$r->{Pn}=$r->{ncorr}/$r->{nc};
	$r->{An}=$r->{ncorr}/$r->{ncd};
	$r->{Fn}=(2*$r->{An}*$r->{Pn})/($r->{An}+$r->{Pn});

	$r->{Pg}=$r->{gcorr}/$r->{nc};
	$r->{Ag}=$r->{gcorr}/$r->{ncd};
	$r->{Fg}=(2*$r->{Ag}*$r->{Pg})/($r->{Ag}+$r->{Pg});
	
	$r->{Pc}=$r->{ccorr}/$r->{nc};
	$r->{Ac}=$r->{ccorr}/$r->{ncd};
	$r->{Fc}=(2*$r->{Ac}*$r->{Pc})/($r->{Ac}+$r->{Pc});

	$r->{F} = $r->{Fg} + $r->{Fn} +  $r->{Fc};

	if ($r->{F}>=$MF){
	    %PF=() if ($r->{F}>$MF);
	    $PF{$alt}=$n;
	    $MF=$r->{F};
	}
    }
    #print Dumper $a;
    #print Dumper \%PF;

    my $alt=-1; my $max=-1;  ##Selectionar o maior nmero de pares caso haja vrios;
    foreach (keys %PF){
	$alt=$_ if ($PF{$_}>$max);
	$max=$PF{$_};
    }

    foreach my $par (keys %{$a->{$alt}}){
	next unless ($par=~/[1-9]+/);
	$s.=$a->{$alt}{$par}."\n";
    }
    $s=~s/\s*$//;
    
    return $s;
}

###############################################################################

my $fin='';
my $fout='';
my $debug=0;

GetOptions(debug => \$debug, 'i=s' => \$fin, 'o=s' => \$fout);

if ($fin eq ''){
    print "Uso: altinaMor.pl [-debug] -i FICHEIRO_RESULTADO_VIZIR [-o FICHEIRO_RESULTADOS]\n\n";
    exit;
}elsif (!(-e $fin || -r $fin)){
    die "No  possvel ler o ficheiro $fin !\n";
}


$fout = $fin.".altinamor" if ($fout eq '');

open my $F, "<$fin" || die "O ficheiro $fin no foi encontrado !\n$!\n";

die "Sem qualquer classificao morfolgica em $fin! \n" unless (grep { /---> \[<.+MORF\=\"/ } <$F>);
seek ($F,0,0); #rewind

open my $G, ">$fout" || die "No  possvel escrever os resultados no ficheiro $fout !\n$!\n";

my $D;
if ($debug){ 
    open $D, ">$fout.debug" || die "No  possvel escrever no ficheiro $fout.debug !\n$!\n"; 
    warn "Ficheiro $fout.debug contm o debug da seleco das ALT.\n";
}


my $alt=0; my $n_alt=0;
my %opc;

while (<$F>){
    chomp;
    if (/<ALT>/){
	print $D "$_\n" if ($debug);
	next;
    }elsif (/<ALT(\d)>/){    #caso seja a primeira etiqueta ALT
	$alt=$1;
	$n_alt=0;
	$opc{$alt}{$n_alt++}=''; #elemento vazio ?
	print $D "$_\n" if ($debug);
    }elsif (/<\/ALT(\d)>/){
	die "Etiqueta ALT incorrecta na linha $." if ($alt!=$1);
	print $D "$_\n" if ($debug);
    }elsif (/<\/ALT>/){
	$alt=0;
	print $D "$_\n" if ($debug);
	my $s = &decidir(\%opc);

	if ($debug){
	    foreach (sort keys %opc){
		my $r=$opc{$_};
		#print Dumper \$r;
		print $D "\nALT ->".$_;
		print $D "\nPreciso(Gnero -- Nmero -- Combinada): ".$r->{Pg}."=(".$r->{gcorr}."/".$r->{nc}.") -- ". $r->{Pn}."=(".$r->{ncorr}."/".$r->{nc}.") --  ".$r->{Pc}."=(".$r->{ccorr}."/".$r->{nc}.")";
		print $D "\nAbrangncia(Gnero -- Nmero -- Combinada): ".$r->{Ag}."=(".$r->{gcorr}."/".$r->{ncd}.") -- ".$r->{An}."=(".$r->{ncorr}."/".$r->{ncd}.") -- ".$r->{Ac}."=(".$r->{ccorr}."/".$r->{ncd}.")";
		print $D "\nMedidaF(Gnero + Nmero + Combinada = Soma): ".$r->{Fg}." + ".$r->{Fn}." + ".$r->{Fc}." = ".$r->{F}."\n\n";
	    }
	}
	print $G "$s\n" if ($s ne '');
	
	%opc=();
    }elsif ($alt!=0){
	#delete ($opc{$alt}{0}); #Elimina a marca do elemento vazio
	$opc{$alt}{$n_alt++}=$_;
	print $D "$_\n" if ($debug && $alt!=0);
    }else{
	print $G "$_\n";
    }

}

close ($F);
close ($G);
close ($D) if ($debug);
