#!/usr/bin/perl

#ida2mor
#Rui Vilela - Linguateca 2005-2006

#Uso : [perl] ida2mor.pl [-debug] -i FICHEIRO_RESULTADO_VIZIR_OU_ALTINAMOR [-o FICHEIRO_RESULTADOS]

use locale;
use warnings;
use strict;
use HAREM::ClassificacaoMorfologica;
use Getopt::Long;

my $debug=0;
my $fin = '';
my $fout = '';

GetOptions('debug' => \$debug, 'i=s' => \$fin, 'o=s' => \$fout);

if ($fin eq ''){
    print "Uso: ida2mor.pl [-debug] -i FICHEIRO_RESULTADO_VIZIR_OU_ALTINAMOR [-o FICHEIRO_RESULTADOS]\n\n";
    exit;
}elsif (!(-e $fin || -r $fin)){
    die "No  possvel ler o ficheiro $fin !\n";
}

$fout = $fin.".ida2mor" if ($fout eq '');

open my $F, "<$fin" || die "O ficheiro $fin no foi encontrado !\n$!\n";

die "Sem qualquer classificao morfolgica em $fin! \n" unless (grep { /---> \[<.+MORF\=\"/ } <$F>);
seek ($F,0,0); #rewind

open my $G, ">$fout" || die "No  possvel escrever os resultados no ficheiro $fout !\n$!\n";

my $D;
if ($debug){ 
    open $D, ">$fout.debug" || die "No  possvel escrever no ficheiro $fout.debug !\n$!\n"; 
    warn "Ficheiro $fout.debug contm o debug da seleco das ALT.\n";
}else{
    $D=0;
}


######################################################################################################

#No implementado
#my @t=(   #Permite modificar os resultados finais das estatisticas #No  validado o resultado ao final
#    {
#	"inicio_nome_ficheiro"=>"REMA", #Apenas o "REMA*.total"  afectado #Tem de ser definido
#       "fim_nome_ficheiro"=>".total",  #opcional
#       "Correcto"=>10,  #EMs com pontuao combinada correcta
#       "Incorrecto"=>-10,  #EMs com pontuao gnero, nmero, combinada incorrecta
#
#    },
#    {
#       "inicio_nome_ficheiro"=>"REMO",
#       "Incorrecto"=>-20,
#    }
#   );

my @t=();

#No Implementado
#@t=({"inicio_nome_ficheiro"=>"Palavras.","fim_nome_ficheiro"=>".total.vizir.altmor","Correcto"=>-13, "Incorrecto"=>13},
#       {"inicio_nome_ficheiro"=>"n", "fim_nome_ficheiro"=>".total.vizir.altmor", "Correcto"=>13, "Incorrecto"=>-13} );


&Estatisticas_ACMorfologica($F, $G, $D, \@t);

close ($F);
close ($G);
close ($D) if ($debug);
