#!/usr/bin/perl

#Vizir
#Rui Vilela - Linguateca 2005-2006
#uso: [perl] vizir.pl (-abs|-rel) -i FICHEIRO_PARA_AVALIAR -o FICHEIRO_RESULTADO

use locale;
use strict;
#use Data::Dumper;
use Getopt::Long;
use HAREM::ClassificacaoMorfologica;



my $rel=0; my $abs=0; my $fin=''; my $fout='';
GetOptions(abs => \$abs, rel => \$rel, 'i=s' => \$fin, 'o=s' => \$fout);

if ($fin eq ''){
    print "Uso: vizir.pl (-abs|-rel) -i FICHEIRO_PARA_AVALIAR [-o FICHEIRO_RESULTADOS]\n\n";
    exit;
}elsif (!($abs xor $rel)){
    die "Escolha um mtodo de avaliao (-abs|-rel)!\n";
}elsif (!(-e $fin || -r $fin)){
    die "No  possvel ler o ficheiro $fin !\n";
}

$fout = $fin.".vizir" if ($fout eq '');

open my $F, "<$fin" || die "O ficheiro $fin no foi encontrado !\n$!\n";

die "Sem qualquer classificao morfolgica em $fin !\n" unless (grep { /---> \[<.+MORF\=\"/ } <$F>);

seek ($F,0,0); #rewind

open my $G, ">$fout" || die "No  possvel escrever os resultados no ficheiro $fout !\n$!\n";

while (<$F>){
    chomp;
    if (/<VERIFICACAO_MANUAL>/ || /<OMITIDO>/ || /^\#/){
	next;
    }elsif (/ ---> /){
	s/ TIPO=\"[\w\|\?]+\"//g; #Remover Atributo TIPO
	s/<ESPURIO/</g;  #Substituir temporariamente a etiqueta esprio
	s/<\/ESPURIO/<\//g;
	s/<[[:alpha:]\|]+/<EM/g; #Substituir todas as etiquetas por EM
	s/<\/[[:alpha:]\|]+/<\/EM/g;
	s/</<ESPURIO/g;
	s/<\//<\/ESPURIO/g;
	if ($rel){
	    next if (/^<ESPURIO>/);
	    next if (/\[null\]/);
	}

	next if (/<EM><\/EM>/); ## No avaliar EMs vazias
	my $t=":[".&Avaliar_CMorfologica (&l($_))."]";
	s/\:\[.+\]$//;
	print $G "$_$t\n" if ($t ne ":[]");   #Ignorar pares no avaliados
    }else{
	print $G "$_\n";
    }

}		    

close ($F);
close ($G);

sub l{ # Para suportar etiquetao com o alinhEM
    $a=$_[0];
    $a=~s/<\/?\d+>//g;
    return $a;
}
